/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.publish.controller;

import com.jxdinfo.hussar.engine.metadata.exception.EngineException;
import com.jxdinfo.hussar.formdesign.codegenerator.core.generate.dto.DefaultStyleDTO;
import com.jxdinfo.hussar.formdesign.codegenerator.core.generate.front.ResourcePublishHandler;
import com.jxdinfo.hussar.formdesign.common.annotation.ExceptionCatcher;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.model.publish.CodeResult;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.publish.service.PublishService;
import com.jxdinfo.hussar.formdesign.publish.service.StyleSchemeService;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/speedcode/publish"})
public class PublishController {
    private Logger logger = LoggerFactory.getLogger(PublishController.class);
    @Autowired
    private PublishService publishService;
    @Autowired
    private ResourcePublishHandler resourcePublishHandler;
    @Autowired
    private StyleSchemeService styleSchemeService;

    @RequestMapping(value={"/vue"})
    public FormDesignResponse<List<CodeResult>> vue(@RequestParam String id) throws CloneNotSupportedException, EngineException {
        long publishStartTime = ToolUtil.getCurrentTime();
        FormDesignResponse speedCodeResponse = new FormDesignResponse();
        try {
            speedCodeResponse.setData(this.publishService.webVue(id));
            speedCodeResponse.setErrorCode(HttpStatus.OK.value());
            ToolUtil.triggerGarbageCollect();
        }
        catch (IOException e) {
            speedCodeResponse.setErrorCode(LcdpExceptionEnum.FILE_ERROR.getCode());
            this.logger.error("inputParams:{} and errorMessage:{}", new Object[]{id, e.getMessage(), e});
        }
        catch (LcdpException e) {
            speedCodeResponse.setErrorCode(LcdpExceptionEnum.FILE_ERROR.getCode());
            speedCodeResponse.setErrorMsg(e.getMessage());
            this.logger.error("inputParams:{} and errorMessage:{} \nand pageInfoPath:{}", new Object[]{id, ToolUtil.isNotEmpty((Object)e.getDetail()) ? e.getDetail() : "", ToolUtil.isNotEmpty((Object)e.getPageInfoPath()) ? e.getPageInfoPath() : "", e});
        }
        this.logger.debug("\u672c\u6b21({})\u53d1\u5e03\u603b\u65f6\u95f4\u4e3a\uff1a{}s", (Object)id, (Object)ToolUtil.logTime((long)publishStartTime));
        return speedCodeResponse;
    }

    @PostMapping(value={"/styleDefaultValue"})
    @ExceptionCatcher
    public FormDesignResponse<Boolean> styleDefaultValue(@RequestBody DefaultStyleDTO defaultStyleDTO) {
        FormDesignResponse formDesignResponse = new FormDesignResponse();
        try {
            this.publishService.defaultStyleGenerate(defaultStyleDTO);
            this.styleSchemeService.importDefault();
        }
        catch (LcdpException | IOException e) {
            formDesignResponse.setErrorCode(40001);
            e.printStackTrace();
        }
        return formDesignResponse;
    }

    @PostMapping(value={"/writeMergeCode"})
    public FormDesignResponse<Void> writeMergeCode(@RequestBody List<CodeResult> codeResults) throws IOException {
        this.publishService.writeMergeCode(codeResults);
        return new FormDesignResponse();
    }

    @RequestMapping(value={"/menu/{id}"})
    public FormDesignResponse<String> saveMenu(@PathVariable String id, @RequestParam String isSet) {
        FormDesignResponse response = new FormDesignResponse();
        try {
            response = this.resourcePublishHandler.publishMenu(id, isSet);
        }
        catch (IOException e) {
            this.logger.error("\u914d\u7f6e\u83dc\u5355\u5931\u8d25\uff0cIO\u5f02\u5e38{}", (Object)isSet);
            response.setErrorCode(10001);
            response.setErrorMsg("\u914d\u7f6e\u83dc\u5355\u5931\u8d25");
        }
        catch (LcdpException e) {
            this.logger.error("\u914d\u7f6e\u83dc\u5355\u5931\u8d25\uff0c\u8bbe\u8ba1\u5668\u5185\u90e8\u5f02\u5e38{}", (Object)isSet);
            response.setErrorCode(10001);
            response.setErrorMsg("\u914d\u7f6e\u83dc\u5355\u5931\u8d25");
        }
        return response;
    }

    @RequestMapping(value={"/mobile"})
    public FormDesignResponse<List<CodeResult>> mobile(@RequestParam String id) throws EngineException {
        FormDesignResponse speedCodeResponse = new FormDesignResponse();
        try {
            speedCodeResponse.setData(this.publishService.mobileVue(id));
            speedCodeResponse.setErrorCode(HttpStatus.OK.value());
            ToolUtil.triggerGarbageCollect();
        }
        catch (IOException e) {
            speedCodeResponse.setErrorCode(LcdpExceptionEnum.FILE_ERROR.getCode());
            this.logger.error("inputParams:{} and errorMessage:{}", new Object[]{id, e.getMessage(), e});
        }
        catch (LcdpException e) {
            speedCodeResponse.setErrorCode(LcdpExceptionEnum.FILE_ERROR.getCode());
            this.logger.error("inputParams:{} and errorMessage:{}", new Object[]{id, e.getMessage(), e});
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return speedCodeResponse;
    }
}

