/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.publish.controller;

import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.engine.metadata.exception.EngineException;
import com.jxdinfo.hussar.formdesign.auth.FormDesignUser;
import com.jxdinfo.hussar.formdesign.collaboration.lock.model.StorageLockPO;
import com.jxdinfo.hussar.formdesign.collaboration.lock.service.IndexStorageLockService;
import com.jxdinfo.hussar.formdesign.common.auth.UserKit;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.model.AdjustWorkflowInfo;
import com.jxdinfo.hussar.formdesign.common.model.BaseFile;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.WorkflowService;
import com.jxdinfo.hussar.formdesign.publish.service.WorkFlowPublishService;
import com.jxdinfo.hussar.formdesign.storage.common.model.StorageResult;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.workflow.manage.engine.DefinitionEngineService;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class WorkFlowPublishController {
    private WorkFlowPublishService workFlowPublishService;
    private final FormDesignProperties formDesignProperties;
    private final IndexStorageLockService indexStorageLockService;
    private WorkflowService workflowService;

    @Autowired
    public WorkFlowPublishController(WorkFlowPublishService workFlowPublishService, FormDesignProperties formDesignProperties, IndexStorageLockService indexStorageLockService, WorkflowService workflowService) {
        this.workFlowPublishService = workFlowPublishService;
        this.formDesignProperties = formDesignProperties;
        this.indexStorageLockService = indexStorageLockService;
        this.workflowService = workflowService;
    }

    @RequestMapping(value={"/speedcode/publish/workflow"})
    public FormDesignResponse<?> workflowPublish(@RequestParam String id, @RequestParam boolean isOverride) throws CloneNotSupportedException {
        FormDesignResponse<Object> speedCodeResponse = new FormDesignResponse<Object>();
        try {
            speedCodeResponse = this.workFlowPublishService.publish(id, isOverride);
            if (speedCodeResponse.getErrorCode() == 500) {
                speedCodeResponse.setErrorCode(HttpStatus.OK.value());
            }
        }
        catch (IOException e) {
            speedCodeResponse.setErrorCode(LcdpExceptionEnum.FILE_ERROR.getCode());
            e.printStackTrace();
        }
        catch (LcdpException e) {
            speedCodeResponse.setErrorCode(LcdpExceptionEnum.FILE_ERROR.getCode());
            e.printInfo();
        }
        catch (EngineException e) {
            e.printStackTrace();
        }
        return speedCodeResponse;
    }

    @PostMapping(value={"/speed/workflowinfo/adjustProcess"})
    public FormDesignResponse<Object> adjustProcess(@RequestBody AdjustWorkflowInfo workflowInfo) throws IOException, LcdpException, CloneNotSupportedException {
        FormDesignResponse sharedStorage;
        if (this.formDesignProperties.getScenes().isSharedStorage() && (sharedStorage = this.isSharedStorage(workflowInfo.getModelId())).getErrorCode() != 200) {
            return sharedStorage;
        }
        boolean flag = DefinitionEngineService.queryIsPublish((String)workflowInfo.getIdentity());
        FormDesignResponse<Object> speedCodeResponse = new FormDesignResponse<Object>();
        if (ToolUtil.isNotEmpty((Object)workflowInfo.getData())) {
            if (!flag) {
                try {
                    speedCodeResponse = this.workFlowPublishService.publish(workflowInfo.getId(), workflowInfo.getOverride());
                }
                catch (IOException e) {
                    speedCodeResponse.setErrorCode(LcdpExceptionEnum.FILE_ERROR.getCode());
                    e.printStackTrace();
                }
                catch (LcdpException e) {
                    speedCodeResponse.setErrorCode(LcdpExceptionEnum.FILE_ERROR.getCode());
                    e.printInfo();
                }
                catch (EngineException e) {
                    e.printStackTrace();
                }
                return speedCodeResponse;
            }
            try {
                return this.workflowService.adjustProcess(workflowInfo);
            }
            catch (HussarException e) {
                if (e.getExceptionCode() == 10010) {
                    speedCodeResponse.setErrorCode(e.getExceptionCode().intValue());
                    speedCodeResponse.setErrorMsg(e.getMessage());
                    return speedCodeResponse;
                }
                throw e;
            }
        }
        this.workflowService.updateFileMeta((BaseFile)workflowInfo);
        return new FormDesignResponse();
    }

    private FormDesignResponse isSharedStorage(String id) {
        Long userId;
        StorageResult result;
        FormDesignUser user = null;
        try {
            user = UserKit.getUser();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        FormDesignResponse speedCodeResponse = new FormDesignResponse();
        if (ToolUtil.isEmpty((Object)user)) {
            speedCodeResponse.setErrorCode(400);
            speedCodeResponse.setErrorMsg("\u8bf7\u5148\u767b\u5f55");
            return speedCodeResponse;
        }
        if (this.formDesignProperties.isLockEnabled() && ToolUtil.isNotEmpty((Object)(result = this.indexStorageLockService.getOneLockByResource(id)).getData()) && (!ToolUtil.isNotEmpty((Object)(userId = ((StorageLockPO)result.getData()).getUserId())) || !userId.equals(user.getId()))) {
            speedCodeResponse.setErrorCode(403);
            speedCodeResponse.setErrorMsg(((StorageLockPO)result.getData()).getUserName() + "\u6b63\u5728\u5360\u7528");
            return speedCodeResponse;
        }
        return new FormDesignResponse();
    }
}

