/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.publish.controller;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.file.FileWriter;
import cn.hutool.core.util.StrUtil;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.publish.util.CompileUtil;
import java.util.ArrayList;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/speedcode/preview"})
public class PreviewController {
    @Resource
    FormDesignProperties formDesignProperties;

    @PostMapping(value={"/restart"})
    public FormDesignResponse<String> restart() {
        FormDesignResponse response = new FormDesignResponse();
        String triggerFilePath = this.formDesignProperties.getProjectPath() + "\\src\\main\\resources\\restart.trigger";
        if (Convert.toBool((Object)this.formDesignProperties.getRestart()).booleanValue()) {
            new FileWriter(triggerFilePath).write(DateUtil.now());
            response.setData((Object)"restart");
        } else {
            response.setData((Object)"noRestart");
        }
        return response;
    }

    @PostMapping
    public FormDesignResponse<String> getRequest() {
        FormDesignResponse response = new FormDesignResponse();
        response.setErrorCode(200);
        return response;
    }

    @PostMapping(value={"/compile"})
    public FormDesignResponse<?> test(@RequestParam(required=false) String path) {
        FormDesignResponse response = new FormDesignResponse();
        String javaCodePath = this.formDesignProperties.getJavaCodePath();
        String javaPath = this.formDesignProperties.getJavaPath();
        if (StrUtil.isEmpty((CharSequence)path)) {
            path = this.formDesignProperties.getBackProjectPath() + javaCodePath + javaPath;
        }
        String dest = this.formDesignProperties.getBackProjectPath() + "\\target\\classes\\";
        ArrayList<String> options = new ArrayList<String>();
        options.add("-d");
        options.add(dest);
        try {
            CompileUtil.compileAndCopyFiles(path, dest, options, "UTF-8", this.formDesignProperties.getProjectPath() + "\\src\\main\\java\\");
            response.setErrorCode(200);
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setErrorCode(500);
            response.setErrorMsg("\u7f16\u8bd1\u5931\u8d25\uff01");
        }
        return response;
    }
}

