/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.publish.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.formdesign.back.adapter.ModelProvideAdapter;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.ModelBeanUtil;
import com.jxdinfo.hussar.formdesign.back.provider.DataModelProvider;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.model.WorkflowInfo;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.WorkflowService;
import com.jxdinfo.hussar.formdesign.publish.model.WorkGenCodeResult;
import com.jxdinfo.hussar.formdesign.publish.service.BackPublishService;
import com.jxdinfo.hussar.formdesign.publish.service.WorkFlowPublishService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.WorkFlow;
import com.jxdinfo.hussar.workflow.manage.bpm.model.service.GodAxeModelService;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class WorkFlowPublishServiceImpl
implements WorkFlowPublishService {
    @Resource
    private WorkflowService workflowService;
    @Resource
    private FileMappingService fileMappingService;
    @Resource
    private GodAxeModelService godAxeModelService;
    @Resource
    private BackPublishService backPublishService;

    @Override
    public FormDesignResponse<Object> publish(String id) throws IOException, LcdpException, CloneNotSupportedException {
        WorkflowInfo workflowInfo = (WorkflowInfo)this.workflowService.get(id);
        this.bindWorkFlowDataModel(workflowInfo);
        String modelId = "";
        if (ToolUtil.isNotEmpty((Object)workflowInfo.getRelateFiles())) {
            for (Map.Entry set : workflowInfo.getRelateFiles().entrySet()) {
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("id", set.getKey());
                params.put("publishIds", "WebPage");
                modelId = (String)set.getKey();
                this.backPublishService.publishBackCode(params);
            }
        }
        String tenantId = BaseSecurityUtil.getUser().getStringTenantId();
        return this.publish(tenantId, workflowInfo, modelId);
    }

    private FormDesignResponse<Object> publish(String tenantId, WorkflowInfo workflowInfo, String modelId) throws IOException, LcdpException {
        List result;
        DataModelProvider dataModelProvider;
        FormDesignResponse speedCodeResponse = new FormDesignResponse();
        ApiResponse obj = this.godAxeModelService.saveAndPublish(this.dealData(workflowInfo), tenantId);
        if (!obj.isSuccess()) {
            speedCodeResponse.setErrorMsg("\u4fdd\u5b58\u5e76\u53d1\u5e03\u65f6\u51fa\u9519\uff1a" + obj.getMsg());
            speedCodeResponse.setErrorCode(500);
            return speedCodeResponse;
        }
        String processDefKey = obj.getMsg();
        if (ToolUtil.isNotEmpty((Object)modelId)) {
            dataModelProvider = ModelProvideAdapter.adaptor((String)modelId);
        } else if (!((FormDesignProperties)SpringUtil.getBean(FormDesignProperties.class)).isLocalUnReset() && !((FormDesignProperties)SpringUtil.getBean(FormDesignProperties.class)).isOfflineLr()) {
            dataModelProvider = ModelBeanUtil.getModelProviderBean((String)"MYSQL");
        } else {
            return speedCodeResponse;
        }
        try {
            result = dataModelProvider.visitorGeneration(processDefKey, workflowInfo.geteName(), this.fileMappingService.getFormatPath(workflowInfo.getParentId()), modelId);
        }
        catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        if (result == null) {
            speedCodeResponse.setErrorMsg("\u5de5\u4f5c\u6d41\u751f\u6210\u4ee3\u7801\u65f6\u51fa\u9519\uff1a\u5b58\u5728\u53d8\u91cf\u5173\u8054\u5f02\u5e38\u7684\u6570\u636e\u6e90");
            speedCodeResponse.setErrorCode(500);
            return speedCodeResponse;
        }
        List<WorkGenCodeResult> genCodeResult = this.backPublishService.publishBpmActivityVisitorCode(result);
        speedCodeResponse.setData(genCodeResult);
        return speedCodeResponse;
    }

    private void bindWorkFlowDataModel(WorkflowInfo workflowInfo) {
        JSONObject processBinding;
        JSONObject props;
        JSONObject workFlowData = JSON.parseObject((String)workflowInfo.getData());
        if (ToolUtil.isNotEmpty((Object)workFlowData) && ToolUtil.isNotEmpty((Object)workFlowData.get((Object)"props")) && ToolUtil.isNotEmpty((Object)(props = workFlowData.getJSONObject("props"))) && ToolUtil.isNotEmpty((Object)props.get((Object)"processBinding")) && ToolUtil.isNotEmpty((Object)(processBinding = props.getJSONObject("processBinding")).getString("id"))) {
            HashMap<String, Integer> relateFiles = new HashMap<String, Integer>();
            relateFiles.put(processBinding.getString("id"), 1);
            workflowInfo.setRelateFiles(relateFiles);
        }
    }

    private WorkFlow dealData(WorkflowInfo workflowService) {
        WorkFlow workFlow = new WorkFlow();
        workFlow.setId(workflowService.getId());
        workFlow.setData(workflowService.getData());
        workFlow.setDesc(workflowService.getDesc());
        workFlow.setName(workflowService.getName());
        workFlow.setType(workflowService.getType());
        workFlow.setModelId(workflowService.getModelId());
        workFlow.setIdentity(workflowService.getIdentity());
        workFlow.setProcDefId(workflowService.getProcDefId());
        return workFlow;
    }
}

