/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.speedcode.codegenerator.core.publish.controller;

import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.speedcode.auth.FormDesignUser;
import com.jxdinfo.hussar.speedcode.codegenerator.core.publish.service.WorkFlowPublishService;
import com.jxdinfo.hussar.speedcode.collaboration.lock.model.StorageLockPO;
import com.jxdinfo.hussar.speedcode.collaboration.lock.service.IndexStorageLockService;
import com.jxdinfo.hussar.speedcode.common.auth.UserKit;
import com.jxdinfo.hussar.speedcode.common.exception.LcdpException;
import com.jxdinfo.hussar.speedcode.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.speedcode.common.model.BaseFile;
import com.jxdinfo.hussar.speedcode.common.model.WorkflowInfo;
import com.jxdinfo.hussar.speedcode.common.properties.SpeedCodeProperties;
import com.jxdinfo.hussar.speedcode.common.response.SpeedCodeResponse;
import com.jxdinfo.hussar.speedcode.file.fileoperate.service.WorkflowService;
import com.jxdinfo.hussar.speedcode.storage.common.model.StorageResult;
import com.jxdinfo.hussar.workflow.manage.engine.DefinitionEngineService;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class WorkFlowPublishController {
    private WorkFlowPublishService workFlowPublishService;
    private final SpeedCodeProperties speedCodeProperties;
    private final IndexStorageLockService indexStorageLockService;
    private WorkflowService workflowService;

    @Autowired
    public WorkFlowPublishController(WorkFlowPublishService workFlowPublishService, SpeedCodeProperties speedCodeProperties, IndexStorageLockService indexStorageLockService, WorkflowService workflowService) {
        this.workFlowPublishService = workFlowPublishService;
        this.speedCodeProperties = speedCodeProperties;
        this.indexStorageLockService = indexStorageLockService;
        this.workflowService = workflowService;
    }

    @RequestMapping(value={"/speedcode/publish/workflow"})
    public SpeedCodeResponse<?> workflowPublish(@RequestParam String id) {
        SpeedCodeResponse<Object> speedCodeResponse = new SpeedCodeResponse<Object>();
        try {
            speedCodeResponse = this.workFlowPublishService.publish(id);
            speedCodeResponse.setErrorCode(HttpStatus.OK.value());
        }
        catch (IOException e) {
            speedCodeResponse.setErrorCode(LcdpExceptionEnum.FILE_ERROR.getCode());
            e.printStackTrace();
        }
        catch (LcdpException e) {
            speedCodeResponse.setErrorCode(LcdpExceptionEnum.FILE_ERROR.getCode());
            e.printInfo();
        }
        return speedCodeResponse;
    }

    @PutMapping(value={"/speed/workflowinfo/adjustProcess"})
    public SpeedCodeResponse<Object> adjustProcess(@RequestBody WorkflowInfo workflowInfo) throws IOException, LcdpException {
        SpeedCodeResponse sharedStorage;
        if (this.speedCodeProperties.getScenes().isSharedStorage() && (sharedStorage = this.isSharedStorage(workflowInfo.getModelId())).getErrorCode() != 200) {
            return sharedStorage;
        }
        boolean flag = DefinitionEngineService.queryIsPublish((String)workflowInfo.getIdentity());
        if (ToolUtil.isNotEmpty((Object)workflowInfo.getData())) {
            if (!flag) {
                SpeedCodeResponse<Object> speedCodeResponse = new SpeedCodeResponse<Object>();
                try {
                    speedCodeResponse = this.workFlowPublishService.publish(workflowInfo.getId());
                }
                catch (IOException e) {
                    speedCodeResponse.setErrorCode(LcdpExceptionEnum.FILE_ERROR.getCode());
                    e.printStackTrace();
                }
                catch (LcdpException e) {
                    speedCodeResponse.setErrorCode(LcdpExceptionEnum.FILE_ERROR.getCode());
                    e.printInfo();
                }
                return speedCodeResponse;
            }
            return this.workflowService.adjustProcess(workflowInfo);
        }
        this.workflowService.updateFileMeta((BaseFile)workflowInfo);
        return new SpeedCodeResponse();
    }

    private SpeedCodeResponse isSharedStorage(String id) {
        Long userId;
        StorageResult result;
        FormDesignUser user = null;
        try {
            user = UserKit.getUser();
        }
        catch (Exception exception) {
            // empty catch block
        }
        SpeedCodeResponse speedCodeResponse = new SpeedCodeResponse();
        if (com.jxdinfo.hussar.speedcode.common.util.ToolUtil.isEmpty((Object)user)) {
            speedCodeResponse.setErrorCode(400);
            speedCodeResponse.setErrorMsg("\u8bf7\u5148\u767b\u5f55");
            return speedCodeResponse;
        }
        if (this.speedCodeProperties.isLockEnabled() && com.jxdinfo.hussar.speedcode.common.util.ToolUtil.isNotEmpty((Object)(result = this.indexStorageLockService.getOneLockByResource(id)).getData()) && (!com.jxdinfo.hussar.speedcode.common.util.ToolUtil.isNotEmpty((Object)(userId = ((StorageLockPO)result.getData()).getUserId())) || !userId.equals(user.getId()))) {
            speedCodeResponse.setErrorCode(403);
            speedCodeResponse.setErrorMsg(((StorageLockPO)result.getData()).getUserName() + "\u6b63\u5728\u5360\u7528");
            return speedCodeResponse;
        }
        return new SpeedCodeResponse();
    }
}

