// The Vue build version to load with the `import` command
// (runtime-only or standalone) has been set in webpack.base.conf with an alias.
import Vue from 'vue'
import store from '@/store'
import ionic from '@ionic/vue';
import Meta from 'vue-meta'
import router from '@/router'
import VueClipboard from 'vue-clipboard2'
import vant, { Icon as vantIcon } from 'vant';
import numeral from 'numeral';
import accountingNumFormat from '@/utils/accountingNumFormat'
import moment from 'moment';
import VueAMap from 'vue-amap';
import App from '@/${vuePath}.vue'
import echarts from '@/echarts'
import 'vant/lib/index.css';
import '@/icons'
import '@/config/routerStick'
import '@ionic/core/css/ionic.bundle.css';
import '@/assets/css/default_value.css'
// import '@/assets/css/base.css'
import '@/assets/styles/reset.css'//样式重置文件
import '@/assets/styles/border.css'//样式重置文件
import '@/assets/icon/iconfont.css'
import '@/assets/fonts/ionicIcon/iconfont.css';
import '@/assets/fonts/ionicIcon/iconfont';
import '@/assets/fonts/axeMobile/iconfont.css';
import '@/assets/fonts/axeMobile/iconfont';
import '@/custom'

Vue.use(VueClipboard)
Vue.use(vant)
Vue.use(vantIcon);
Vue.use(ionic);
Vue.use(VueAMap);
Vue.use(Meta)

Vue.prototype.$numeral = numeral;
Vue.prototype.$moment = moment;
Vue.prototype.$accountingNumFormat = accountingNumFormat
Vue.prototype.$echarts = echarts
VueAMap.initAMapApiLoader({
  v: '1.4.4',
  key: process.env.VUE_APP_AMAP_KEY, // 从 webpack 环境变量拿到高德地图 Web 端 API 的 key
  plugin: ['AMap.Scale', 'AMap.ToolBar', 'AMap.Autocomplete', 'AMap.PlaceSearch', 'AMap.Geolocation', 'AMap.Geocoder'],
});
Vue.config.productionTip = false


/* eslint-disable no-new */
new Vue({
  router,
  store,
  render: h => h(App),

}).$mount('#app')

