/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.speedcode.codegenerator.core.publish.controller;

import com.jxdinfo.hussar.speedcode.codegenerator.core.generate.style.ThemeVars;
import com.jxdinfo.hussar.speedcode.codegenerator.core.publish.service.ThemeVarsService;
import com.jxdinfo.hussar.speedcode.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.speedcode.common.response.SpeedCodeResponse;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/speedcode/themeVars"})
public class ThemeVarsController {
    private final ThemeVarsService themeVarsService;

    @Autowired
    public ThemeVarsController(ThemeVarsService themeVarsService) {
        this.themeVarsService = themeVarsService;
    }

    @GetMapping(value={""})
    public SpeedCodeResponse<ThemeVars> get() {
        SpeedCodeResponse speedCodeResponse = new SpeedCodeResponse();
        try {
            ThemeVars themeVars = this.themeVarsService.get();
            speedCodeResponse.setData((Object)themeVars);
        }
        catch (IOException e) {
            speedCodeResponse.setErrorCode(LcdpExceptionEnum.FILE_WRITE_FAIL.getCode());
            speedCodeResponse.setErrorMsg(LcdpExceptionEnum.FILE_WRITE_FAIL.getMsg());
        }
        return speedCodeResponse;
    }

    @PostMapping(value={""})
    public SpeedCodeResponse<Void> save(@RequestBody ThemeVars themeVars) {
        SpeedCodeResponse speedCodeResponse = new SpeedCodeResponse();
        try {
            this.themeVarsService.saveOrUpdate(themeVars);
        }
        catch (IOException e) {
            speedCodeResponse.setErrorCode(LcdpExceptionEnum.FILE_WRITE_FAIL.getCode());
            speedCodeResponse.setErrorMsg(LcdpExceptionEnum.FILE_WRITE_FAIL.getMsg());
        }
        return speedCodeResponse;
    }

    @DeleteMapping(value={""})
    public SpeedCodeResponse<Void> delete() {
        SpeedCodeResponse speedCodeResponse = new SpeedCodeResponse();
        try {
            this.themeVarsService.delete();
        }
        catch (IOException e) {
            speedCodeResponse.setErrorCode(LcdpExceptionEnum.FILE_WRITE_FAIL.getCode());
            speedCodeResponse.setErrorMsg(LcdpExceptionEnum.FILE_WRITE_FAIL.getMsg());
        }
        return speedCodeResponse;
    }

    @GetMapping(value={"/{name}"})
    public SpeedCodeResponse<ThemeVars> get(@PathVariable String name) {
        SpeedCodeResponse speedCodeResponse = new SpeedCodeResponse();
        try {
            ThemeVars themeVars = this.themeVarsService.get(name);
            speedCodeResponse.setData((Object)themeVars);
        }
        catch (IOException e) {
            speedCodeResponse.setErrorCode(LcdpExceptionEnum.FILE_WRITE_FAIL.getCode());
            speedCodeResponse.setErrorMsg(LcdpExceptionEnum.FILE_WRITE_FAIL.getMsg());
        }
        return speedCodeResponse;
    }

    @PostMapping(value={"/{name}"})
    public SpeedCodeResponse<Void> save(@PathVariable String name, @RequestBody ThemeVars themeVars) {
        SpeedCodeResponse speedCodeResponse = new SpeedCodeResponse();
        try {
            this.themeVarsService.saveOrUpdate(name, themeVars);
        }
        catch (IOException e) {
            speedCodeResponse.setErrorCode(LcdpExceptionEnum.FILE_WRITE_FAIL.getCode());
            speedCodeResponse.setErrorMsg(LcdpExceptionEnum.FILE_WRITE_FAIL.getMsg());
        }
        return speedCodeResponse;
    }

    @DeleteMapping(value={"/{name}"})
    public SpeedCodeResponse<Void> delete(@PathVariable String name) {
        SpeedCodeResponse speedCodeResponse = new SpeedCodeResponse();
        try {
            this.themeVarsService.delete(name);
        }
        catch (IOException e) {
            speedCodeResponse.setErrorCode(LcdpExceptionEnum.FILE_WRITE_FAIL.getCode());
            speedCodeResponse.setErrorMsg(LcdpExceptionEnum.FILE_WRITE_FAIL.getMsg());
        }
        return speedCodeResponse;
    }
}

