/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.speedcode.codegenerator.core.publish.controller;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.file.FileWriter;
import cn.hutool.core.util.StrUtil;
import com.jxdinfo.hussar.speedcode.codegenerator.core.publish.util.CompileUtil;
import com.jxdinfo.hussar.speedcode.common.properties.SpeedCodeProperties;
import com.jxdinfo.hussar.speedcode.common.response.SpeedCodeResponse;
import java.util.ArrayList;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/speedcode/preview"})
public class PreviewController {
    @Resource
    SpeedCodeProperties speedCodeProperties;

    @PostMapping(value={"/restart"})
    public SpeedCodeResponse<String> restart() {
        SpeedCodeResponse response = new SpeedCodeResponse();
        String triggerFilePath = this.speedCodeProperties.getProjectPath() + "\\src\\main\\resources\\restart.trigger";
        if (Convert.toBool((Object)this.speedCodeProperties.getRestart()).booleanValue()) {
            new FileWriter(triggerFilePath).write(DateUtil.now());
            response.setData((Object)"restart");
        } else {
            response.setData((Object)"noRestart");
        }
        return response;
    }

    @PostMapping
    public SpeedCodeResponse<String> getRequest() {
        SpeedCodeResponse response = new SpeedCodeResponse();
        response.setErrorCode(200);
        return response;
    }

    @PostMapping(value={"/compile"})
    public SpeedCodeResponse<?> test(@RequestParam(required=false) String path) {
        SpeedCodeResponse response = new SpeedCodeResponse();
        String javaCodePath = this.speedCodeProperties.getJavaCodePath();
        String javaPath = this.speedCodeProperties.getJavaPath();
        if (StrUtil.isEmpty((CharSequence)path)) {
            path = this.speedCodeProperties.getBackProjectPath() + javaCodePath + javaPath;
        }
        String dest = this.speedCodeProperties.getBackProjectPath() + "\\target\\classes\\";
        ArrayList<String> options = new ArrayList<String>();
        options.add("-d");
        options.add(dest);
        try {
            CompileUtil.compileAndCopyFiles(path, dest, options, "UTF-8", this.speedCodeProperties.getProjectPath() + "\\src\\main\\java\\");
            response.setErrorCode(200);
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setErrorCode(500);
            response.setErrorMsg("\u7f16\u8bd1\u5931\u8d25\uff01");
        }
        return response;
    }
}

