/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.speedcode.codegenerator.core.publish.controller;

import com.jxdinfo.hussar.engine.metadata.exception.EngineException;
import com.jxdinfo.hussar.speedcode.codegenerator.core.publish.service.BackPublishService;
import com.jxdinfo.hussar.speedcode.common.exception.LcdpException;
import com.jxdinfo.hussar.speedcode.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.speedcode.common.model.PageInfo;
import com.jxdinfo.hussar.speedcode.common.model.publish.GenCodeResult;
import com.jxdinfo.hussar.speedcode.common.response.SpeedCodeResponse;
import com.jxdinfo.hussar.speedcode.util.LRPushUtil;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/speedcode/back/publish"})
public class BackPublishController {
    private static final Logger logger = LoggerFactory.getLogger(BackPublishController.class);
    @Autowired
    private BackPublishService backPublishService;

    @RequestMapping(value={"/dataModel"})
    public SpeedCodeResponse<List<GenCodeResult>> publishDataModel(@RequestBody Map<String, String> param) throws IOException, LcdpException {
        SpeedCodeResponse genCodeResultSpeedCodeResponse = new SpeedCodeResponse();
        List<GenCodeResult> backCodeResult = this.backPublishService.publishBackCode(param);
        genCodeResultSpeedCodeResponse.setData(backCodeResult);
        return genCodeResultSpeedCodeResponse;
    }

    @GetMapping(value={"/xml"})
    public SpeedCodeResponse<List<String>> getXmlFileCode(@RequestParam String dataModelId, @RequestParam String operationId) throws IOException, LcdpException {
        SpeedCodeResponse response = new SpeedCodeResponse();
        response.setData(this.backPublishService.getXmlCode(dataModelId, operationId));
        response.setErrorCode(LcdpExceptionEnum.FILE_DONE.getCode());
        return response;
    }

    @PostMapping(value={"/table"})
    public SpeedCodeResponse<PageInfo> saveDataInfo(@RequestBody String id) throws IOException, LcdpException {
        id = id.replace("\"", "");
        SpeedCodeResponse response = new SpeedCodeResponse();
        try {
            LRPushUtil.getTLrMetadataParamForIdEdit((String)id);
            response.setErrorCode(HttpStatus.OK.value());
        }
        catch (EngineException e) {
            logger.error(e.getMessage());
            response.setErrorCode(e.getCode());
            response.setErrorMsg(e.getMessage());
            return response;
        }
        return new SpeedCodeResponse();
    }
}

