/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.structural.merge.util;

import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.util.CodeSplitUtil;
import com.jxdinfo.hussar.formdesign.structural.model.IndexModel;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ParseVueMethodsUtil {
    private static final Pattern METHOD_PATTERN = Pattern.compile("[a-zA-Z_][a-zA-Z0-9_]+\\(.*?\\)\\{");
    private static final String METHODS_START = "<script";
    private static final String METHODS_END = "</script>";
    private static final String COMMENT_START = "/* lcdp methodName \u4ee3\u7801\u5408\u5e76\u4f7f\u7528\u552f\u4e00\u6807\u8bc6";
    private static final String COMMENT_END = " */";
    public static final String REGEX = "^" + Pattern.quote("/* lcdp methodName \u4ee3\u7801\u5408\u5e76\u4f7f\u7528\u552f\u4e00\u6807\u8bc6") + ".*?" + Pattern.quote(" */" + System.lineSeparator()) + "$";

    public static String parseVueMethods(String code) {
        List lines = CodeSplitUtil.linesOf((String)code);
        IndexModel indexModel = new IndexModel();
        StringBuilder methodName = new StringBuilder();
        for (int i = 0; i < lines.size(); ++i) {
            if (indexModel.isMethodEnd()) {
                lines.add(i, ParseVueMethodsUtil.buildMethodEndMark(methodName.toString()));
                indexModel.reInit();
                continue;
            }
            try {
                ParseVueMethodsUtil.identifyMethods(lines, i, indexModel, methodName);
                continue;
            }
            catch (LcdpException e) {
                return code;
            }
        }
        return String.join((CharSequence)"", lines);
    }

    private static void identifyMethods(List<String> lines, int i, IndexModel indexModel, StringBuilder methodName) throws LcdpException {
        int blockCommentEndIndex;
        String line = lines.get(i);
        if (HussarUtils.isBlank((CharSequence)(line = line.trim().replaceAll(" ", "")))) {
            return;
        }
        if (!indexModel.isScriptBegin()) {
            if (line.startsWith(METHODS_START)) {
                indexModel.setScriptBegin(true);
            }
        } else if (indexModel.getState() == 0) {
            ParseVueMethodsUtil.parseLine(i, line, indexModel, methodName);
        } else if (indexModel.getState() == 1 && (blockCommentEndIndex = line.indexOf("*/")) > -1) {
            indexModel.setState(0);
            if (blockCommentEndIndex + 2 < line.length()) {
                String codeLine = line.substring(blockCommentEndIndex + 2);
                ParseVueMethodsUtil.parseLine(i, codeLine, indexModel, methodName);
            }
        }
    }

    private static void parseLine(int i, String line, IndexModel indexModel, StringBuilder methodName) throws LcdpException {
        int quotesStartIndex;
        int blockCommentsIndex;
        if (HussarUtils.isBlank((CharSequence)line)) {
            return;
        }
        int lineCommentsIndex = line.indexOf("//");
        int state = ParseVueMethodsUtil.findSmallest(lineCommentsIndex, blockCommentsIndex = line.indexOf("/*"), quotesStartIndex = line.indexOf("'"), line.length() + 1);
        if (state == 1) {
            String codeLine = line.substring(0, lineCommentsIndex);
            ParseVueMethodsUtil.parseLine(i, codeLine, indexModel, methodName);
            return;
        }
        if (state == 2) {
            String codeLine = line.substring(0, blockCommentsIndex);
            indexModel.setState(1);
            String commentLine = line.substring(blockCommentsIndex);
            int blockCommentEndIndex = commentLine.indexOf("*/");
            if (blockCommentEndIndex > -1) {
                indexModel.setState(0);
                if (blockCommentEndIndex + 2 < commentLine.length()) {
                    codeLine = codeLine + commentLine.substring(blockCommentEndIndex + 2);
                }
            }
            ParseVueMethodsUtil.parseLine(i, codeLine, indexModel, methodName);
            return;
        }
        if (state == 3) {
            String codeLine = line.substring(0, quotesStartIndex);
            indexModel.setState(2);
            String quotesLine = line.substring(quotesStartIndex + 1);
            int quotesEndIndex = quotesLine.indexOf("'");
            while (quotesEndIndex > -1) {
                if (quotesEndIndex > 0 && quotesLine.charAt(quotesEndIndex - 1) == '\\') {
                    if (quotesEndIndex + 1 >= quotesLine.length() - 1) {
                        throw new LcdpException(LcdpExceptionEnum.ERROR, "vue\u6587\u4ef6\u89e3\u6790\u5931\u8d25");
                    }
                    quotesEndIndex = quotesLine.indexOf("'", quotesEndIndex + 1);
                    continue;
                }
                indexModel.setState(0);
                if (quotesEndIndex + 1 >= quotesLine.length()) break;
                codeLine = codeLine + quotesLine.substring(quotesEndIndex + 1);
                break;
            }
            ParseVueMethodsUtil.parseLine(i, codeLine, indexModel, methodName);
            return;
        }
        ParseVueMethodsUtil.parseCodeLine(i, line, indexModel, methodName);
    }

    public static int findSmallest(int a, int b, int c, int maxInt) {
        int min = maxInt;
        int minIndex = 4;
        if (a > -1 && a < min) {
            min = a;
            minIndex = 1;
        }
        if (b > -1 && b < min) {
            min = b;
            minIndex = 2;
        }
        if (c > -1 && c < min) {
            min = c;
            minIndex = 3;
        }
        return min == maxInt ? 4 : minIndex;
    }

    private static void parseCodeLine(int i, String codeLine, IndexModel indexModel, StringBuilder methodName) {
        Matcher matcher;
        if (HussarUtils.isBlank((CharSequence)codeLine) || indexModel.getLastMethodEnd() == i) {
            return;
        }
        if (indexModel.isMethodBegin()) {
            indexModel.setDeepIndex(indexModel.getDeepIndex() + ParseVueMethodsUtil.computeBraceNum(codeLine));
            if (indexModel.getDeepIndex() <= 0) {
                indexModel.setMethodEnd(true);
                indexModel.setLastMethodEnd(i);
            }
        } else if (codeLine.contains(METHODS_END)) {
            indexModel.setScriptBegin(false);
            methodName.setLength(0);
            indexModel.setDeepIndex(0);
        } else if (codeLine.indexOf("{") > 0 && (matcher = METHOD_PATTERN.matcher(codeLine)).find()) {
            methodName.setLength(0);
            methodName.append(matcher.group(0));
            indexModel.setMethodBegin(true);
            codeLine = codeLine.substring(codeLine.indexOf(matcher.group(0)));
            ParseVueMethodsUtil.parseCodeLine(i, codeLine, indexModel, methodName);
        }
    }

    private static int computeBraceNum(String codeLine) {
        AtomicReference<Integer> i = new AtomicReference<Integer>(0);
        codeLine.chars().forEach(charStr -> {
            if (charStr == 123) {
                i.getAndSet((Integer)i.get() + 1);
            }
            if (charStr == 125) {
                i.getAndSet((Integer)i.get() - 1);
            }
        });
        return i.get();
    }

    private static String buildMethodEndMark(String methodName) {
        return COMMENT_START.concat(methodName).concat(COMMENT_END).concat(System.lineSeparator());
    }
}

