/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.upgrade.vue.dom.title;

import com.jxdinfo.hussar.formdesign.common.model.upgrade.UpgradeConfig;
import com.jxdinfo.hussar.formdesign.upgrade.factory.ParseCodeFactory;
import com.jxdinfo.hussar.formdesign.upgrade.model.PublishFileType;
import com.jxdinfo.hussar.formdesign.upgrade.vue.dom.model.VueDomPropValues;
import com.jxdinfo.hussar.formdesign.upgrade.vue.dom.parse.VueDomParse;
import com.jxdinfo.hussar.formdesign.upgrade.vue.dom.title.model.UpgradeTitleDetail;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.springframework.stereotype.Component;

@Component(value="com.jxdinfo.hussar.formdesign.upgrade.title.dom.vue.VueDomTitleParse")
public class VueDomTitleParse
implements VueDomParse {
    public static final String UPGRADE_TYPE = "VUE-DOM-TITLE";

    @PostConstruct
    public void register() {
        ParseCodeFactory.registerParseDetailTypeCode(UPGRADE_TYPE, VueDomTitleParse.class);
    }

    @Override
    public void parseCode(VueDomPropValues configDetail, List<String> domLines, UpgradeConfig upgradeConfig, VueDomPropValues currentPublishConfigDetail, PublishFileType publishFileType, Map<String, String> dynamicRemoveMap) {
        switch (upgradeConfig.getType()) {
            case 0: {
                this.replaceTitle(configDetail, domLines, upgradeConfig);
            }
        }
    }

    public void replaceTitle(VueDomPropValues configDetail, List<String> domLines, UpgradeConfig upgradeConfig) {
        UpgradeTitleDetail upgradeTitleDetail = (UpgradeTitleDetail)upgradeConfig.getUpgradeDetail().toJavaObject(UpgradeTitleDetail.class);
        String upgradeFrom = upgradeTitleDetail.getUpgradeFrom();
        String upgradeTo = upgradeTitleDetail.getUpgradeTo();
        if (!StringUtil.equals((CharSequence)configDetail.getTitleName(), (CharSequence)upgradeConfig.getMatchTitle())) {
            return;
        }
        if (configDetail.isReplace()) {
            int indexPreStart = configDetail.getIndexPreStart();
            int indexPreEnd = configDetail.getIndexPreEnd();
            String linePre = domLines.get(configDetail.getIndexPre());
            StringBuilder sbPre = new StringBuilder(linePre);
            sbPre.replace(indexPreStart, indexPreEnd, upgradeTo);
            domLines.set(configDetail.getIndexPre(), sbPre.toString());
            int indexRefStart = configDetail.getIndexRefStart();
            int indexRefEnd = configDetail.getIndexRefEnd();
            String lineRef = domLines.get(configDetail.getIndexRef());
            StringBuilder sbRef = new StringBuilder(lineRef);
            int num = 0;
            if (configDetail.getIndexPre() == configDetail.getIndexRef()) {
                num = upgradeTo.length() - upgradeFrom.length();
            }
            sbRef.replace(indexRefStart + num, indexRefEnd + num, upgradeTo);
            domLines.set(configDetail.getIndexRef(), sbRef.toString());
            configDetail.replaced(upgradeTo.length());
        }
    }
}

