/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.structural.section.model.section;

import com.jxdinfo.hussar.formdesign.structural.section.model.section.SectionType;
import com.jxdinfo.hussar.formdesign.structural.section.model.section.SectionVisitor;
import java.util.List;
import java.util.function.Predicate;

public abstract class CodeSection {
    private int start;
    private int end;

    public CodeSection() {
    }

    public CodeSection(int start, int end) {
        this.start = start;
        this.end = end;
    }

    public abstract SectionType getType();

    public abstract boolean isLeaf();

    public abstract List<CodeSection> getChildren();

    public String getId() {
        return null;
    }

    public String getReference() {
        return null;
    }

    public String getPosition() {
        return this.start + "-" + this.end;
    }

    public boolean isPlain() {
        if (this.isLeaf()) {
            return true;
        }
        List<CodeSection> children = this.getChildren();
        if (children == null || children.size() == 0) {
            return true;
        }
        for (CodeSection section : children) {
            if (section.isLeaf()) continue;
            return false;
        }
        return true;
    }

    public String getOuterCode() {
        return this.getInnerCode();
    }

    public String getInnerCode() {
        List<CodeSection> children = this.getChildren();
        if (children == null || children.size() == 0) {
            return "";
        }
        if (children.size() == 1) {
            return children.get(0).getOuterCode();
        }
        StringBuilder builder = new StringBuilder();
        for (CodeSection section : children) {
            builder.append(section.getOuterCode());
        }
        return builder.toString();
    }

    public void appendOuterCode(StringBuilder builder) {
        this.appendInnerCode(builder);
    }

    public void appendInnerCode(StringBuilder builder) {
        List<CodeSection> children = this.getChildren();
        if (children == null || children.size() == 0) {
            return;
        }
        for (CodeSection section : children) {
            builder.append(section.getOuterCode());
        }
    }

    public boolean traverse(Predicate<CodeSection> visitor) {
        if (!visitor.test(this)) {
            return false;
        }
        List<CodeSection> children = this.getChildren();
        if (children == null) {
            return true;
        }
        for (CodeSection section : children) {
            if (section.traverse(visitor)) continue;
            return false;
        }
        return true;
    }

    public boolean traverse(SectionVisitor visitor) {
        if (this.isLeaf()) {
            return visitor.visit(this);
        }
        if (!visitor.enter(this)) {
            return false;
        }
        List<CodeSection> children = this.getChildren();
        if (children != null) {
            for (CodeSection section : children) {
                if (section.traverse(visitor)) continue;
                return false;
            }
        }
        return visitor.leave(this);
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public int getEnd() {
        return this.end;
    }

    public void setEnd(int end) {
        this.end = end;
    }
}

