/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.version.service.impl;

import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.formdesign.common.config.condition.ConditionNotSharedStorage;
import com.jxdinfo.hussar.formdesign.common.file.FilePublishService;
import com.jxdinfo.hussar.formdesign.common.file.PathStrategyService;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtils;
import com.jxdinfo.hussar.formdesign.version.service.VersionManageService;
import com.jxdinfo.hussar.formdesign.version.util.FilePublishUtil;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.annotation.Resource;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;

@Service
@Conditional(value={ConditionNotSharedStorage.class})
public class VersionManageServiceImpl
implements VersionManageService {
    private static final String ANCESTOR_STORE_RELATIVE_PATH = "/publish/version/ancestor";
    private static String ANCESTOR_STORE_PATH;
    @Resource
    private FilePublishService filePublishService;

    @Override
    public String getAncestorCodeById(String id) throws IOException {
        FilePublishService filePublishService = (FilePublishService)SpringContextUtil.getBean(FilePublishService.class);
        return filePublishService.getAncestorCodeById(id);
    }

    @Override
    public void saveLastPublishCode(String id, String code) throws IOException {
        FilePublishService filePublishService = (FilePublishService)SpringContextUtil.getBean(FilePublishService.class);
        filePublishService.saveLastPublishCode(id, code);
    }

    @Override
    public void saveCacheLastPublishCode(String id, String code, String pageId) {
        String filePath = FilePublishUtil.getPublishVersionFilePathById(id);
        FilePublishService filePublishService = (FilePublishService)SpringContextUtil.getBean(FilePublishService.class);
        filePublishService.writeStringToFile(code, filePath, pageId);
    }

    @Override
    public void saveCacheLastFileCode(String id, String code, String pageId) {
        String filePath = FilePublishUtil.getLastFileVersionFilePathById(id);
        FilePublishService filePublishService = (FilePublishService)SpringContextUtil.getBean(FilePublishService.class);
        filePublishService.writeStringToFile(code, filePath, pageId);
    }

    @Override
    public void saveLastFileCode(String id, String code) throws IOException {
        FilePublishService filePublishService = (FilePublishService)SpringContextUtil.getBean(FilePublishService.class);
        filePublishService.saveLastFileCode(id, code);
    }

    @Override
    public String getLastFileCode(String id) throws IOException {
        FilePublishService filePublishService = (FilePublishService)SpringContextUtil.getBean(FilePublishService.class);
        return filePublishService.getLastFileCode(id);
    }

    @Override
    public String getAncestorCodeExtendById(String id) throws IOException {
        String filePath = this.getPublishVersionExtendFilePathById(id);
        return FileUtils.readFileToString((String)filePath, (Charset)StandardCharsets.UTF_8);
    }

    private String getPublishVersionExtendFilePathById(String id) {
        ANCESTOR_STORE_PATH = ((PathStrategyService)SpringContextHolder.getBean(PathStrategyService.class)).resourcePathService().projectStore(new String[]{ANCESTOR_STORE_RELATIVE_PATH}).getLocalPath();
        String path = ANCESTOR_STORE_PATH + "/" + id;
        path = path + "/last_publish";
        return FileUtil.systemPath((String[])new String[]{path + ".version"});
    }

    @Override
    public String getLastFileExtendCode(String id) throws IOException {
        String filePath = this.getLastFileVersionExtendFilePathById(id);
        File toReadFile = new File(filePath);
        if (FileUtils.exists((File)toReadFile)) {
            return FileUtils.readFileToString((File)toReadFile, (Charset)StandardCharsets.UTF_8);
        }
        return null;
    }

    @Override
    public void saveLastPublishCodeExtendCache(String id, String code, String pageId) {
        String filePath = this.getPublishVersionExtendFilePathById(id);
        this.filePublishService.writeStringToFile(code, filePath, pageId);
    }

    @Override
    public void saveLastFileCodeExtendCache(String id, String code, String pageId) {
        String filePath = this.getLastFileVersionExtendFilePathById(id);
        this.filePublishService.writeStringToFile(code, filePath, pageId);
    }

    @Override
    public void saveLastPublishCodeExtend(String id, String code) throws IOException {
        String filePath = this.getPublishVersionExtendFilePathById(id);
        File toSaveFile = new File(filePath);
        FileUtils.writeStringToFile((File)toSaveFile, (String)code, (Charset)StandardCharsets.UTF_8);
    }

    @Override
    public void saveLastFileCodeExtend(String id, String code) throws IOException {
        String filePath = this.getLastFileVersionExtendFilePathById(id);
        File toSaveFile = new File(filePath);
        FileUtils.writeStringToFile((File)toSaveFile, (String)code, (Charset)StandardCharsets.UTF_8);
    }

    private String getLastFileVersionExtendFilePathById(String id) {
        ANCESTOR_STORE_PATH = ((PathStrategyService)SpringContextHolder.getBean(PathStrategyService.class)).resourcePathService().projectStore(new String[]{ANCESTOR_STORE_RELATIVE_PATH}).getLocalPath();
        String path = ANCESTOR_STORE_PATH + "/" + id;
        path = path + "/last_file";
        return FileUtil.systemPath((String[])new String[]{path + ".version"});
    }

    private String getPublishVersionFilePathById(String id) {
        ANCESTOR_STORE_PATH = ((PathStrategyService)SpringContextHolder.getBean(PathStrategyService.class)).resourcePathService().projectStore(new String[]{ANCESTOR_STORE_RELATIVE_PATH}).getLocalPath();
        String path = ANCESTOR_STORE_PATH + "/" + id.replace("_", "/");
        path = path + "/last_publish";
        return FileUtil.systemPath((String[])new String[]{path + ".version"});
    }

    private String getLastFileVersionFilePathById(String id) {
        ANCESTOR_STORE_PATH = ((PathStrategyService)SpringContextHolder.getBean(PathStrategyService.class)).resourcePathService().projectStore(new String[]{ANCESTOR_STORE_RELATIVE_PATH}).getLocalPath();
        String path = ANCESTOR_STORE_PATH + "/" + id.replace("_", "/");
        path = path + "/last_file";
        return FileUtil.systemPath((String[])new String[]{path + ".version"});
    }
}

