/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.upgrade.vue.dom.prop.value;

import com.jxdinfo.hussar.formdesign.common.model.upgrade.UpgradeConfig;
import com.jxdinfo.hussar.formdesign.upgrade.factory.ParseCodeFactory;
import com.jxdinfo.hussar.formdesign.upgrade.model.PublishFileType;
import com.jxdinfo.hussar.formdesign.upgrade.vue.dom.model.DataValueInfo;
import com.jxdinfo.hussar.formdesign.upgrade.vue.dom.model.VueDomAttributeInfo;
import com.jxdinfo.hussar.formdesign.upgrade.vue.dom.model.VueDomDetail;
import com.jxdinfo.hussar.formdesign.upgrade.vue.dom.model.VueDomPropValues;
import com.jxdinfo.hussar.formdesign.upgrade.vue.dom.parse.VueDomParse;
import com.jxdinfo.hussar.formdesign.upgrade.vue.dom.prop.value.model.UpgradeDataValueAddDetail;
import com.jxdinfo.hussar.formdesign.upgrade.vue.dom.prop.value.model.UpgradeDataValueDelDetail;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.springframework.stereotype.Component;

@Component(value="com.jxdinfo.hussar.formdesign.upgrade.value.prop.dom.vue.VueDomPropValueParse")
public class VueDomPropValueParse
implements VueDomParse {
    private static final String UPGRADE_TYPE = "VUE-DOM-PROP-VALUE";

    @PostConstruct
    public void register() {
        ParseCodeFactory.registerParseDetailTypeCode(UPGRADE_TYPE, VueDomPropValueParse.class);
    }

    @Override
    public void parseCode(VueDomPropValues configDetail, List<String> domLines, UpgradeConfig upgradeConfig, VueDomPropValues currentPublishConfigDetail, PublishFileType publishFileType, Map<String, String> dynamicRemoveMap) {
        switch (upgradeConfig.getType()) {
            case 1: {
                this.dealAddDataValue(configDetail, domLines, upgradeConfig, currentPublishConfigDetail);
                break;
            }
            case 2: {
                this.dealDelDataValue(configDetail, domLines, upgradeConfig, publishFileType, dynamicRemoveMap);
            }
        }
    }

    public void dealDelDataValue(VueDomDetail configDetail, List<String> domLines, UpgradeConfig upgradeConfig, PublishFileType publishFileType, Map<String, String> dynamicRemoveMap) {
        boolean next;
        UpgradeDataValueDelDetail upgradeDataValueDelDetail = (UpgradeDataValueDelDetail)upgradeConfig.getUpgradeDetail().toJavaObject(UpgradeDataValueDelDetail.class);
        if (!configDetail.isReplace()) {
            return;
        }
        VueDomPropValues operator = new VueDomPropValues();
        int indexPre = configDetail.getIndexPre();
        String line = domLines.get(configDetail.getIndexPre());
        StringBuilder lineSb = new StringBuilder(line);
        for (int i = configDetail.getIndexPreEnd(); i < line.length() && (next = operator.setChar(line.charAt(i), i)); ++i) {
        }
        if (operator.getDataValueInfoMap() == null) {
            operator.setDataValueInfoMap(new HashMap<String, VueDomAttributeInfo>());
        }
        String upgradeProp = upgradeDataValueDelDetail.getUpgradeProp();
        VueDomAttributeInfo vueDomAttributeInfoProp = operator.getDataValueInfoMap().get(upgradeProp);
        if (HussarUtils.isEmpty((Object)vueDomAttributeInfoProp)) {
            return;
        }
        if (upgradeDataValueDelDetail.getValueNumber() == 0) {
            if (vueDomAttributeInfoProp.isHasValue()) {
                return;
            }
            lineSb.delete(vueDomAttributeInfoProp.getDataStart() - 1, vueDomAttributeInfoProp.getDataValueEnd());
            domLines.set(indexPre, lineSb.toString());
            return;
        }
        Map<String, String> idMap = this.findId(upgradeDataValueDelDetail.getUpgradeVariable(), operator);
        String upgradeDel = null;
        if (upgradeDataValueDelDetail.getDynamicProp() == 1) {
            if (publishFileType == PublishFileType.LAST_PUBLISH) {
                upgradeDel = this.findPropValue(operator, upgradeProp, upgradeDataValueDelDetail.getValueNumber(), upgradeDataValueDelDetail.getUpgradeDelete());
                dynamicRemoveMap.put(upgradeDataValueDelDetail.getUpgradeProp(), upgradeDel);
            } else if (publishFileType == PublishFileType.CURRENT_FILE) {
                upgradeDel = dynamicRemoveMap.get(upgradeDataValueDelDetail.getUpgradeProp());
            }
        } else {
            upgradeDel = this.replaceId(upgradeDataValueDelDetail.getUpgradeDelete(), idMap);
        }
        if (HussarUtils.isBlank((CharSequence)upgradeDel)) {
            return;
        }
        DataValueInfo dataValueInfo = vueDomAttributeInfoProp.getValueInfoMap().get(upgradeDel.replaceAll(" ", ""));
        if (HussarUtils.isNotEmpty((Object)dataValueInfo)) {
            if (vueDomAttributeInfoProp.getValueInfoMap().keySet().size() <= 1) {
                lineSb.delete(vueDomAttributeInfoProp.getDataStart() - 1, vueDomAttributeInfoProp.getDataValueEnd());
            } else {
                int start = dataValueInfo.getStart();
                int end = dataValueInfo.getEnd();
                if (start > vueDomAttributeInfoProp.getWriteValueStart()) {
                    --start;
                } else if (end + 1 < vueDomAttributeInfoProp.getDataValueEnd()) {
                    ++end;
                }
                lineSb.delete(start, end);
            }
        } else if (upgradeDataValueDelDetail.getValueNumber() == 1 && upgradeDataValueDelDetail.getSolveConflictType() == 1) {
            lineSb.delete(vueDomAttributeInfoProp.getDataStart() - 1, vueDomAttributeInfoProp.getDataValueEnd());
        }
        domLines.set(indexPre, lineSb.toString());
    }

    public void dealAddDataValue(VueDomDetail configDetail, List<String> domLines, UpgradeConfig upgradeConfig, VueDomPropValues currentPublishOperator) {
        boolean next;
        UpgradeDataValueAddDetail upgradeDataValueAddDetail = (UpgradeDataValueAddDetail)upgradeConfig.getUpgradeDetail().toJavaObject(UpgradeDataValueAddDetail.class);
        if (!configDetail.isReplace()) {
            return;
        }
        VueDomPropValues operator = new VueDomPropValues();
        int indexPre = configDetail.getIndexPre();
        String line = domLines.get(configDetail.getIndexPre());
        StringBuilder lineSb = new StringBuilder(line);
        for (int i = configDetail.getIndexPreEnd(); i < line.length() && (next = operator.setChar(line.charAt(i), i)); ++i) {
        }
        if (operator.getDataValueInfoMap() == null) {
            operator.setDataValueInfoMap(new HashMap<String, VueDomAttributeInfo>());
        }
        Map<String, String> idMap = this.findId(upgradeDataValueAddDetail.getUpgradeVariable(), operator);
        String upgradeAdd = this.replaceId(upgradeDataValueAddDetail.getUpgradeAdd(), idMap);
        String upgradeProp = upgradeDataValueAddDetail.getUpgradeProp();
        if (upgradeDataValueAddDetail.getDynamicProp() == 1) {
            upgradeAdd = this.findPropValue(currentPublishOperator, upgradeProp, upgradeDataValueAddDetail.getValueNumber(), upgradeDataValueAddDetail.getUpgradeAdd());
        }
        if (upgradeAdd == null) {
            return;
        }
        VueDomAttributeInfo vueDomAttributeInfoProp = operator.getDataValueInfoMap().get(upgradeProp);
        if (HussarUtils.isEmpty((Object)vueDomAttributeInfoProp)) {
            VueDomAttributeInfo afterVueDomAttributeInfo = null;
            for (String addPropAfter : upgradeDataValueAddDetail.getAddPropAfter()) {
                VueDomAttributeInfo vueDomAttributeInfo = operator.getDataValueInfoMap().get(addPropAfter);
                if (vueDomAttributeInfo == null) continue;
                afterVueDomAttributeInfo = vueDomAttributeInfo;
                break;
            }
            String dataValueStr = HussarUtils.isBlank((CharSequence)upgradeAdd) ? " " + upgradeProp : " " + upgradeProp + "=\"" + upgradeAdd + "\"";
            if (afterVueDomAttributeInfo == null) {
                lineSb.insert(configDetail.getIndexPreEnd(), dataValueStr);
            } else {
                lineSb.insert(afterVueDomAttributeInfo.getDataValueEnd(), dataValueStr);
            }
            domLines.set(indexPre, lineSb.toString());
            return;
        }
        if (upgradeDataValueAddDetail.getValueNumber() == 0) {
            return;
        }
        DataValueInfo afterDataValueInfo = null;
        if (HussarUtils.isNotEmpty(vueDomAttributeInfoProp.getValueInfoMap())) {
            for (String addValueAfter : upgradeDataValueAddDetail.getAddValueAfter()) {
                DataValueInfo dataInfo;
                if ((addValueAfter = this.replaceId(addValueAfter, idMap)) == null || (dataInfo = vueDomAttributeInfoProp.getValueInfoMap().get(addValueAfter)) == null) continue;
                afterDataValueInfo = dataInfo;
                break;
            }
        }
        int insertValueIndex = 0;
        if (!vueDomAttributeInfoProp.isHasValue()) {
            upgradeAdd = "=\"" + upgradeAdd + "\"";
        }
        if (HussarUtils.isNotEmpty(vueDomAttributeInfoProp.getValueInfoMap()) && HussarUtils.isNotEmpty((Object)vueDomAttributeInfoProp.getValueInfoMap().get(upgradeAdd.replaceAll(" ", "")))) {
            return;
        }
        if (upgradeDataValueAddDetail.getValueNumber() == 1) {
            Iterator<DataValueInfo> iterator;
            if (HussarUtils.isNotEmpty(vueDomAttributeInfoProp.getValueInfoMap()) && upgradeDataValueAddDetail.getSolveConflictType() == 1 && (iterator = vueDomAttributeInfoProp.getValueInfoMap().values().iterator()).hasNext()) {
                DataValueInfo value = iterator.next();
                lineSb.replace(value.getStart(), value.getEnd(), upgradeAdd);
            }
            return;
        }
        if (afterDataValueInfo == null) {
            insertValueIndex = vueDomAttributeInfoProp.getWriteValueStart();
            if (insertValueIndex + 1 < vueDomAttributeInfoProp.getDataValueEnd()) {
                upgradeAdd = upgradeAdd + " ";
            }
        } else {
            insertValueIndex = afterDataValueInfo.getEnd();
            upgradeAdd = " " + upgradeAdd;
        }
        lineSb.insert(insertValueIndex, upgradeAdd);
        domLines.set(indexPre, lineSb.toString());
    }

    private String findPropValue(VueDomPropValues currentPublishOperator, String upgradeProp, int valueNumber, String upgradeStr) {
        if (currentPublishOperator == null) {
            return null;
        }
        if (HussarUtils.isEmpty(currentPublishOperator.getDataValueInfoMap()) || HussarUtils.isEmpty((Object)currentPublishOperator.getDataValueInfoMap().get(upgradeProp))) {
            return null;
        }
        String upgradeValue = null;
        VueDomAttributeInfo vueDomAttributeInfo = currentPublishOperator.getDataValueInfoMap().get(upgradeProp);
        if (valueNumber > 0) {
            if (HussarUtils.isEmpty(vueDomAttributeInfo.getValueInfoMap())) {
                return null;
            }
            if (valueNumber == 1) {
                upgradeValue = vueDomAttributeInfo.getValues().get(0).getValue();
            }
            if (valueNumber > 1) {
                String value = this.findValue(upgradeStr, vueDomAttributeInfo.getValues().stream().map(DataValueInfo::getValue).collect(Collectors.toList()));
                if (HussarUtils.isBlank((CharSequence)value)) {
                    return null;
                }
                upgradeValue = value;
            }
        }
        return upgradeValue;
    }

    public Map<String, String> findId(List<String> upgradeVariables, VueDomPropValues operator) {
        HashMap<String, String> idMap = new HashMap<String, String>();
        for (String upgradeVariable : upgradeVariables) {
            String patternString = "@\\[(\\w+)\\]";
            Pattern patternId = Pattern.compile(patternString);
            Matcher matcherId = patternId.matcher(upgradeVariable);
            String id = "";
            if (matcherId.find()) {
                id = matcherId.group(1);
                upgradeVariable = matcherId.replaceFirst("(\\\\w+)");
            }
            if (HussarUtils.isBlank((CharSequence)id)) continue;
            String idValue = "";
            String regex = "(^|\\W)" + upgradeVariable + "(\\W|$)";
            Pattern pattern = Pattern.compile(regex);
            for (VueDomAttributeInfo vueDomAttributeInfo : operator.getDataValueInfoMap().values()) {
                if (HussarUtils.isEmpty(vueDomAttributeInfo.getValueInfoMap())) continue;
                for (String value : vueDomAttributeInfo.getValueInfoMap().keySet()) {
                    Matcher matcher = pattern.matcher(value);
                    if (!matcher.find()) continue;
                    idValue = matcher.group(2);
                    break;
                }
                if (!HussarUtils.isNotBlank((CharSequence)idValue)) continue;
                break;
            }
            if (!HussarUtils.isNotBlank((CharSequence)idValue)) continue;
            idMap.put(id, idValue);
        }
        return idMap;
    }

    public String findValue(String regexId, List<String> values) {
        String patternString = "@\\[(\\w+)\\]";
        Pattern patternId = Pattern.compile(patternString);
        Matcher matcherId = patternId.matcher(regexId);
        String id = "";
        if (matcherId.find()) {
            regexId = matcherId.replaceFirst("(\\\\w+)");
        }
        String idValue = "";
        String regex = "(^|\\W)" + regexId + "(\\W|$)";
        Pattern pattern = Pattern.compile(regex);
        for (String value : values) {
            Matcher matcher = pattern.matcher(value);
            if (!matcher.find()) continue;
            return value;
        }
        return null;
    }

    public String replaceId(String upgrade, Map<String, String> idMap) {
        String patternString = "@\\[(\\w+)\\]";
        Pattern patternId = Pattern.compile(patternString);
        Matcher matcherId = patternId.matcher(upgrade);
        boolean idGet = true;
        matcherId.reset();
        if (matcherId.find()) {
            boolean result;
            StringBuffer sb = new StringBuffer();
            do {
                String groupId;
                if (HussarUtils.isBlank((CharSequence)idMap.get(groupId = matcherId.group(1)))) {
                    idGet = false;
                    break;
                }
                matcherId.appendReplacement(sb, idMap.get(groupId));
            } while (result = matcherId.find());
            matcherId.appendTail(sb);
            upgrade = sb.toString();
        }
        if (!idGet) {
            return null;
        }
        return upgrade;
    }
}

