/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.bpm.api;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.sequence.builder.SeqBuilder;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.workflow.assignee.model.BpmTreeModel;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.TaskEntrustDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.TaskRejectDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.TaskRevokeDto;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import com.jxdinfo.hussar.workflow.godaxe.processtest.api.NodeApiService;
import com.jxdinfo.hussar.workflow.godaxe.processtest.api.ProcessTestingApiService;
import com.jxdinfo.hussar.workflow.godaxe.processtest.api.TestLogApiService;
import com.jxdinfo.hussar.workflow.godaxe.processtest.api.TestLogDetailApiService;
import com.jxdinfo.hussar.workflow.godaxe.processtest.api.VariableApiService;
import com.jxdinfo.hussar.workflow.godaxe.processtest.dto.ConfiguredInstanceVariableQueryDto;
import com.jxdinfo.hussar.workflow.godaxe.processtest.dto.NodeQueryDto;
import com.jxdinfo.hussar.workflow.godaxe.processtest.dto.ProcessListDto;
import com.jxdinfo.hussar.workflow.godaxe.processtest.dto.ProcessTestingParamDto;
import com.jxdinfo.hussar.workflow.godaxe.processtest.dto.ReceiveTaskReleaseDto;
import com.jxdinfo.hussar.workflow.godaxe.processtest.dto.TestStartProcessInsDto;
import com.jxdinfo.hussar.workflow.godaxe.processtest.dto.TestTaskCompleteDto;
import com.jxdinfo.hussar.workflow.godaxe.processtest.model.ProcessInstModel;
import com.jxdinfo.hussar.workflow.godaxe.processtest.vo.AllVariablesConfiguredInProcessVo;
import com.jxdinfo.hussar.workflow.manage.bpm.flowchart.FlowChartCommonDto;
import com.jxdinfo.hussar.workflow.manage.bpm.flowchart.FlowChartSubProcessDto;
import com.jxdinfo.hussar.workflow.manage.engine.AssigneeService;
import com.jxdinfo.hussar.workflow.manage.engine.TaskEngineService;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/formdesign/bpm"})
public class BpmTestController {
    @Autowired
    private VariableApiService variableApiService;
    @Autowired
    private NodeApiService nodeApiService;
    @Autowired
    private ProcessTestingApiService processTestingApiService;
    @Autowired
    private TestLogDetailApiService testLogDetailApiService;
    @Autowired
    private TestLogApiService testLogApiService;
    @Autowired
    private SeqBuilder seqBuilder;

    @GetMapping(value={"/variable/getAllVariablesConfiguredInMainProcess"})
    public ApiResponse<?> getAllVariablesConfiguredInMainProcess(String processKey, String processVersion) {
        return this.variableApiService.getAllVariablesConfiguredInMainProcess(processKey, processVersion);
    }

    @PostMapping(value={"/variable/getAllVariablesConfiguredInSubProcessAndBindingInfo"})
    public ApiResponse<?> getAllVariablesConfiguredInSubProcessAndBindingInfo(@RequestBody ConfiguredInstanceVariableQueryDto configuredInstanceVariableQuery) {
        return this.variableApiService.getAllVariablesConfiguredInSubProcessAndBindingInfo(configuredInstanceVariableQuery);
    }

    @PostMapping(value={"/node/listNodeOnRunTimePathInMainAndExternalSubProcess"})
    public ApiResponse<?> listNodeOnRunTimePathInMainAndExternalSubProcess(@RequestBody AllVariablesConfiguredInProcessVo allVariablesConfiguredInProcess) {
        return this.nodeApiService.listNodeOnRunTimePathInMainAndExternalSubProcess(allVariablesConfiguredInProcess);
    }

    @PostMapping(value={"/node/listNodeOnRunTimePathInInternalSubProcessThatDoseNotOpenCountersign"})
    public ApiResponse<?> listNodeOnRunTimePathInInternalSubProcessThatDoseNotOpenCountersign(@RequestBody NodeQueryDto nodeQuery) {
        return this.nodeApiService.listNodeOnRunTimePathInInternalSubProcessThatDoseNotOpenCountersign(nodeQuery);
    }

    @PostMapping(value={"/node/listNodeOnRunTimePathInInternalSubProcessThatOpenCountersign"})
    public ApiResponse<?> listNodeOnRunTimePathInInternalSubProcessThatOpenCountersign(@RequestBody NodeQueryDto nodeQuery) {
        return this.nodeApiService.listNodeOnRunTimePathInInternalSubProcessThatOpenCountersign(nodeQuery);
    }

    @PostMapping(value={"/processTesting/testProcess"})
    public ApiResponse<?> testProcess(@RequestBody ProcessTestingParamDto processTestingParam) {
        return this.processTestingApiService.testProcess(processTestingParam);
    }

    @PostMapping(value={"/records/getProcessBetaList"})
    ApiResponse<?> getProcessBetaList(Page<ProcessInstModel> page, @RequestBody ProcessListDto processListDto) {
        return this.variableApiService.getProcessBetaList(page, processListDto);
    }

    @PostMapping(value={"/records/list"})
    @ApiOperation(value="\u67e5\u8be2\u529e\u7406\u5386\u53f2\u5217\u8868", notes="\u67e5\u8be2\u529e\u7406\u5386\u53f2\u5217\u8868")
    public ApiResponse<?> list(@RequestBody FlowChartCommonDto flowChartCommonDto) {
        return this.variableApiService.list(flowChartCommonDto);
    }

    @GetMapping(value={"/records/getProcessDetailForProcessTesting"})
    public ApiResponse<?> getProcessDetailForProcessTesting(FlowChartCommonDto flowChartCommonDto) {
        return this.variableApiService.getProcessInfoForProcessTesting(flowChartCommonDto.getProcessInsId(), flowChartCommonDto.getBusinessId(), flowChartCommonDto.getSubProcessKey(), flowChartCommonDto.getCycleCount());
    }

    @GetMapping(value={"/records/getProcessDetail"})
    public ApiResponse<?> getProcessDetail(FlowChartCommonDto flowChartCommonDto) {
        return this.variableApiService.getProcessInfo(flowChartCommonDto.getProcessInsId(), flowChartCommonDto.getBusinessId(), flowChartCommonDto.getSubProcessKey(), flowChartCommonDto.getCycleCount());
    }

    @GetMapping(value={"/records/getProcessCompleteDetail"})
    public ApiResponse<?> getProcessCompleteDetail(FlowChartCommonDto flowChartCommonDto) {
        return this.variableApiService.getProcessCompleteInfo(flowChartCommonDto.getProcessInsId(), flowChartCommonDto.getBusinessId(), flowChartCommonDto.getSubProcessKey(), flowChartCommonDto.getCycleCount());
    }

    @GetMapping(value={"/records/getSubProcessRunningInfo"})
    public ApiResponse<?> getSubProcessRunningInfo(FlowChartCommonDto flowChartCommonDto) {
        return this.variableApiService.getSubProcessRunningInfo(flowChartCommonDto.getProcessInsId(), flowChartCommonDto.getBusinessId());
    }

    @GetMapping(value={"/records/subProcessList"})
    public ApiResponse<?> subProcessList(FlowChartSubProcessDto flowChartSubProcessDto) {
        return this.variableApiService.subProcessList(flowChartSubProcessDto.getSupProcessInsId(), flowChartSubProcessDto.getBusinessId(), flowChartSubProcessDto.getTaskDefinitionKey(), flowChartSubProcessDto.getPage(), flowChartSubProcessDto.getSize());
    }

    @PostMapping(value={"/records/deleteProcessById"})
    public ApiResponse<?> deleteProcessById(@RequestBody List<String> processInsIdList) {
        return this.variableApiService.deleteProcessInstance(processInsIdList);
    }

    @GetMapping(value={"/records/deleteFinishedProcessById"})
    public ApiResponse<?> deleteFinishedProcessById(@RequestParam(value="processInsId") String processInsId) {
        return this.variableApiService.deleteFinishedProcessInstance(processInsId);
    }

    @GetMapping(value={"/variable/findVariableById"})
    public ApiResponse<?> findVariableById(@RequestParam(value="processInsId") String processInsId) {
        return this.variableApiService.findVariableById(processInsId);
    }

    @GetMapping(value={"/log/getWorkflowLog"})
    public ApiResponse<?> getWorkflowLog(@RequestParam(value="processInsId") String processInsId) {
        return this.testLogApiService.getWorkflowLog(processInsId, null);
    }

    @GetMapping(value={"/log/getAllWorkflowDetailLog"})
    public ApiResponse<?> getAllWorkflowDetailLog(@RequestParam(value="processInsId") String processInsId) {
        return this.testLogDetailApiService.getAllWorkflowLog(processInsId, null);
    }

    @GetMapping(value={"/log/getWorkflowDetailLog"})
    public ApiResponse<?> getWorkflowDetailLog(@RequestParam(value="processInsId") String processInsId) {
        return this.testLogDetailApiService.getWorkflowLog(processInsId, null);
    }

    @GetMapping(value={"/rejectToFirstTask"})
    public BpmResponseResult rejectToFirstTask(TaskRejectDto taskRejectDto) {
        return this.processTestingApiService.rejectToFirstTask(taskRejectDto);
    }

    @GetMapping(value={"/rejectToLastTask"})
    public BpmResponseResult rejectToLastTask(TaskRejectDto taskRejectDto) {
        return this.processTestingApiService.rejectToLastTask(taskRejectDto);
    }

    @GetMapping(value={"/rejectToAnyTask"})
    public BpmResponseResult rejectToAnyTask(TaskRejectDto taskRejectDto) {
        return this.processTestingApiService.rejectToAnyTask(taskRejectDto);
    }

    @GetMapping(value={"/revokeTask"})
    public BpmResponseResult revokeTask(TaskRevokeDto taskRevokeDto) {
        return this.processTestingApiService.revokeTask(taskRevokeDto);
    }

    @GetMapping(value={"/entrustTask"})
    public BpmResponseResult entrustTask(TaskEntrustDto taskEntrustDto) {
        return this.processTestingApiService.entrustTask(taskEntrustDto);
    }

    @PostMapping(value={"/completeTask"})
    public BpmResponseResult completeTask(@RequestBody TestTaskCompleteDto testTaskCompleteDto) {
        return this.processTestingApiService.completeTask(testTaskCompleteDto);
    }

    @PostMapping(value={"/startProcessInstance"})
    public BpmResponseResult startProcessInstance(@RequestBody TestStartProcessInsDto testStartProcessInsDto) {
        return this.processTestingApiService.startProcessInstance(testStartProcessInsDto);
    }

    @GetMapping(value={"/getTodoList"})
    public ApiResponse<?> getTodoList(@RequestParam(value="businessId", required=false) String businessId, @RequestParam(value="processInsId") String procInsId) {
        return this.processTestingApiService.getTodoList(businessId, procInsId);
    }

    @GetMapping(value={"/getDoneList"})
    public ApiResponse<?> getDoneList(@RequestParam(value="businessId", required=false) String businessId, @RequestParam(value="processInsId") String procInsId) {
        return this.processTestingApiService.getDoneList(businessId, procInsId);
    }

    @PostMapping(value={"/receiveTaskSignal"})
    public BpmResponseResult receiveTaskSignal(@RequestBody ReceiveTaskReleaseDto receiveTaskReleaseDto) {
        return this.processTestingApiService.receiveTaskSignal(receiveTaskReleaseDto);
    }

    @GetMapping(value={"/checkProcessPublished"})
    public BpmResponseResult checkProcessPublished(@RequestParam(value="processKey") String processKey) {
        return this.processTestingApiService.checkProcessPublished(processKey);
    }

    @GetMapping(value={"/queryUserTree"})
    @ApiOperation(value="\u6a21\u7cca\u67e5\u8be2\u7528\u6237\u6811", notes="\u6a21\u7cca\u67e5\u8be2\u7528\u6237\u6811")
    @ApiImplicitParam(name="organName", value="\u6a21\u7cca\u67e5\u8be2\u7528\u6237\u540d\u6216\u90e8\u95e8\u540d", required=true, paramType="query")
    @AuditLog(moduleName="\u6a21\u7cca\u67e5\u8be2\u7528\u6237\u6811", eventDesc="\u6a21\u7cca\u67e5\u8be2\u7528\u6237\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<BpmTreeModel>> queryUserTree(String organName) {
        return AssigneeService.queryUserTree((String)organName);
    }

    @GetMapping(value={"/queryDeptTreeByChildren"})
    @ApiOperation(value="\u7531\u5b50\u8282\u70b9\u67e5\u8be2\u5e76\u7ec4\u5408\u90e8\u95e8\u6811", notes="\u7531\u5b50\u8282\u70b9\u67e5\u8be2\u5e76\u7ec4\u5408\u90e8\u95e8\u6811")
    @ApiImplicitParam(name="bpmTreeModel", value="\u5de5\u4f5c\u6d41\u6811\u6a21\u578b\u7c7b", paramType="query")
    @AuditLog(moduleName="\u7531\u5b50\u8282\u70b9\u67e5\u8be2\u5e76\u7ec4\u5408\u90e8\u95e8\u6811", eventDesc="\u7531\u5b50\u8282\u70b9\u67e5\u8be2\u5e76\u7ec4\u5408\u90e8\u95e8\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<BpmTreeModel>> queryDeptTreeByChildren(BpmTreeModel bpmTreeModel) {
        return AssigneeService.queryDeptTreeByChildren((BpmTreeModel)bpmTreeModel);
    }

    @GetMapping(value={"/queryUserListByPage"})
    @ApiOperation(value="\u6839\u636e\u7528\u6237\u6811\u8282\u70b9\u5206\u9875\u67e5\u8be2\u7528\u6237", notes="\u6839\u636e\u7528\u6237\u6811\u8282\u70b9\u5206\u9875\u67e5\u8be2\u7528\u6237")
    @ApiImplicitParams(value={@ApiImplicitParam(name="page", value="\u5206\u9875\u4fe1\u606f", required=true, paramType="query"), @ApiImplicitParam(name="bpmTreeModel", value="\u5de5\u4f5c\u6d41\u6811\u6a21\u578b\u7c7b", paramType="query")})
    @AuditLog(moduleName="\u6839\u636e\u7528\u6237\u6811\u8282\u70b9\u5206\u9875\u67e5\u8be2\u7528\u6237", eventDesc="\u6839\u636e\u7528\u6237\u6811\u8282\u70b9\u5206\u9875\u67e5\u8be2\u7528\u6237", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Page<BpmTreeModel>> queryUserListByPage(Page<BpmTreeModel> pages, BpmTreeModel bpmTreeModel) {
        return AssigneeService.queryUserListByPage(pages, (BpmTreeModel)bpmTreeModel);
    }

    @GetMapping(value={"/queryRejectNode"})
    @ApiOperation(value="\u67e5\u8be2\u53ef\u4ee5\u9a73\u56de\u7684\u8282\u70b9", notes="\u67e5\u8be2\u53ef\u4ee5\u9a73\u56de\u7684\u8282\u70b9")
    @ApiImplicitParams(value={@ApiImplicitParam(name="taskId", value="\u4efb\u52a1ID", required=true, paramType="query")})
    public BpmResponseResult queryRejectNode(@RequestParam(value="taskId") String taskId) {
        return TaskEngineService.queryRejectNode((String)taskId, (boolean)true);
    }
}

