/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.base.common.event;

import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.base.common.utils.EventUtil;
import com.jxdinfo.hussar.formdesign.base.common.utils.MultilineExegesisUtil;
import com.jxdinfo.hussar.formdesign.common.ctx.Ctx;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.Action;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.LcdpComponent;
import com.jxdinfo.hussar.formdesign.common.render.RenderCore;
import com.jxdinfo.hussar.formdesign.common.render.RenderResult;
import com.jxdinfo.hussar.formdesign.common.visitor.ActionVisitor;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="Base.DataImportRecordsAction")
public class DataImportRecords
implements ActionVisitor {
    private FileMappingService fileMappingService;

    @Autowired
    public DataImportRecords(FileMappingService fileMappingService) {
        this.fileMappingService = fileMappingService;
    }

    public void visitor(Action action, Ctx ctx) throws Exception {
        String modelId;
        HashMap<String, String> templateMap = new HashMap<String, String>();
        RenderCore renderCore = new RenderCore();
        renderCore.registerTemplatePath("/template/common/event/DataImportRecords.ftl");
        LcdpComponent myLcdpComponent = action.getCurrentLcdpComponent();
        String trigger = action.getTrigger();
        String triggerName = myLcdpComponent.getInstanceKey() + trigger.substring(0, 1).toUpperCase() + trigger.substring(1);
        templateMap.put("trigger", triggerName);
        Map actionParams = (Map)action.getParamValues().get("dataImportRecords");
        String apiFileName = "";
        String apiFilePath = "";
        String operationName = "importDataRecords";
        String string = modelId = actionParams != null ? (String)actionParams.get("id") : null;
        if (ToolUtil.isNotEmpty((Object)modelId)) {
            templateMap.put("modelId", modelId);
            apiFileName = this.fileMappingService.getFileName(modelId);
            apiFilePath = this.fileMappingService.getImportPath(modelId);
        }
        if (ToolUtil.isNotEmpty((Object)apiFilePath)) {
            EventUtil.addCtxImport(ctx, apiFileName, apiFilePath);
            templateMap.put("apiFileName", apiFileName);
        }
        templateMap.put("operationName", operationName);
        templateMap.put("exegesisResult", MultilineExegesisUtil.handleActionExegesisText(action));
        ctx.addImports("DataImportRecordsDialog", "hussar-static-code-pc/src/components/DataImportRecords/index");
        renderCore.registerParam(templateMap);
        RenderResult renderResult = renderCore.render();
        if (renderResult.isStatus()) {
            ctx.addMethod(triggerName, renderResult.getRenderString(), false);
        }
    }
}

