/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.base.common.event;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.base.common.utils.ComponentDataUtil;
import com.jxdinfo.hussar.formdesign.base.common.utils.MappingUtils;
import com.jxdinfo.hussar.formdesign.base.common.utils.MultilineExegesisUtil;
import com.jxdinfo.hussar.formdesign.codegenerator.core.data.constant.DataFromEnum;
import com.jxdinfo.hussar.formdesign.codegenerator.core.data.mapping.DataItemMappingBO;
import com.jxdinfo.hussar.formdesign.codegenerator.core.data.model.ComponentReference;
import com.jxdinfo.hussar.formdesign.codegenerator.core.util.DataConfigUtil;
import com.jxdinfo.hussar.formdesign.common.ctx.Ctx;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.Action;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ComponentData;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.LcdpComponent;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.visitor.ActionVisitor;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component(value="Base.AddAssignmentAction")
public class AddAssignment
implements ActionVisitor {
    private static final String MAPPING_KEY = "mapping";

    public void visitor(Action action, Ctx ctx) throws Exception {
        LcdpComponent myLcdpComponent = action.getCurrentLcdpComponent();
        String trigger = action.getTrigger();
        String triggerName = myLcdpComponent.getInstanceKey() + ToolUtil.firstLetterToUpper((String)trigger);
        String exegesisResult = MultilineExegesisUtil.handleActionExegesisText(action);
        Map allParams = action.getParamValues();
        JSONObject params = (JSONObject)allParams.get("assignmentValue");
        if (ToolUtil.isEmpty((Object)params)) {
            return;
        }
        ComponentReference from = (ComponentReference)JSON.parseObject((String)params.getString("from"), ComponentReference.class);
        JSONArray mapping = params.getJSONArray(MAPPING_KEY);
        List mapsList = mapping.toJavaList(DataItemMappingBO.class);
        ComponentReference to = (ComponentReference)JSON.parseObject((String)params.getString("to"), ComponentReference.class);
        if (ToolUtil.isEmpty((Object)to.getType())) {
            to.setType(DataFromEnum.INSTANCE.getValue());
        }
        ComponentData toComponentData = DataConfigUtil.getDataConfigValue((Ctx)ctx, (ComponentReference)to);
        ComponentData fromComponentData = DataConfigUtil.getDataConfigValue((Ctx)ctx, (ComponentReference)from);
        Map<String, Object> resultMap = MappingUtils.getMappingResult(ctx, mapsList, from, to);
        if (HussarUtils.isNotEmpty((Object)fromComponentData)) {
            resultMap.put("fromDataItem", fromComponentData.getRenderValue());
            resultMap.put("fromDataType", fromComponentData.getDataType().getValue());
        }
        if (HussarUtils.isNotEmpty((Object)toComponentData)) {
            LcdpComponent lcdpComponent = (LcdpComponent)ctx.getComponentMap().get(to.getInstanceKey());
            if ("com.jxdinfo.elementui.JXDHEditTable".equals(((LcdpComponent)ctx.getComponentMap().get(to.getInstanceKey())).getName())) {
                String reference = "";
                resultMap.put("isEditorTable", true);
                resultMap.put("toInstanceKey", to.getInstanceKey());
                ComponentDataUtil.ComponentValueStatusEnum status = ComponentDataUtil.getComponentValueStatus(lcdpComponent, ctx, Collections.singletonList("value"));
                if (status.equals((Object)ComponentDataUtil.ComponentValueStatusEnum.NONE)) {
                    reference = "none";
                }
                resultMap.put("reference", reference);
            }
            resultMap.put("toDataItem", toComponentData.getRenderValue());
            resultMap.put("toDataType", toComponentData.getDataType().getValue());
        }
        resultMap.put("exegesisResult", exegesisResult);
        ctx.addMethodCommon(triggerName, RenderUtil.renderTemplate((String)"/template/common/event/AddAssignment.ftl", resultMap), false);
        if (HussarUtils.isNotEmpty((Object)fromComponentData) && HussarUtils.isNotEmpty((Object)fromComponentData.getDataType().getValue()) && "date".equals(fromComponentData.getDataType().getValue()) && HussarUtils.isNotEmpty((Object)toComponentData) && HussarUtils.isNotEmpty((Object)toComponentData.getDataType().getValue()) && "string".equals(toComponentData.getDataType().getValue())) {
            String pageType = ctx.getPageInfo().getType();
            if ("MobilePage".equals(pageType) || "UniPage".equals(pageType)) {
                ctx.addImports("dateFormatPublic", "@/utils/lowcode/dateFormatUtil");
            } else {
                ctx.addImports("dateFormatPublic", "@/pages/index/utils/lowcode/dateFormatUtil");
            }
        }
    }
}

