/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.base.common.event;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.instanceCheck.InstanceCheckItem;
import com.jxdinfo.hussar.formdesign.base.common.utils.MultilineExegesisUtil;
import com.jxdinfo.hussar.formdesign.codegenerator.core.data.model.ComponentReference;
import com.jxdinfo.hussar.formdesign.codegenerator.core.util.DataConfigUtil;
import com.jxdinfo.hussar.formdesign.codegenerator.core.util.ExtendCommonUtil;
import com.jxdinfo.hussar.formdesign.common.ctx.Ctx;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.Action;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ComponentData;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.LcdpComponent;
import com.jxdinfo.hussar.formdesign.common.render.RenderCore;
import com.jxdinfo.hussar.formdesign.common.render.RenderResult;
import com.jxdinfo.hussar.formdesign.common.runner.formcheck.FormCheckInfo;
import com.jxdinfo.hussar.formdesign.common.runner.formcheck.FormCheckObject;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.visitor.ActionVisitor;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component(value="Base.InstanceCheckAction")
public class InstanceCheck
implements ActionVisitor {
    public void visitor(Action action, Ctx ctx) throws Exception {
        LcdpComponent myLcdpComponent = action.getCurrentLcdpComponent();
        Map<String, Object> encapsulationValueMap = new HashMap<String, Object>();
        Map params = action.getParamValues();
        HashMap<String, String> instanceVerify = new HashMap<String, String>();
        List content = new ArrayList();
        ArrayList<JSONObject> insCheckObjects = new ArrayList<JSONObject>();
        JSONArray rules = (JSONArray)ctx.getRootLcdpComponent().getProps().get("rules");
        String trigger = action.getTrigger();
        String triggerName = myLcdpComponent.getInstanceKey() + ToolUtil.firstLetterToUpper((String)trigger);
        String ruleId = (String)params.get("checkRule");
        String instances = (String)params.get("checkInstance");
        String[] instanceArray = instances.split(",");
        String ruleName = "";
        String checkResult = "checkResult";
        String verifyInstances = "verifyInstances";
        String[] stringArray = instanceArray;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String ins;
            ComponentReference insReference = new ComponentReference(ins = stringArray[i], Collections.singletonList("value"));
            ComponentData insData = DataConfigUtil.getDataConfigValue((Ctx)ctx, (ComponentReference)insReference);
            instanceVerify.put(ins, null == insData ? "''" : insData.getRenderValue());
        }
        JSONArray contents = new JSONArray();
        for (int i = 0; i < rules.size(); ++i) {
            JSONObject rule = rules.getJSONObject(i);
            if (!rule.get((Object)"id").equals(ruleId)) continue;
            content = JSON.parseArray((String)rule.get((Object)"content").toString(), InstanceCheckItem.class);
            contents = JSON.parseArray((String)rule.get((Object)"content").toString());
            ruleName = (String)rule.get((Object)"name");
            checkResult = ruleName + "CheckResult";
            verifyInstances = ruleName + "VerifyInstances";
        }
        if (HussarUtils.isNotEmpty(content) && content.size() > 0) {
            RenderCore renderCore = new RenderCore();
            RenderCore verifyRenderCore = new RenderCore();
            Map formCheckMap = FormCheckInfo.formCheckMap;
            encapsulationValueMap.put("contents", content);
            for (int i = 0; i < content.size(); ++i) {
                InstanceCheckItem checkItem = (InstanceCheckItem)content.get(i);
                FormCheckObject formCheckObject = (FormCheckObject)formCheckMap.get(checkItem.getCheckType());
                if (!ToolUtil.isNotEmpty((Object)formCheckObject)) continue;
                String errorMsg = checkItem.getErrorMsg();
                JSONObject jsonObject = JSON.parseObject((String)JSON.toJSONString((Object)formCheckObject));
                jsonObject.put("errorMsg", (Object)errorMsg);
                jsonObject.put("customValue", (Object)checkItem.getCheckValue());
                insCheckObjects.add(jsonObject);
                if (!jsonObject.get((Object)"name").equals("implementFunction")) continue;
                encapsulationValueMap = this.renderImplementFunction(contents.getJSONObject(i), encapsulationValueMap, ctx);
            }
            encapsulationValueMap.put("checkList", insCheckObjects);
            encapsulationValueMap.put("components", instanceVerify);
            encapsulationValueMap.put("instanceKey", triggerName);
            encapsulationValueMap.put("ruleName", ruleName);
            encapsulationValueMap.put("checkResult", checkResult);
            encapsulationValueMap.put("verifyInstances", verifyInstances);
            encapsulationValueMap.put("exegesisResult", MultilineExegesisUtil.handleActionExegesisText(action));
            renderCore.registerTemplatePath("template/common/event/instanceCheck.ftl");
            renderCore.registerParam(encapsulationValueMap);
            verifyRenderCore.registerTemplatePath("/template/common/event/verify.ftl");
            verifyRenderCore.registerParam(encapsulationValueMap);
            RenderResult renderResult = renderCore.render();
            RenderResult verifyRenderResult = verifyRenderCore.render();
            ctx.addReturnValue(action.getId(), checkResult);
            if (renderResult.isStatus()) {
                ArrayList<String> param = new ArrayList<String>();
                param.add("verifyInstances");
                ctx.addMethodCommon(triggerName + "InstanceVerify" + ruleName, param, verifyRenderResult.getRenderString(), true);
                ctx.addMethod(trigger, triggerName, renderResult.getRenderString(), "");
            }
        }
    }

    public Map<String, Object> renderImplementFunction(JSONObject checkItem, Map<String, Object> moduleMap, Ctx ctx) throws Exception {
        List customFunction = (List)checkItem.get((Object)"customFunction");
        ArrayList customFuncConfig = new ArrayList();
        if (ToolUtil.isNotEmpty((Object)customFunction)) {
            for (Map objectMap : customFunction) {
                HashMap customFuncConfigMap = new HashMap();
                customFuncConfigMap.put("functionName", objectMap.get("functionName"));
                customFuncConfigMap.put("fileIdentify", objectMap.get("fileIdentify"));
                List paramList = (List)objectMap.get("params");
                ArrayList<String> paramName = new ArrayList<String>();
                if (ToolUtil.isNotEmpty((Object)paramList)) {
                    for (Map stringObjectMap : paramList) {
                        ComponentReference componentReference = (ComponentReference)JSON.parseObject((String)stringObjectMap.toString(), ComponentReference.class);
                        ComponentData paramData = DataConfigUtil.getDataConfigValue((Ctx)ctx, (ComponentReference)componentReference);
                        if (null != paramData) {
                            paramName.add(paramData.getRenderValue());
                            continue;
                        }
                        paramName.add("''");
                    }
                }
                customFuncConfigMap.put("paramName", paramName);
                customFuncConfig.add(customFuncConfigMap);
                if (objectMap.get("id") == null || objectMap.get("fileIdentify") == null) continue;
                ExtendCommonUtil.addExtendJsImport((Ctx)ctx, (String)objectMap.get("id").toString(), (String)objectMap.get("fileIdentify").toString(), ToolUtil.isEmpty(objectMap.get("type")) ? null : objectMap.get("type").toString());
            }
        }
        moduleMap.put("customFuncConfig", customFuncConfig);
        return moduleMap;
    }
}

