/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.base.common.event;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.base.common.utils.MappingUtils;
import com.jxdinfo.hussar.formdesign.base.common.utils.MultilineExegesisUtil;
import com.jxdinfo.hussar.formdesign.codegenerator.core.data.constant.DataFromEnum;
import com.jxdinfo.hussar.formdesign.codegenerator.core.data.mapping.DataItemMappingBO;
import com.jxdinfo.hussar.formdesign.codegenerator.core.data.model.ComponentReference;
import com.jxdinfo.hussar.formdesign.codegenerator.core.util.DataConfigUtil;
import com.jxdinfo.hussar.formdesign.common.ctx.Ctx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.Action;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ComponentData;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.LcdpComponent;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.visitor.ActionVisitor;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.stereotype.Component;

@Component(value="Base.AssignmentAction")
public class Assignment
implements ActionVisitor {
    private static final String MAPPING_KEY = "mapping";

    public void visitor(Action action, Ctx ctx) throws Exception {
        LcdpComponent myLcdpComponent = action.getCurrentLcdpComponent();
        String trigger = action.getTrigger();
        String triggerName = myLcdpComponent.getInstanceKey() + ToolUtil.firstLetterToUpper((String)trigger);
        Map allParams = action.getParamValues();
        JSONObject params = (JSONObject)allParams.get("assignmentValue");
        if (ToolUtil.isEmpty((Object)params)) {
            return;
        }
        ComponentReference from = (ComponentReference)JSON.parseObject((String)params.getString("from"), ComponentReference.class);
        JSONArray mapping = params.getJSONArray(MAPPING_KEY);
        List mapsList = mapping.toJavaList(DataItemMappingBO.class);
        ComponentReference to = (ComponentReference)JSON.parseObject((String)params.getString("to"), ComponentReference.class);
        if (ToolUtil.isEmpty((Object)to.getType())) {
            to.setType(DataFromEnum.INSTANCE.getValue());
        }
        ComponentData toComponentData = DataConfigUtil.getDataConfigValue((Ctx)ctx, (ComponentReference)to);
        ComponentData fromComponentData = DataConfigUtil.getDataConfigValue((Ctx)ctx, (ComponentReference)from);
        Map<String, Object> resultMap = MappingUtils.getMappingResult(ctx, mapsList, from, to);
        if (this.isComponentDataEmpty(fromComponentData).booleanValue()) {
            resultMap.put("fromDataItem", fromComponentData.getRenderValue());
            resultMap.put("fromDataType", fromComponentData.getDataType().getValue());
            resultMap.put("dataType", from.getType());
            ctx.addImports("*", "_", "lodash");
        }
        if (this.isComponentDataEmpty(toComponentData).booleanValue()) {
            LcdpComponent lcdpComponent;
            if (ToolUtil.isNotEmpty((Object)to.getInstanceKey()) && ToolUtil.isNotEmpty((Object)(lcdpComponent = (LcdpComponent)ctx.getComponentMap().get(to.getInstanceKey())))) {
                List list;
                if (ToolUtil.isNotEmpty((Object)to.getInstanceKey()) && "com.jxdinfo.elementui.JXDElSelect".equals(((LcdpComponent)ctx.getComponentMap().get(to.getInstanceKey())).getName())) {
                    resultMap.put("isToSelect", true);
                    resultMap.put("toInstanceKey", to.getInstanceKey());
                }
                JSONArray optColsJSONArray = (JSONArray)lcdpComponent.getProps().get("opt_cols");
                Map colTypeList = lcdpComponent.getChildrenComponents();
                if (ToolUtil.isNotEmpty((Object)colTypeList) && ToolUtil.isNotEmpty((Object)to.getInstanceData()) && to.getInstanceData().size() > 1 && ToolUtil.isNotEmpty(to.getInstanceData().get(1)) && ToolUtil.isNotEmpty(colTypeList.get(to.getInstanceData().get(1))) && ToolUtil.isNotEmpty((Object)(list = (List)colTypeList.get(to.getInstanceData().get(1))))) {
                    String a1 = ((LcdpComponent)list.get(0)).getName();
                    String instanceKey = ((LcdpComponent)((List)colTypeList.get(to.getInstanceData().get(1))).get(0)).getInstanceKey();
                    if (ToolUtil.isNotEmpty((Object)a1) && "com.jxdinfo.elementui.JXDElSelect".equals(a1)) {
                        resultMap.put("isToSelect", true);
                        resultMap.put("toInstanceKey", instanceKey);
                        resultMap.put("toParentInstanceKey", to.getInstanceKey());
                    }
                }
            }
            resultMap.put("toDataItem", toComponentData.getRenderValue());
            resultMap.put("toDataType", toComponentData.getDataType().getValue());
        }
        resultMap.put("instanceKey", myLcdpComponent.getInstanceKey());
        if (ToolUtil.isNotEmpty((Object)resultMap.get("toDataType")) && resultMap.get("toDataType").equals(ComponentData.DataTypeEnum.DATE.getValue())) {
            ctx.addImports("dateFormatPublic", "@/pages/index/utils/lowcode/dateFormatUtil");
        }
        resultMap.put("data_convert", RenderUtil.renderTemplate((String)"/template/common/dataitem/data_convert_mapping.ftl", resultMap));
        if (HussarUtils.isNotEmpty((Object)toComponentData) && HussarUtils.isNotEmpty((Object)toComponentData.getDataType().getValue()) && "string".equals(toComponentData.getDataType().getValue()) && HussarUtils.isNotEmpty((Object)fromComponentData) && HussarUtils.isNotEmpty((Object)fromComponentData.getDataType().getValue()) && "date".equals(fromComponentData.getDataType().getValue())) {
            String pageType = ctx.getPageInfo().getType();
            if ("MobilePage".equals(pageType) || "UniPage".equals(pageType)) {
                ctx.addImports("dateFormatPublic", "@/utils/lowcode/dateFormatUtil");
            } else {
                ctx.addImports("dateFormatPublic", "@/pages/index/utils/lowcode/dateFormatUtil");
            }
        }
        resultMap.put("exegesisResult", MultilineExegesisUtil.handleActionExegesisText(action));
        ctx.addMethodCommon(triggerName, RenderUtil.renderTemplate((String)"/template/common/event/Assignment.ftl", resultMap), false);
        LcdpComponent toComponent = (LcdpComponent)ctx.getComponentMap().get(to.getInstanceKey());
        Assignment.renderTreeMethod(myLcdpComponent, toComponent, ctx, resultMap);
    }

    private static void renderTreeMethod(LcdpComponent lcdpComponent, LcdpComponent toComponent, Ctx ctx, Map<String, Object> params) throws LcdpException {
        if (ToolUtil.isNotEmpty((Object)params.get("fromDataType")) && ToolUtil.isNotEmpty((Object)params.get("toDataType"))) {
            if (params.get("toDataType").equals(ComponentData.DataTypeEnum.TREE_OBJECT.getValue()) && params.get("fromDataType").equals(ComponentData.DataTypeEnum.TREE_OBJECT.getValue())) {
                List<String> args = Arrays.asList("fromData", "computedRes");
                ctx.addMethod(lcdpComponent.getInstanceKey() + "fromTreeGetValue", args, RenderUtil.renderTemplate((String)"/template/common/dataitem/get_value_from_tree.ftl", params), true);
            }
            if (params.get("toDataType").equals(ComponentData.DataTypeEnum.TREE_OBJECT.getValue()) && params.get("fromDataType").equals(ComponentData.DataTypeEnum.ARRAY_OBJECT.getValue())) {
                List<String> getValueArgs = Collections.singletonList("fromData");
                List<String> getValueChildrenArgs = Arrays.asList("datas", "rootDataArray");
                List mappingList = (List)params.get(MAPPING_KEY);
                String idField = "id";
                String pidField = "pid";
                JSONArray hiddenCols = (JSONArray)toComponent.getProps().get("hidden_cols");
                if (ToolUtil.isNotEmpty((Object)hiddenCols)) {
                    for (Object col : hiddenCols) {
                        JSONObject colObj = (JSONObject)col;
                        if ("jxd-tree-table-fix-id".equals(colObj.getString("id"))) {
                            idField = colObj.getString("field");
                        }
                        if (!"jxd-tree-table-fix-pid".equals(colObj.getString("id"))) continue;
                        pidField = colObj.getString("field");
                    }
                }
                params.put("id", idField);
                if (ToolUtil.isNotEmpty(toComponent.getProps().get("root"))) {
                    String root = String.valueOf(toComponent.getProps().get("root"));
                    params.put("root", root);
                }
                if (ToolUtil.isNotEmpty((Object)mappingList)) {
                    AtomicBoolean havePid = new AtomicBoolean(false);
                    String pid = pidField;
                    mappingList.forEach(mapping -> {
                        DataItemMappingBO dataItemMappingBO = (DataItemMappingBO)mapping;
                        if (((String)dataItemMappingBO.getToDataItem()).equals(pid)) {
                            params.put("pid", dataItemMappingBO.getFromDataItem());
                            havePid.set(true);
                        }
                    });
                    if (!havePid.get()) {
                        params.put("pid", pidField);
                    }
                    ctx.addMethod(lcdpComponent.getInstanceKey() + "fromArrayGetValue", getValueArgs, RenderUtil.renderTemplate((String)"/template/common/dataitem/get_value_from_array.ftl", params), true);
                    ctx.addMethod(lcdpComponent.getInstanceKey() + "fromArrayGetValueChildren", getValueChildrenArgs, RenderUtil.renderTemplate((String)"/template/common/dataitem/get_value_from_array_children.ftl", params), false);
                }
            }
        }
    }

    private Boolean isComponentDataEmpty(ComponentData componentData) {
        Boolean isOk = true;
        if (ToolUtil.isNotEmpty((Object)componentData)) {
            if ("".equals(componentData.getRenderValue())) {
                isOk = false;
            }
            if (ToolUtil.isEmpty((Object)componentData.getDataType()) || "".equals(componentData.getDataType().getValue())) {
                isOk = false;
            }
        } else {
            isOk = false;
        }
        return isOk;
    }
}

