/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.base.common.event;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.base.common.utils.MultilineExegesisUtil;
import com.jxdinfo.hussar.formdesign.codegenerator.core.data.model.ComponentReference;
import com.jxdinfo.hussar.formdesign.codegenerator.core.util.DataConfigUtil;
import com.jxdinfo.hussar.formdesign.common.ctx.Ctx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.Action;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ComponentData;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.LcdpComponent;
import com.jxdinfo.hussar.formdesign.common.render.RenderCore;
import com.jxdinfo.hussar.formdesign.common.render.RenderResult;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.visitor.ActionVisitor;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="Base.HyperlinksAction")
public class Hyperlinks
implements ActionVisitor {
    @Autowired
    private FileMappingService fileMappingService;

    public void visitor(Action action, Ctx ctx) throws Exception {
        HashMap<String, Object> moduleMap = new HashMap<String, Object>();
        RenderCore renderCore = new RenderCore();
        String pageType = ctx.getPageInfo().getType();
        if ("MobilePage".equals(pageType) || "UniPage".equals(pageType)) {
            renderCore.registerTemplatePath("/template/common/event/MobileHyperlinks.ftl");
            moduleMap.put("isMobilePage", "MobilePage".equals(pageType));
        } else {
            renderCore.registerTemplatePath("/template/common/event/Hyperlinks.ftl");
        }
        LcdpComponent myLcdpComponent = action.getCurrentLcdpComponent();
        String trigger = action.getTrigger();
        String triggerName = myLcdpComponent.getInstanceKey() + ToolUtil.firstLetterToUpper((String)trigger);
        moduleMap.put("trigger", triggerName);
        Map params = (Map)action.getParamValues().get("hyperlinks");
        if (ToolUtil.isNotEmpty((Object)params)) {
            Map<String, Object> config;
            Map pageParamConfig;
            String id = (String)params.get("fileId");
            String routerPath = null;
            if (ToolUtil.isNotEmpty((Object)id)) {
                routerPath = FileUtil.posixPath((String[])new String[]{"${PREFIX.pathName}", this.fileMappingService.getFormatPath(id)});
                ctx.addImports("PREFIX", "#/prefixCommon");
            }
            if (ToolUtil.isNotEmpty((Object)(pageParamConfig = (Map)params.get("pageParamConfig"))) && (config = Hyperlinks.getRenderPageParamData(ctx, pageParamConfig)).size() > 0) {
                StringBuilder paramStr = new StringBuilder();
                Object[] keySet = config.keySet().toArray();
                for (int i = 0; i < keySet.length; ++i) {
                    JSONObject ppcElement = (JSONObject)pageParamConfig.get(keySet[i]);
                    if (i == keySet.length - 1) {
                        if (ppcElement.get((Object)"type").equals("input") || ppcElement.get((Object)"type").equals("constant")) {
                            paramStr.append(keySet[i] + "=" + config.get(keySet[i]).toString().replace("'", ""));
                            continue;
                        }
                        paramStr.append(keySet[i] + "=${" + config.get(keySet[i]) + "}");
                        continue;
                    }
                    if (ppcElement.get((Object)"type").equals("input") || ppcElement.get((Object)"type").equals("constant")) {
                        paramStr.append(keySet[i] + "=" + config.get(keySet[i]).toString().replace("'", "") + "&");
                        continue;
                    }
                    paramStr.append(keySet[i] + "=${" + config.get(keySet[i]) + "}&");
                }
                moduleMap.put("params", config);
                moduleMap.put("paramStr", paramStr);
            }
            moduleMap.put("url", routerPath);
            if (ToolUtil.isNotEmpty(params.get("jumpType"))) {
                moduleMap.put("jumpType", params.get("jumpType"));
            }
            if (ToolUtil.isNotEmpty(params.get("closeCurrent"))) {
                moduleMap.put("closeCurrent", params.get("closeCurrent"));
            }
        }
        moduleMap.put("exegesisResult", MultilineExegesisUtil.handleActionExegesisText(action));
        renderCore.registerParam(moduleMap);
        RenderResult renderResult = renderCore.render();
        if (renderResult.isStatus()) {
            ctx.addMethodCommon(triggerName, renderResult.getRenderString(), false);
        }
    }

    private static Map<String, Object> getRenderPageParamData(Ctx ctx, Map<String, Object> pageParamConfig) throws LcdpException {
        HashMap<String, Object> paramConfig = new HashMap<String, Object>();
        for (String key : pageParamConfig.keySet()) {
            ComponentReference componentReference = (ComponentReference)JSON.parseObject((String)pageParamConfig.get(key).toString(), ComponentReference.class);
            ComponentData data = DataConfigUtil.getDataConfigValue((Ctx)ctx, (ComponentReference)componentReference);
            if (null != data) {
                paramConfig.put(key, data.getRenderValue());
                continue;
            }
            paramConfig.put(key, "''");
        }
        return paramConfig;
    }
}

