/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.base.common.event;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.base.common.utils.MultilineExegesisUtil;
import com.jxdinfo.hussar.formdesign.codegenerator.core.data.constant.DataFromEnum;
import com.jxdinfo.hussar.formdesign.codegenerator.core.data.model.ComponentReference;
import com.jxdinfo.hussar.formdesign.codegenerator.core.util.DataConfigUtil;
import com.jxdinfo.hussar.formdesign.common.ctx.Ctx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.Action;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ComponentData;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.LcdpComponent;
import com.jxdinfo.hussar.formdesign.common.render.RenderCore;
import com.jxdinfo.hussar.formdesign.common.render.RenderResult;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.visitor.ActionVisitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component(value="Base.CustomMethods")
public class CustomMethods
implements ActionVisitor {
    public void visitor(Action action, Ctx ctx) throws Exception {
        HashMap<String, String> methodsMap = new HashMap<String, String>();
        RenderCore renderCore = new RenderCore();
        renderCore.registerTemplatePath("/template/common/event/CustomMethods.ftl");
        LcdpComponent myLcdpComponent = action.getCurrentLcdpComponent();
        String trigger = action.getTrigger();
        String triggerName = myLcdpComponent.getInstanceKey() + ToolUtil.firstLetterToUpper((String)trigger);
        methodsMap.put("trigger", triggerName);
        String methodName = action.getActionQualifiedName().toString().substring(5);
        methodsMap.put("methodName", methodName);
        Map params = action.getParamValues();
        if (ToolUtil.isNotEmpty((Object)params)) {
            List valueList = (List)params.get("customParamValue");
            ArrayList<String> paramsValue = new ArrayList<String>();
            if (ToolUtil.isNotEmpty((Object)valueList)) {
                for (Map value : valueList) {
                    JSONObject paramValue = (JSONObject)value;
                    String configData = paramValue.getJSONObject("componentReference").toString();
                    ComponentReference reference = (ComponentReference)JSON.parseObject((String)configData, ComponentReference.class);
                    String result = "''";
                    if (DataFromEnum.INPUT.getValue().equals(reference.getType()) && ToolUtil.isEmpty((Object)reference.getDataType())) {
                        reference.setDataType("string");
                    }
                    try {
                        ComponentData fromComponentData = DataConfigUtil.getDataConfigValue((Ctx)ctx, (ComponentReference)reference);
                        if (ToolUtil.isNotEmpty((Object)fromComponentData)) {
                            result = fromComponentData.getRenderValue();
                        }
                    }
                    catch (LcdpException e) {
                        e.printStackTrace();
                    }
                    paramsValue.add(result);
                }
                if (ToolUtil.isNotEmpty(paramsValue)) {
                    StringBuilder paramsStr = new StringBuilder();
                    for (String str : paramsValue) {
                        paramsStr.append(str).append(",");
                    }
                    paramsStr = new StringBuilder(paramsStr.substring(0, paramsStr.length() - 1));
                    methodsMap.put("paramsStr", paramsStr.toString());
                }
            }
        }
        methodsMap.put("exegesisResult", MultilineExegesisUtil.handleActionExegesisText(action));
        renderCore.registerParam(methodsMap);
        RenderResult renderResult = renderCore.render();
        if (renderResult.isStatus()) {
            ctx.addMethodCommon(triggerName, renderResult.getRenderString(), false);
        }
    }
}

