/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.base.common.utils;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.dataitem.reference.GetValueBO;
import com.jxdinfo.hussar.formdesign.base.common.constant.CodePrefix;
import com.jxdinfo.hussar.formdesign.base.common.constant.CodeSuffix;
import com.jxdinfo.hussar.formdesign.base.common.utils.ComponentDataUtil;
import com.jxdinfo.hussar.formdesign.base.common.utils.DefaultValueUtil;
import com.jxdinfo.hussar.formdesign.base.common.utils.MultilineExegesisUtil;
import com.jxdinfo.hussar.formdesign.common.ctx.Ctx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ComponentData;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.LcdpComponent;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.visitor.BaseProvideVisitor;
import com.jxdinfo.hussar.formdesign.common.visitor.ValueVisitor;
import java.util.ArrayList;
import java.util.List;

public class RenderVModelUtil {
    public static String getComponentAttr(LcdpComponent lcdpComponent, Ctx ctx, List<String> dataItems) throws LcdpException {
        ComponentData.ComponentDataSourceRWEnum componentRW = ComponentDataUtil.getComponentRW(lcdpComponent, ctx, dataItems);
        if (ComponentData.ComponentDataSourceRWEnum.RW.equals((Object)componentRW)) {
            return CodePrefix._V_MODEL.getType();
        }
        return CodePrefix._VALUE.getType();
    }

    public static ComponentData renderDataItem(LcdpComponent lcdpComponent, Ctx ctx, String suffix, List<String> dataItems, String defaultValue) throws LcdpException {
        if (ToolUtil.isEmpty((Object)lcdpComponent.getListParentKeyChain())) {
            return RenderVModelUtil.renderDataItemHasVariables(lcdpComponent, ctx, suffix, dataItems, defaultValue);
        }
        return RenderVModelUtil.renderDataItemNotVariables(lcdpComponent, ctx, suffix, dataItems, defaultValue);
    }

    public static ComponentData renderArrayDataItem(LcdpComponent lcdpComponent, Ctx ctx, String suffix, List<String> dataItems, String defaultValue) throws LcdpException {
        if (ToolUtil.isEmpty((Object)lcdpComponent.getListParentKeyChain())) {
            return RenderVModelUtil.renderArrayDataItemHasVariables(lcdpComponent, ctx, suffix, dataItems, defaultValue);
        }
        return RenderVModelUtil.renderArrayDataItemNotVariables(lcdpComponent, ctx, suffix, dataItems, defaultValue);
    }

    public static ComponentData renderDataItemHasVariables(LcdpComponent lcdpComponent, Ctx ctx, String suffix, List<String> dataItems, String defaultValue) throws LcdpException {
        ComponentData componentData = new ComponentData();
        String finalResult = lcdpComponent.getInstanceKey() + suffix;
        if (ToolUtil.isEmpty(dataItems)) {
            dataItems = new ArrayList<String>();
            dataItems.add("value");
        }
        if (ToolUtil.isEmpty((Object)suffix)) {
            suffix = CodeSuffix._DATA.getType();
        }
        ValueVisitor valueVisitor = (ValueVisitor)lcdpComponent.getProvideVisitor("value");
        lcdpComponent.accept((BaseProvideVisitor)valueVisitor, ctx, null);
        ComponentDataUtil.ComponentValueStatusEnum dataItemValueStatus = ComponentDataUtil.getComponentValueStatus(lcdpComponent, ctx, dataItems);
        switch (dataItemValueStatus) {
            case SPECICAL_QUOTE: 
            case GET_VALUE: {
                ComponentData dataSourceByDataItem = valueVisitor.getDataSourceByDataItem(dataItems);
                if (ToolUtil.isNotEmpty((Object)dataSourceByDataItem) && ToolUtil.isNotEmpty((Object)dataSourceByDataItem.getRenderValue())) {
                    return dataSourceByDataItem;
                }
                ComponentDataUtil.renderDataItemComputed(lcdpComponent, ctx, suffix, dataItems);
                componentData.setRenderValue(finalResult);
                componentData.setComponentDataSourceRWEnum(ComponentData.ComponentDataSourceRWEnum.READONLY);
                break;
            }
            case QUOTE: {
                ComponentData data = valueVisitor.getDataItemValue(dataItems);
                if (null != data && ToolUtil.isNotEmpty((Object)data.getRenderValue()) && !data.getRenderValue().equals(ComponentData.EMPTY_DATA.getRenderValue()) && !ComponentData.DataItemSourceEnum.READONLY.equals((Object)data.getDataItemSource())) {
                    componentData.setRenderValue(ComponentDataUtil.dealPrefixThis(data.getRenderValue()));
                    componentData.setComponentDataSourceRWEnum(ComponentDataUtil.getComponentRW(lcdpComponent, ctx, dataItems));
                    break;
                }
                ComponentData defaultValueByDataItem = valueVisitor.getDefaultValueByDataItem(dataItems);
                if (ToolUtil.isNotEmpty((Object)defaultValueByDataItem) && ToolUtil.isNotEmpty((Object)defaultValueByDataItem.getRenderValue())) {
                    return defaultValueByDataItem;
                }
                RenderVModelUtil.setNormalData(ctx, lcdpComponent, suffix, defaultValue, dataItems);
                componentData.setRenderValue(finalResult);
                componentData.setComponentDataSourceRWEnum(ComponentData.ComponentDataSourceRWEnum.RW);
                break;
            }
            case NONE: {
                ComponentData defaultValueByDataItem = valueVisitor.getDefaultValueByDataItem(dataItems);
                if (ToolUtil.isNotEmpty((Object)defaultValueByDataItem) && ToolUtil.isNotEmpty((Object)defaultValueByDataItem.getRenderValue())) {
                    return defaultValueByDataItem;
                }
                RenderVModelUtil.setNormalData(ctx, lcdpComponent, suffix, defaultValue, dataItems);
                componentData.setRenderValue(finalResult);
                componentData.setComponentDataSourceRWEnum(ComponentData.ComponentDataSourceRWEnum.RW);
            }
        }
        componentData.setComponentValueStatusEnum(dataItemValueStatus.name());
        return componentData;
    }

    public static ComponentData renderArrayDataItemHasVariables(LcdpComponent lcdpComponent, Ctx ctx, String suffix, List<String> dataItems, String defaultValue) throws LcdpException {
        ComponentData componentData = new ComponentData();
        String finalResult = lcdpComponent.getInstanceKey() + suffix;
        if (ToolUtil.isEmpty(dataItems)) {
            dataItems = new ArrayList<String>();
            dataItems.add("value");
        }
        if (ToolUtil.isEmpty((Object)suffix)) {
            suffix = CodeSuffix._DATA.getType();
        }
        ValueVisitor valueVisitor = (ValueVisitor)lcdpComponent.getProvideVisitor("value");
        lcdpComponent.accept((BaseProvideVisitor)valueVisitor, ctx, null);
        ComponentDataUtil.ComponentValueStatusEnum dataItemValueStatus = ComponentDataUtil.getComponentValueStatus(lcdpComponent, ctx, dataItems);
        switch (dataItemValueStatus) {
            case SPECICAL_QUOTE: 
            case GET_VALUE: {
                ComponentData dataSourceByDataItem = valueVisitor.getDataSourceByDataItem(dataItems);
                if (ToolUtil.isNotEmpty((Object)dataSourceByDataItem) && ToolUtil.isNotEmpty((Object)dataSourceByDataItem.getRenderValue())) {
                    return dataSourceByDataItem;
                }
                ComponentDataUtil.renderArrayDataItemComputed(lcdpComponent, ctx, suffix, dataItems);
                componentData.setRenderValue(finalResult);
                componentData.setComponentDataSourceRWEnum(ComponentData.ComponentDataSourceRWEnum.READONLY);
                break;
            }
            case QUOTE: {
                ComponentData data = valueVisitor.getDataItemValue(dataItems);
                if (null != data && ToolUtil.isNotEmpty((Object)data.getRenderValue()) && !data.getRenderValue().equals(ComponentData.EMPTY_DATA.getRenderValue()) && !ComponentData.DataItemSourceEnum.READONLY.equals((Object)data.getDataItemSource())) {
                    componentData.setRenderValue(ComponentDataUtil.dealPrefixThis(data.getRenderValue()));
                    componentData.setComponentDataSourceRWEnum(ComponentDataUtil.getComponentRW(lcdpComponent, ctx, dataItems));
                    break;
                }
                ComponentData defaultValueByDataItem = valueVisitor.getDefaultValueByDataItem(dataItems);
                if (ToolUtil.isNotEmpty((Object)defaultValueByDataItem) && ToolUtil.isNotEmpty((Object)defaultValueByDataItem.getRenderValue())) {
                    return defaultValueByDataItem;
                }
                RenderVModelUtil.setNormalData(ctx, lcdpComponent, suffix, defaultValue, dataItems);
                componentData.setRenderValue(finalResult);
                componentData.setComponentDataSourceRWEnum(ComponentData.ComponentDataSourceRWEnum.RW);
                break;
            }
            case NONE: {
                ComponentData defaultValueByDataItem = valueVisitor.getDefaultValueByDataItem(dataItems);
                if (ToolUtil.isNotEmpty((Object)defaultValueByDataItem) && ToolUtil.isNotEmpty((Object)defaultValueByDataItem.getRenderValue())) {
                    return defaultValueByDataItem;
                }
                RenderVModelUtil.setNormalData(ctx, lcdpComponent, suffix, defaultValue, dataItems);
                componentData.setRenderValue(finalResult);
                componentData.setComponentDataSourceRWEnum(ComponentData.ComponentDataSourceRWEnum.RW);
            }
        }
        componentData.setComponentValueStatusEnum(dataItemValueStatus.name());
        return componentData;
    }

    public static ComponentData renderDataItemNotVariables(LcdpComponent lcdpComponent, Ctx ctx, String suffix, List<String> dataItems, String defaultValue) throws LcdpException {
        ComponentData componentData = new ComponentData();
        if (ToolUtil.isEmpty(dataItems)) {
            dataItems = new ArrayList<String>();
            dataItems.add("value");
        }
        if (ToolUtil.isEmpty((Object)suffix)) {
            suffix = CodeSuffix._DATA.getType();
        }
        if (null == defaultValue) {
            defaultValue = "''";
        }
        ValueVisitor valueVisitor = (ValueVisitor)lcdpComponent.getProvideVisitor("value");
        lcdpComponent.accept((BaseProvideVisitor)valueVisitor, ctx, null);
        ComponentDataUtil.ComponentValueStatusEnum dataItemValueStatus = ComponentDataUtil.getComponentValueStatus(lcdpComponent, ctx, dataItems);
        switch (dataItemValueStatus) {
            case SPECICAL_QUOTE: 
            case GET_VALUE: {
                ComponentData dataSourceByDataItem = valueVisitor.getDataSourceByDataItem(dataItems);
                if (ToolUtil.isNotEmpty((Object)dataSourceByDataItem) && ToolUtil.isNotEmpty((Object)dataSourceByDataItem.getRenderValue())) {
                    return dataSourceByDataItem;
                }
                ComponentDataUtil.renderDataItemMethod(lcdpComponent, ctx, suffix, dataItems);
                String paramData = ComponentDataUtil.listToString(ctx.getCycleInputParameter());
                String finalResult = "cal" + ToolUtil.firstLetterToUpper((String)(lcdpComponent.getInstanceKey() + suffix)) + "(" + paramData + ")";
                componentData.setRenderValue(finalResult);
                componentData.setComponentDataSourceRWEnum(ComponentData.ComponentDataSourceRWEnum.READONLY);
                break;
            }
            case QUOTE: {
                ComponentData data = valueVisitor.getDataItemValue(dataItems);
                if (null != data && ToolUtil.isNotEmpty((Object)data.getRenderValue()) && !data.getRenderValue().equals(ComponentData.EMPTY_DATA.getRenderValue()) && !ComponentData.DataItemSourceEnum.READONLY.equals((Object)data.getDataItemSource())) {
                    componentData.setRenderValue(ComponentDataUtil.dealPrefixThis(data.getRenderValue()));
                    componentData.setComponentDataSourceRWEnum(ComponentDataUtil.getComponentRW(lcdpComponent, ctx, dataItems));
                    break;
                }
                componentData.setRenderValue(defaultValue);
                componentData.setComponentDataSourceRWEnum(ComponentData.ComponentDataSourceRWEnum.NONE);
                break;
            }
            case NONE: {
                componentData.setRenderValue(defaultValue);
                componentData.setComponentDataSourceRWEnum(ComponentData.ComponentDataSourceRWEnum.NONE);
            }
        }
        componentData.setComponentValueStatusEnum(dataItemValueStatus.name());
        return componentData;
    }

    public static ComponentData renderArrayDataItemNotVariables(LcdpComponent lcdpComponent, Ctx ctx, String suffix, List<String> dataItems, String defaultValue) throws LcdpException {
        ComponentData componentData = new ComponentData();
        if (ToolUtil.isEmpty(dataItems)) {
            dataItems = new ArrayList<String>();
            dataItems.add("value");
        }
        if (ToolUtil.isEmpty((Object)suffix)) {
            suffix = CodeSuffix._DATA.getType();
        }
        if (null == defaultValue) {
            defaultValue = "''";
        }
        ValueVisitor valueVisitor = (ValueVisitor)lcdpComponent.getProvideVisitor("value");
        lcdpComponent.accept((BaseProvideVisitor)valueVisitor, ctx, null);
        ComponentDataUtil.ComponentValueStatusEnum dataItemValueStatus = ComponentDataUtil.getComponentValueStatus(lcdpComponent, ctx, dataItems);
        switch (dataItemValueStatus) {
            case SPECICAL_QUOTE: 
            case GET_VALUE: {
                ComponentData dataSourceByDataItem = valueVisitor.getDataSourceByDataItem(dataItems);
                if (ToolUtil.isNotEmpty((Object)dataSourceByDataItem) && ToolUtil.isNotEmpty((Object)dataSourceByDataItem.getRenderValue())) {
                    return dataSourceByDataItem;
                }
                ComponentDataUtil.renderArrayDataItemMethod(lcdpComponent, ctx, suffix, dataItems);
                String paramData = ComponentDataUtil.listToString(ctx.getCycleInputParameter());
                String finalResult = "cal" + ToolUtil.firstLetterToUpper((String)(lcdpComponent.getInstanceKey() + suffix)) + "(" + paramData + ")";
                componentData.setRenderValue(finalResult);
                componentData.setComponentDataSourceRWEnum(ComponentData.ComponentDataSourceRWEnum.READONLY);
                break;
            }
            case QUOTE: {
                ComponentData data = valueVisitor.getDataItemValue(dataItems);
                if (null != data && ToolUtil.isNotEmpty((Object)data.getRenderValue()) && !data.getRenderValue().equals(ComponentData.EMPTY_DATA.getRenderValue()) && !ComponentData.DataItemSourceEnum.READONLY.equals((Object)data.getDataItemSource())) {
                    componentData.setRenderValue(ComponentDataUtil.dealPrefixThis(data.getRenderValue()));
                    componentData.setComponentDataSourceRWEnum(ComponentDataUtil.getComponentRW(lcdpComponent, ctx, dataItems));
                    break;
                }
                componentData.setRenderValue(defaultValue);
                componentData.setComponentDataSourceRWEnum(ComponentData.ComponentDataSourceRWEnum.NONE);
                break;
            }
            case NONE: {
                componentData.setRenderValue(defaultValue);
                componentData.setComponentDataSourceRWEnum(ComponentData.ComponentDataSourceRWEnum.NONE);
            }
        }
        componentData.setComponentValueStatusEnum(dataItemValueStatus.name());
        return componentData;
    }

    public static String renderDataItemDataOrComputed(LcdpComponent lcdpComponent, Ctx ctx, String suffix, List<String> dataItems, String defaultValue) throws LcdpException {
        String finalResult = lcdpComponent.getInstanceKey() + suffix;
        if (ToolUtil.isEmpty(dataItems)) {
            dataItems = new ArrayList<String>();
            dataItems.add("value");
        }
        if (ToolUtil.isEmpty((Object)suffix)) {
            suffix = CodeSuffix._DATA.getType();
        }
        ComponentDataUtil.ComponentValueStatusEnum dataItemValueStatus = ComponentDataUtil.getComponentValueStatus(lcdpComponent, ctx, dataItems);
        ComponentDataUtil.renderDataItemComputed(lcdpComponent, ctx, suffix, dataItems);
        switch (dataItemValueStatus) {
            case SPECICAL_QUOTE: 
            case GET_VALUE: {
                break;
            }
            case QUOTE: {
                ValueVisitor valueVisitor = (ValueVisitor)lcdpComponent.getProvideVisitor("value");
                lcdpComponent.accept((BaseProvideVisitor)valueVisitor, ctx, null);
                ComponentData data = valueVisitor.getDataItemValue(dataItems);
                if (null != data && ToolUtil.isNotEmpty((Object)data.getRenderValue()) && !data.getRenderValue().equals(ComponentData.EMPTY_DATA.getRenderValue()) && !ComponentData.DataItemSourceEnum.READONLY.equals((Object)data.getDataItemSource())) {
                    finalResult = ComponentDataUtil.dealPrefixThis(data.getRenderValue());
                    break;
                }
                RenderVModelUtil.setNormalData(ctx, lcdpComponent, suffix, defaultValue, dataItems);
                break;
            }
            case NONE: {
                RenderVModelUtil.setNormalData(ctx, lcdpComponent, suffix, defaultValue, dataItems);
            }
        }
        return finalResult;
    }

    public static String renderDataItemDataOrMethods(LcdpComponent lcdpComponent, Ctx ctx, String suffix, List<String> dataItems, String defaultValue) throws LcdpException {
        String finalResult;
        if (ToolUtil.isEmpty(dataItems)) {
            dataItems = new ArrayList<String>();
            dataItems.add("value");
        }
        if (ToolUtil.isEmpty((Object)suffix)) {
            suffix = CodeSuffix._DATA.getType();
        }
        if (null == defaultValue) {
            defaultValue = "''";
        }
        ComponentDataUtil.renderDataItemMethod(lcdpComponent, ctx, suffix, dataItems);
        ComponentDataUtil.ComponentValueStatusEnum dataItemValueStatus = ComponentDataUtil.getComponentValueStatus(lcdpComponent, ctx, dataItems);
        switch (dataItemValueStatus) {
            case SPECICAL_QUOTE: 
            case GET_VALUE: {
                String paramData = ComponentDataUtil.listToString(ctx.getCycleInputParameter());
                finalResult = "cal" + ToolUtil.firstLetterToUpper((String)(lcdpComponent.getInstanceKey() + suffix)) + "(" + paramData + ")";
                break;
            }
            case QUOTE: {
                ValueVisitor valueVisitor = (ValueVisitor)lcdpComponent.getProvideVisitor("value");
                lcdpComponent.accept((BaseProvideVisitor)valueVisitor, ctx, null);
                ComponentData data = valueVisitor.getDataItemValue(dataItems);
                if (null != data && ToolUtil.isNotEmpty((Object)data.getRenderValue()) && !data.getRenderValue().equals(ComponentData.EMPTY_DATA.getRenderValue()) && !ComponentData.DataItemSourceEnum.READONLY.equals((Object)data.getDataItemSource())) {
                    finalResult = ComponentDataUtil.dealPrefixThis(data.getRenderValue());
                    break;
                }
                finalResult = defaultValue;
                break;
            }
            case NONE: {
                finalResult = defaultValue;
                break;
            }
            default: {
                finalResult = lcdpComponent.getInstanceKey() + suffix;
            }
        }
        return finalResult;
    }

    public static void renderFlowChartDataOrComputed(LcdpComponent lcdpComponent, Ctx ctx, String suffix, List<String> dataItems) throws LcdpException {
        ComponentDataUtil.renderFlowChartDataItemComputed(lcdpComponent, ctx, suffix, dataItems);
        ComponentDataUtil.ComponentValueStatusEnum dataItemValueStatus = ComponentDataUtil.getFlowChartValueStatus(lcdpComponent, ctx, dataItems);
        switch (dataItemValueStatus) {
            default: 
        }
    }

    public static void renderFlowChartDataOrMethod(LcdpComponent lcdpComponent, Ctx ctx, String suffix, List<String> dataItems) throws LcdpException {
        ComponentDataUtil.renderFlowChartDataItemMethod(lcdpComponent, ctx, suffix, dataItems);
    }

    public static void renderFlowChartDataItem(LcdpComponent lcdpComponent, Ctx ctx, String suffix, List<String> dataItems) throws LcdpException {
        if (ToolUtil.isEmpty((Object)lcdpComponent.getListParentKeyChain())) {
            RenderVModelUtil.renderFlowChartDataOrComputed(lcdpComponent, ctx, suffix, dataItems);
        } else {
            RenderVModelUtil.renderFlowChartDataOrMethod(lcdpComponent, ctx, suffix, dataItems);
        }
    }

    private static void setNormalData(Ctx ctx, LcdpComponent lcdpComponent, String suffix, String defaultValue, List<String> dataItems) throws LcdpException {
        GetValueBO componentDataItemGetValue;
        if (null == defaultValue) {
            defaultValue = "''";
        }
        JSONObject defaultValueAnalysis = ToolUtil.isNotEmpty((Object)(componentDataItemGetValue = ComponentDataUtil.getComponentDataItemGetValue(lcdpComponent, dataItems))) && ToolUtil.isNotEmpty((Object)componentDataItemGetValue.getDefaults()) ? componentDataItemGetValue.getDefaults() : (JSONObject)lcdpComponent.getProps().get("defaults");
        boolean isDefaultValue = false;
        if (null != defaultValueAnalysis) {
            isDefaultValue = defaultValueAnalysis.getBooleanValue("isDefaultValue");
        }
        if (isDefaultValue) {
            DefaultValueUtil.renderDefaultValueInput(lcdpComponent, ctx, suffix, defaultValueAnalysis);
        } else {
            ctx.addDataCommon(lcdpComponent.getInstanceKey() + suffix + ":" + defaultValue, MultilineExegesisUtil.dealDataExegesis(lcdpComponent, dataItems.get(0) + "\u53d8\u91cf"));
        }
    }
}

