/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.base.common.event;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.base.common.utils.AsyncActionUtil;
import com.jxdinfo.hussar.formdesign.base.common.utils.MultilineExegesisUtil;
import com.jxdinfo.hussar.formdesign.codegenerator.core.data.model.ComponentReference;
import com.jxdinfo.hussar.formdesign.codegenerator.core.util.DataConfigUtil;
import com.jxdinfo.hussar.formdesign.common.ctx.Ctx;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.Action;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ComponentData;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.LcdpComponent;
import com.jxdinfo.hussar.formdesign.common.render.RenderCore;
import com.jxdinfo.hussar.formdesign.common.render.RenderResult;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.visitor.ActionVisitor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="Base.GetSignContractLinkAction")
public class GetSignContractLinkAction
implements ActionVisitor {
    private final FileMappingService fileMappingService;

    @Autowired
    public GetSignContractLinkAction(FileMappingService fileMappingService) {
        this.fileMappingService = fileMappingService;
    }

    public void visitor(Action action, Ctx ctx) throws Exception {
        HashMap<String, Object> moduleMap = new HashMap<String, Object>();
        RenderCore renderCore = new RenderCore();
        renderCore.registerTemplatePath("template/common/event/GetSignContractLinkAction.ftl");
        LcdpComponent myLcdpComponent = action.getCurrentLcdpComponent();
        Map allParams = action.getParamValues();
        String trigger = action.getTrigger();
        String triggerName = myLcdpComponent.getInstanceKey() + ToolUtil.firstLetterToUpper((String)trigger);
        String pageType = ctx.getPageInfo().getType();
        if ("MobilePage".equals(pageType)) {
            ctx.addImports("import * as HussarRouterMobile from '@/utils/HussarRouterMobile';");
            ctx.addImports("contractSignPageLink", "@/api/demo/eSignature");
            moduleMap.put("HussarRouter", "HussarRouterMobile");
        } else if ("UniPage".equals(pageType)) {
            ctx.addImports("import HussarRouterMobile from '@/utils/HussarRouterMobile'");
            ctx.addImports("contractSignPageLink", "@/api/lowcode/eSignature");
            moduleMap.put("HussarRouter", "HussarRouterMobile");
        } else {
            ctx.addImports("contractSignPageLink", "@/pages/index/api/lowcode/eSignature");
            moduleMap.put("HussarRouter", "HussarRouter");
        }
        JSONObject paramsID = (JSONObject)allParams.get("contractID");
        if (ToolUtil.isEmpty((Object)paramsID)) {
            return;
        }
        ComponentReference contractIDFrom = (ComponentReference)JSON.parseObject((String)paramsID.getString("from"), ComponentReference.class);
        ComponentData contractIDFromComponentData = DataConfigUtil.getDataConfigValue((Ctx)ctx, (ComponentReference)contractIDFrom);
        if (!GetSignContractLinkAction.isComponentDataEmpty(contractIDFromComponentData).booleanValue()) {
            return;
        }
        moduleMap.put("contractIDFromDataItem", contractIDFromComponentData.getRenderValue());
        JSONObject paramsPhone = (JSONObject)allParams.get("phone");
        if (ToolUtil.isEmpty((Object)paramsPhone)) {
            return;
        }
        ComponentReference phoneFrom = (ComponentReference)JSON.parseObject((String)paramsPhone.getString("from"), ComponentReference.class);
        ComponentData phoneFromComponentData = DataConfigUtil.getDataConfigValue((Ctx)ctx, (ComponentReference)phoneFrom);
        if (!GetSignContractLinkAction.isComponentDataEmpty(phoneFromComponentData).booleanValue()) {
            return;
        }
        moduleMap.put("phoneFromDataItem", phoneFromComponentData.getRenderValue());
        List bodies = action.getBodies();
        moduleMap.put("bodies", bodies);
        moduleMap.put("asyncBodyWithoutData", AsyncActionUtil.getAsyncBodyCodeWithoutData("\u8868\u5355", bodies));
        moduleMap.put("asyncBodyCode", AsyncActionUtil.getAsyncBodyCode(bodies));
        moduleMap.put("exegesisResult", MultilineExegesisUtil.handleActionExegesisText(action));
        renderCore.registerParam(moduleMap);
        RenderResult renderResult = renderCore.render();
        if (renderResult.isStatus()) {
            ctx.addMethod(triggerName, renderResult.getRenderString());
        }
    }

    private static Boolean isComponentDataEmpty(ComponentData componentData) {
        Boolean isOk = true;
        if (ToolUtil.isNotEmpty((Object)componentData)) {
            if ("".equals(componentData.getRenderValue())) {
                isOk = false;
            }
            if (ToolUtil.isEmpty((Object)componentData.getDataType()) || "".equals(componentData.getDataType().getValue())) {
                isOk = false;
            }
        } else {
            isOk = false;
        }
        return isOk;
    }
}

