/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.base.common.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.back.adapter.ModelProvideAdapter;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.back.model.DataModelFieldBase;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.datas.DataSAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.datas.DataSConditionAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.datas.DataSConditionListAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.datas.DataSModelAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.showconfig.ShowConfigAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.showconfig.ShowConfigItemInfo;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.showconfig.ShowConfigMappingAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.translate.Translate;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.translate.TranslateCondition;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.translate.TranslateField;
import com.jxdinfo.hussar.formdesign.base.common.constant.DataConfigConstant;
import com.jxdinfo.hussar.formdesign.base.common.utils.EventUtil;
import com.jxdinfo.hussar.formdesign.base.common.utils.QueryAttrUtil;
import com.jxdinfo.hussar.formdesign.common.ctx.Ctx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.LcdpComponent;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;

public class ReplaceDataUtil {
    private static FileMappingService fileMappingService = (FileMappingService)SpringUtil.getBean(FileMappingService.class);

    private ReplaceDataUtil() {
    }

    public static List<ShowConfigAnalysis> getReplaceDataInfo(LcdpComponent lcdpComponent, String editorFiled) {
        List tempShowConfigAnalyses;
        List showConfigAnalyses = null;
        JSONArray showConfigs = (JSONArray)lcdpComponent.getDatas().get(editorFiled);
        if (ToolUtil.isNotEmpty((Object)showConfigs) && ToolUtil.isNotEmpty((Object)(tempShowConfigAnalyses = JSON.parseArray((String)JSON.toJSONString((Object)showConfigs), ShowConfigAnalysis.class)))) {
            showConfigAnalyses = tempShowConfigAnalyses;
        }
        return showConfigAnalyses;
    }

    public static List<ShowConfigItemInfo> handlerShowConfigs(Ctx ctx, List<ShowConfigAnalysis> showConfigAnalyses) throws LcdpException {
        ArrayList<ShowConfigItemInfo> showConfigItemInfos = new ArrayList<ShowConfigItemInfo>();
        for (ShowConfigAnalysis showConfigAnalysis : showConfigAnalyses) {
            ShowConfigItemInfo showConfigItemInfo = new ShowConfigItemInfo();
            String modelId = showConfigAnalysis.getDataModelId();
            ReplaceDataUtil.setShowConfigImportInfo(ctx, showConfigItemInfo, modelId);
            showConfigItemInfo.setTableFieldWhere(showConfigAnalysis.getField());
            String showConfigType = showConfigAnalysis.getType();
            if ("CommonModel".equals(showConfigType)) {
                if (DataConfigConstant.CommonModelCategory.DICT.getVal().equals(showConfigAnalysis.getDataModelId())) {
                    showConfigItemInfo.setCommonModelType(showConfigAnalysis.getDataModelId());
                    showConfigItemInfo.setCommonModelField(showConfigAnalysis.getDictShowField());
                    showConfigItemInfo.setDictType(showConfigAnalysis.getDictType());
                    showConfigItemInfo.setImportMethod(DataConfigConstant.CommonModelCategory.DICT.getImportMethod());
                    showConfigItemInfo.setIsConfigComplete(showConfigAnalysis.isConfigComplete());
                }
            } else {
                ReplaceDataUtil.packageDataModelShowConfigInfo(ctx, showConfigAnalysis, showConfigItemInfo);
            }
            showConfigItemInfos.add(showConfigItemInfo);
        }
        return showConfigItemInfos;
    }

    public static List<ShowConfigItemInfo> handlerShowConfigsOnly(Ctx ctx, List<ShowConfigAnalysis> showConfigAnalyses) throws LcdpException {
        ArrayList<ShowConfigItemInfo> showConfigItemInfos = new ArrayList<ShowConfigItemInfo>();
        for (ShowConfigAnalysis showConfigAnalysis : showConfigAnalyses) {
            ShowConfigItemInfo showConfigItemInfo = new ShowConfigItemInfo();
            String modelId = showConfigAnalysis.getDataModelId();
            ReplaceDataUtil.setShowConfigImportInfo(ctx, showConfigItemInfo, modelId);
            showConfigItemInfo.setTableFieldWhere(showConfigAnalysis.getField());
            String showConfigType = showConfigAnalysis.getType();
            if ("CommonModel".equals(showConfigType)) {
                if (DataConfigConstant.CommonModelCategory.DICT.getVal().equals(showConfigAnalysis.getDataModelId())) {
                    showConfigItemInfo.setCommonModelType(showConfigAnalysis.getDataModelId());
                    showConfigItemInfo.setCommonModelField(showConfigAnalysis.getDictShowField());
                    showConfigItemInfo.setDictType(showConfigAnalysis.getDictType());
                    showConfigItemInfo.setImportMethod(DataConfigConstant.CommonModelCategory.LEVELDICT.getImportMethod());
                    showConfigItemInfo.setIsConfigComplete(showConfigAnalysis.isConfigComplete());
                }
            } else {
                ReplaceDataUtil.packageDataModelShowConfigInfo(ctx, showConfigAnalysis, showConfigItemInfo);
            }
            showConfigItemInfos.add(showConfigItemInfo);
        }
        return showConfigItemInfos;
    }

    private static void packageDataModelShowConfigInfo(Ctx ctx, ShowConfigAnalysis showConfigAnalysis, ShowConfigItemInfo showConfigItemInfo) throws LcdpException {
        List<ShowConfigMappingAnalysis> showConfigMappingAnalyses;
        DataSConditionAnalysis dataSConditionAnalysis = showConfigAnalysis.getCondition();
        if (ToolUtil.isNotEmpty((Object)dataSConditionAnalysis)) {
            List<DataSConditionListAnalysis> conditionList = dataSConditionAnalysis.getQueryConditionModelList();
            StringBuilder queryObjectAttr = QueryAttrUtil.getQueryAttr(conditionList, ctx);
            showConfigItemInfo.setQueryObjectAttr(queryObjectAttr.toString());
        }
        String showRelateField = showConfigAnalysis.getRelateField();
        showConfigItemInfo.setRelateTableFieldWhere(showRelateField);
        showConfigItemInfo.setIsConfigComplete(showConfigAnalysis.isConfigComplete());
        if (ToolUtil.isNotEmpty((Object)showConfigAnalysis.getCondition())) {
            String queryCondition = showConfigAnalysis.getCondition().getSelectCondition();
            StringBuilder stringBuilder = new StringBuilder(64);
            stringBuilder.append(Optional.ofNullable(showConfigAnalysis.getField()).orElse(""));
            if (ToolUtil.isNotEmpty((Object)showRelateField)) {
                stringBuilder.append(showRelateField);
            }
            if (ToolUtil.isNotEmpty((Object)queryCondition)) {
                stringBuilder.append(queryCondition);
            }
            if (stringBuilder.length() <= 0) {
                stringBuilder = new StringBuilder("ShowConfig");
            }
            showConfigItemInfo.setImportMethod(stringBuilder.toString());
        }
        if (ToolUtil.isNotEmpty(showConfigMappingAnalyses = showConfigAnalysis.getRelations())) {
            showConfigItemInfo.setMappingRelates(showConfigMappingAnalyses);
        }
    }

    private static void setShowConfigImportInfo(Ctx ctx, ShowConfigItemInfo showConfigItemInfo, String modelId) throws LcdpException {
        if (ToolUtil.isNotEmpty((Object)modelId) && ToolUtil.isNotEmpty((Object)DataModelUtil.getDataModelBase((String)modelId)) && ToolUtil.isNotEmpty((Object)DataModelUtil.getDataModelBase((String)modelId).getId())) {
            String apiFileName = fileMappingService.getFileName(modelId);
            String apiFilePath = fileMappingService.getImportPath(modelId);
            if (ToolUtil.isNotEmpty((Object)apiFilePath) && ToolUtil.isNotEmpty((Object)apiFileName)) {
                EventUtil.addCtxImport(ctx, apiFileName, apiFilePath);
                showConfigItemInfo.setImportName(apiFileName);
            }
        }
    }

    public static List<Translate> getDataModelTranslate(LcdpComponent lcdpComponent) throws LcdpException {
        String dataModelId;
        JSONArray translateArray;
        DataSAnalysis dataSAnalysis = (DataSAnalysis)JSON.parseObject((String)JSON.toJSONString((Object)lcdpComponent.getDatas()), DataSAnalysis.class);
        DataSModelAnalysis dataSModelAnalysis = dataSAnalysis.getDatamodel();
        ArrayList<Translate> translates = new ArrayList<Translate>();
        if (ToolUtil.isNotEmpty((Object)dataSModelAnalysis) && ToolUtil.isNotEmpty((Object)(translateArray = (JSONArray)DataModelUtil.getDataModelJson((String)(dataModelId = dataSModelAnalysis.getDataModelId())).get((Object)"translate")))) {
            for (Object object : translateArray) {
                if (!ToolUtil.isNotEmpty(object)) continue;
                translates.add((Translate)JSON.parseObject((String)JSON.toJSONString(object), Translate.class));
            }
        }
        return translates;
    }

    public static List<ShowConfigItemInfo> handlerTranslate(Ctx ctx, List<Translate> translates, LcdpComponent lcdpComponent) throws LcdpException {
        ArrayList<ShowConfigItemInfo> showConfigItemInfos = new ArrayList<ShowConfigItemInfo>();
        HashMap<String, String> mapping = new HashMap<String, String>();
        DataSAnalysis dataSAnalysis = (DataSAnalysis)JSON.parseObject((String)JSON.toJSONString((Object)lcdpComponent.getDatas()), DataSAnalysis.class);
        DataSModelAnalysis dataSModelAnalysis = dataSAnalysis.getDatamodel();
        String dataModelId = dataSModelAnalysis.getDataModelId();
        List fields = ModelProvideAdapter.adaptor((String)dataModelId).getFields(dataModelId);
        for (DataModelFieldBase field : fields) {
            mapping.put(field.getId(), field.getName());
        }
        JSONArray optCols = (JSONArray)lcdpComponent.getProps().get("opt_cols");
        for (Translate translate : translates) {
            Iterator col2;
            String modelId = translate.getSourceId();
            String translateType = translate.getTranslateType();
            if ("dictTranslate".equals(translateType)) {
                ShowConfigItemInfo showConfigItemInfo = new ShowConfigItemInfo();
                ReplaceDataUtil.setShowConfigImportInfo(ctx, showConfigItemInfo, "dict");
                showConfigItemInfo.setCommonModelType("dict");
                showConfigItemInfo.setTableFieldWhere((String)mapping.get(translate.getSourceFieldId()));
                showConfigItemInfo.setRelateTableFieldWhere(translate.getTranslateFields().get(0).getName());
                if ("com.jxdinfo.elementui.JXDHEditTable".equals(lcdpComponent.getName())) {
                    showConfigItemInfo.setShowConfigTransFlag(false);
                    for (Iterator col2 : optCols) {
                        JSONObject colObj = (JSONObject)col2;
                        if (!colObj.get((Object)"field").equals(translate.getTranslateFields().get(0).getName())) continue;
                        showConfigItemInfo.setShowConfigTransFlag(true);
                        break;
                    }
                }
                showConfigItemInfo.setDictType(translate.getSourceId());
                showConfigItemInfo.setImportMethod(DataConfigConstant.CommonModelCategory.DICT.getImportMethod());
                showConfigItemInfos.add(showConfigItemInfo);
                continue;
            }
            if (!"modelTranslate".equals(translateType)) continue;
            HashMap<String, String> sourceMapping = new HashMap<String, String>();
            if (!ToolUtil.isNotEmpty((Object)ModelProvideAdapter.adaptor((String)modelId))) continue;
            List sourceFields = ModelProvideAdapter.adaptor((String)modelId).getFields(modelId);
            col2 = sourceFields.iterator();
            while (col2.hasNext()) {
                DataModelFieldBase field = (DataModelFieldBase)col2.next();
                sourceMapping.put(field.getId(), field.getName());
            }
            TranslateField translateField = translate.getTranslateFields().get(0);
            ShowConfigItemInfo showConfigItemInfo = new ShowConfigItemInfo();
            ReplaceDataUtil.setShowConfigImportInfo(ctx, showConfigItemInfo, modelId);
            showConfigItemInfo.setRelateTableFieldWhere(translateField.getName());
            if ("com.jxdinfo.elementui.JXDHEditTable".equals(lcdpComponent.getName())) {
                showConfigItemInfo.setShowConfigTransFlag(false);
                for (Object col3 : optCols) {
                    JSONObject colObj = (JSONObject)col3;
                    if (!colObj.get((Object)"field").equals(translateField.getName())) continue;
                    showConfigItemInfo.setShowConfigTransFlag(true);
                    break;
                }
            }
            showConfigItemInfo.setTableFieldWhere((String)mapping.get(translate.getSourceFieldId()));
            String field = (String)sourceMapping.get(translateField.getTranslateSource());
            StringBuilder stringBuilder = new StringBuilder("showConfig");
            showConfigItemInfo.setImportMethod(stringBuilder.append(field).toString());
            ArrayList<ShowConfigMappingAnalysis> showConfigMappingAnalyses = new ArrayList<ShowConfigMappingAnalysis>();
            ShowConfigMappingAnalysis showConfigMappingAnalysis = new ShowConfigMappingAnalysis();
            for (TranslateCondition translateCondition : translate.getDataModelCondition()) {
                if (!translateCondition.getFromModelField().equals(translate.getSourceFieldId())) continue;
                showConfigMappingAnalysis.setField((String)sourceMapping.get(translateCondition.getGoalsRowId()));
            }
            showConfigMappingAnalysis.setRelateField(field);
            showConfigItemInfo.setMappingRelates(showConfigMappingAnalyses);
            showConfigMappingAnalyses.add(showConfigMappingAnalysis);
            showConfigItemInfos.add(showConfigItemInfo);
        }
        return showConfigItemInfos;
    }
}

