/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.base.common.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.dataitem.reference.GetValueBO;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.dataitem.reference.QuoteBO;
import com.jxdinfo.hussar.formdesign.base.common.constant.CodePrefix;
import com.jxdinfo.hussar.formdesign.base.common.utils.MappingUtils;
import com.jxdinfo.hussar.formdesign.base.common.utils.MultilineExegesisUtil;
import com.jxdinfo.hussar.formdesign.codegenerator.core.data.constant.DataFromEnum;
import com.jxdinfo.hussar.formdesign.codegenerator.core.data.mapping.DataItemMappingBO;
import com.jxdinfo.hussar.formdesign.codegenerator.core.data.model.ComponentReference;
import com.jxdinfo.hussar.formdesign.codegenerator.core.util.DataConfigUtil;
import com.jxdinfo.hussar.formdesign.common.ctx.Ctx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ComponentData;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.LcdpComponent;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.visitor.BaseProvideVisitor;
import com.jxdinfo.hussar.formdesign.common.visitor.ValueVisitor;
import com.jxdinfo.hussar.formdesign.extend.model.formula.ExtendFormulaParam;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ComponentDataUtil {
    public static final String PACKAGE_TREE_FIELD_FUNCTION = "packageTreeField";
    public static final String GET_TREEFIELDVALUE_FUNCTION = "getTreeFieldValue";

    public static String getComponentDataRender(LcdpComponent lcdpComponent, Ctx ctx, String suffix, List<String> dataItems) throws LcdpException {
        if (ComponentValueStatusEnum.QUOTE.equals((Object)ComponentDataUtil.getComponentValueStatus(lcdpComponent, ctx, dataItems))) {
            QuoteBO quoteBO = ComponentDataUtil.getComponentDataItemQuote(lcdpComponent, dataItems);
            HashMap<String, List<List<String>>> quoteMap = new HashMap<String, List<List<String>>>();
            ArrayList<List<String>> dataItemList = new ArrayList<List<String>>();
            dataItemList.add(dataItems);
            quoteMap.put(lcdpComponent.getInstanceKey(), dataItemList);
            ComponentReference reference = quoteBO.getComponentQuote();
            if (reference.isConfigComplete(ctx)) {
                if (DataFromEnum.VARIABLE.getValue().equals(reference.getType())) {
                    if (ComponentDataUtil.judgeCircleQuote(quoteBO, ctx, quoteMap)) {
                        return "self." + reference.getConfigData();
                    }
                    return reference.getConfigData();
                }
                if (ComponentDataUtil.judgeCircleQuote(quoteBO, ctx, quoteMap)) {
                    LcdpComponent quoteComponent = (LcdpComponent)ctx.getComponentMap().get(reference.getInstanceKey());
                    ValueVisitor quoteVisitor = (ValueVisitor)quoteComponent.getProvideVisitor("value");
                    quoteComponent.accept((BaseProvideVisitor)quoteVisitor, ctx, null);
                    ComponentData quoteData = quoteVisitor.getDataItemValue(reference.getInstanceData());
                    return quoteData.getRenderValue();
                }
            }
        } else {
            if (ToolUtil.isNotEmpty((Object)lcdpComponent.getListParentKeyChain()) && ComponentValueStatusEnum.GET_VALUE.equals((Object)ComponentDataUtil.getComponentValueStatus(lcdpComponent, ctx, dataItems))) {
                String paramData = ComponentDataUtil.listToString(ctx.getCycleInputParameter());
                return CodePrefix._SELF.getType() + "cal" + ToolUtil.firstLetterToUpper((String)(lcdpComponent.getInstanceKey() + suffix)) + "(" + paramData + ")";
            }
            if (ToolUtil.isNotEmpty((Object)lcdpComponent.getListParentKeyChain()) && ComponentValueStatusEnum.NONE.equals((Object)ComponentDataUtil.getComponentValueStatus(lcdpComponent, ctx, dataItems))) {
                return "";
            }
        }
        return CodePrefix._SELF.getType() + lcdpComponent.getInstanceKey() + suffix;
    }

    public static ComponentData.ComponentDataSourceRWEnum getComponentRW(LcdpComponent lcdpComponent, Ctx ctx, List<String> dataItems) throws LcdpException {
        if (ToolUtil.isEmpty(dataItems)) {
            dataItems = new ArrayList<String>();
            dataItems.add("value");
        }
        boolean componentHaveVariable = HussarUtils.isEmpty((Object)lcdpComponent.getListParentKeyChain());
        ComponentValueStatusEnum dataItemValueStatus = ComponentDataUtil.getComponentValueStatus(lcdpComponent, ctx, dataItems);
        switch (dataItemValueStatus) {
            case SPECICAL_QUOTE: 
            case GET_VALUE: {
                return ComponentData.ComponentDataSourceRWEnum.READONLY;
            }
            case QUOTE: {
                QuoteBO quoteBO = ComponentDataUtil.getComponentDataItemQuote(lcdpComponent, dataItems);
                HashMap<String, List<List<String>>> quoteMap = new HashMap<String, List<List<String>>>();
                ArrayList<List<String>> dataItemList = new ArrayList<List<String>>();
                dataItemList.add(dataItems);
                quoteMap.put(lcdpComponent.getInstanceKey(), dataItemList);
                ComponentReference reference = quoteBO.getComponentQuote();
                if (!reference.isConfigComplete(ctx)) break;
                if (DataFromEnum.VARIABLE.getValue().equals(reference.getType())) {
                    return ComponentData.ComponentDataSourceRWEnum.RW;
                }
                if (!ComponentDataUtil.judgeCircleQuote(quoteBO, ctx, quoteMap)) break;
                LcdpComponent quoteComponent = (LcdpComponent)ctx.getComponentMap().get(reference.getInstanceKey());
                List quoteDataItems = reference.getInstanceData();
                return ComponentDataUtil.getComponentRW(quoteComponent, ctx, quoteDataItems);
            }
            case NONE: {
                if (componentHaveVariable) {
                    return ComponentData.ComponentDataSourceRWEnum.RW;
                }
                return ComponentData.ComponentDataSourceRWEnum.NONE;
            }
        }
        return ComponentData.ComponentDataSourceRWEnum.RW;
    }

    public static LcdpComponent getComponentByItem(LcdpComponent lcdpComponent, Ctx ctx, List<String> dataItems) throws LcdpException {
        if (ComponentValueStatusEnum.QUOTE.equals((Object)ComponentDataUtil.getComponentValueStatus(lcdpComponent, ctx, dataItems))) {
            QuoteBO quoteBO = ComponentDataUtil.getComponentDataItemQuote(lcdpComponent, dataItems);
            HashMap<String, List<List<String>>> quoteMap = new HashMap<String, List<List<String>>>();
            ArrayList<List<String>> dataItemList = new ArrayList<List<String>>();
            dataItemList.add(dataItems);
            quoteMap.put(lcdpComponent.getInstanceKey(), dataItemList);
            ComponentReference reference = quoteBO.getComponentQuote();
            if (reference.isConfigComplete(ctx)) {
                if (DataFromEnum.VARIABLE.getValue().equals(reference.getType())) {
                    return lcdpComponent;
                }
                if (ComponentDataUtil.judgeCircleQuote(quoteBO, ctx, quoteMap)) {
                    LcdpComponent quoteComponent = (LcdpComponent)ctx.getComponentMap().get(reference.getInstanceKey());
                    List quoteDataItems = reference.getInstanceData();
                    return ComponentDataUtil.getComponentByItem(quoteComponent, ctx, quoteDataItems);
                }
            }
        }
        return lcdpComponent;
    }

    public static ComponentValueStatusEnum getComponentSourceOfData(LcdpComponent lcdpComponent, Ctx ctx, List<String> dataItems) throws LcdpException {
        ComponentValueStatusEnum componentValueStatus = ComponentDataUtil.getComponentValueStatus(lcdpComponent, ctx, dataItems);
        if (ComponentValueStatusEnum.QUOTE.equals((Object)componentValueStatus)) {
            QuoteBO quoteBO = ComponentDataUtil.getComponentDataItemQuote(lcdpComponent, dataItems);
            HashMap<String, List<List<String>>> quoteMap = new HashMap<String, List<List<String>>>();
            ArrayList<List<String>> dataItemList = new ArrayList<List<String>>();
            dataItemList.add(dataItems);
            quoteMap.put(lcdpComponent.getInstanceKey(), dataItemList);
            ComponentReference reference = quoteBO.getComponentQuote();
            if (reference.isConfigComplete(ctx)) {
                if (DataFromEnum.VARIABLE.getValue().equals(reference.getType())) {
                    return componentValueStatus;
                }
                if (ComponentDataUtil.judgeCircleQuote(quoteBO, ctx, quoteMap)) {
                    LcdpComponent quoteComponent = (LcdpComponent)ctx.getComponentMap().get(reference.getInstanceKey());
                    List quoteDataItems = reference.getInstanceData();
                    return ComponentDataUtil.getComponentSourceOfData(quoteComponent, ctx, quoteDataItems);
                }
            }
        }
        return componentValueStatus;
    }

    public static void renderFlowChartDataItemComputed(LcdpComponent lcdpComponent, Ctx ctx, String dataSuffix, List<String> dataItems) throws LcdpException {
        ComponentValueStatusEnum dataItemValueStatus = ComponentDataUtil.getFlowChartValueStatus(lcdpComponent, ctx, dataItems);
        HashMap<String, Object> params = new HashMap<String, Object>();
        HashMap<String, String> items = new HashMap<String, String>();
        ArrayList<String> args = new ArrayList<String>();
        args.add("n");
        args.add("o");
        items.put("itemType", dataItems.get(0));
        items.put("instanceKey", lcdpComponent.getInstanceKey());
        if (ComponentValueStatusEnum.GET_VALUE.equals((Object)dataItemValueStatus)) {
            ComponentReference to = ComponentDataUtil.dealCurrDataItem(lcdpComponent, ctx, dataItems, params);
            ComponentData toData = DataConfigUtil.getDataConfigValue((Ctx)ctx, (ComponentReference)to);
            String toDataType = HussarUtils.isNotEmpty((Object)toData) ? toData.getDataType().getValue() : ComponentData.DataTypeEnum.OBJECT.getValue();
            String fromDataType = ComponentDataUtil.dealFlowChartGetValueRenderParam(lcdpComponent, ctx, dataItems, params, to);
            params.put("instanceKey", lcdpComponent.getInstanceKey());
            params.put("getValueData", RenderUtil.renderTemplate((String)"/template/common/dataitem/data_convert_mapping.ftl", params));
            if (HussarUtils.isNotEmpty((Object)toDataType) && HussarUtils.isNotBlank((CharSequence)toDataType) && HussarUtils.isNotEmpty((Object)fromDataType) && HussarUtils.isNotBlank((CharSequence)fromDataType)) {
                ctx.addImports("dateFormatPublic", "@/pages/index/utils/lowcode/dateFormatUtil");
            }
            ctx.addComputedWithGetSet(lcdpComponent.getInstanceKey() + dataSuffix, RenderUtil.renderTemplate((String)"/template/common/dataitem/flowChart_defaultComputed.ftl", params), MultilineExegesisUtil.dealComputedExegesis(lcdpComponent));
            ctx.addWatch(lcdpComponent.getInstanceKey() + dataSuffix, args, RenderUtil.renderTemplate((String)"/template/common/dataitem/flowChart_calcWatch.ftl", items), MultilineExegesisUtil.dealWatchExegesis(lcdpComponent));
        }
    }

    public static void renderFlowChartDataItemMethod(LcdpComponent lcdpComponent, Ctx ctx, String dataSuffix, List<String> dataItems) throws LcdpException {
        ComponentValueStatusEnum dataItemValueStatus = ComponentDataUtil.getFlowChartValueStatus(lcdpComponent, ctx, dataItems);
        HashMap<String, Object> params = new HashMap<String, Object>();
        HashMap<String, String> items = new HashMap<String, String>();
        ArrayList<String> args = new ArrayList<String>();
        args.add("n");
        args.add("o");
        items.put("itemType", dataItems.get(0));
        items.put("instanceKey", lcdpComponent.getInstanceKey());
        if (ComponentValueStatusEnum.SPECICAL_QUOTE.equals((Object)dataItemValueStatus) || ComponentValueStatusEnum.GET_VALUE.equals((Object)dataItemValueStatus)) {
            ComponentReference to = ComponentDataUtil.dealCurrDataItem(lcdpComponent, ctx, dataItems, params);
            ComponentData toData = DataConfigUtil.getDataConfigValue((Ctx)ctx, (ComponentReference)to);
            String toDataType = HussarUtils.isNotEmpty((Object)toData) ? toData.getDataType().getValue() : ComponentData.DataTypeEnum.OBJECT.getValue();
            String fromDataType = ComponentValueStatusEnum.SPECICAL_QUOTE.equals((Object)dataItemValueStatus) ? ComponentDataUtil.dealSpecialQuoteRenderParam(lcdpComponent, ctx, dataItems, params, to) : ComponentDataUtil.dealFlowChartGetValueRenderParam(lcdpComponent, ctx, dataItems, params, to);
            params.put("instanceKey", lcdpComponent.getInstanceKey());
            params.put("getValueData", RenderUtil.renderTemplate((String)"/template/common/dataitem/data_convert_mapping.ftl", params));
            if (HussarUtils.isNotEmpty((Object)toDataType) && HussarUtils.isNotBlank((CharSequence)toDataType) && HussarUtils.isNotEmpty((Object)fromDataType) && HussarUtils.isNotBlank((CharSequence)fromDataType)) {
                ctx.addImports("dateFormatPublic", "@/pages/index/utils/lowcode/dateFormatUtil");
            }
            ctx.addMethod(lcdpComponent.getInstanceKey() + dataSuffix, RenderUtil.renderTemplate((String)"/template/common/dataitem/value_method.ftl", params));
            ComponentDataUtil.renderTreeMethod(lcdpComponent, ctx, params);
            ctx.addWatch(lcdpComponent.getInstanceKey() + dataSuffix, args, RenderUtil.renderTemplate((String)"/template/common/dataitem/flowChart_calcWatch.ftl", items));
        }
    }

    public static void renderDataItemComputed(LcdpComponent lcdpComponent, Ctx ctx, String dataSuffix, List<String> dataItems) throws LcdpException {
        ComponentValueStatusEnum dataItemValueStatus = ComponentDataUtil.getComponentValueStatus(lcdpComponent, ctx, dataItems);
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (ComponentValueStatusEnum.SPECICAL_QUOTE.equals((Object)dataItemValueStatus) || ComponentValueStatusEnum.GET_VALUE.equals((Object)dataItemValueStatus)) {
            ComponentReference to = ComponentDataUtil.dealCurrDataItem(lcdpComponent, ctx, dataItems, params);
            ComponentData toData = DataConfigUtil.getDataConfigValue((Ctx)ctx, (ComponentReference)to);
            String toDataType = HussarUtils.isNotEmpty((Object)toData) ? toData.getDataType().getValue() : ComponentData.DataTypeEnum.OBJECT.getValue();
            if (ComponentValueStatusEnum.SPECICAL_QUOTE.equals((Object)dataItemValueStatus)) {
                String fromDataType = ComponentDataUtil.dealSpecialQuoteRenderParam(lcdpComponent, ctx, dataItems, params, to);
            } else {
                String fromDataType = ComponentDataUtil.dealGetValueRenderParam(lcdpComponent, ctx, dataItems, params, to);
            }
            boolean isSelect = false;
            params.put("instanceKey", lcdpComponent.getInstanceKey());
            if (lcdpComponent.getInstanceKey().contains("select") && params.get("fromDataItem").toString().contains("select") && "string".equals(toDataType)) {
                isSelect = true;
            }
            params.put("isSelect", isSelect);
            boolean isAmountUppercase = false;
            if (lcdpComponent.getInstanceKey().contains("amountUppercase") || lcdpComponent.getName().equals("com.jxdinfo.elementui.JXDElAmountUppercase")) {
                isAmountUppercase = true;
                ctx.addImports("convertCurrency", "@hussar/toolbox");
            }
            params.put("isAmountUppercase", isAmountUppercase);
            params.put("getValueData", RenderUtil.renderTemplate((String)"/template/common/dataitem/data_convert_mapping.ftl", params));
            params.put("isCacheable", ComponentDataUtil.isCacheable(ctx, lcdpComponent, dataItems));
            ctx.addComputedWithGetSet(lcdpComponent.getInstanceKey() + dataSuffix, RenderUtil.renderTemplate((String)"/template/common/dataitem/value_computed.ftl", params), MultilineExegesisUtil.dealComputedExegesis(lcdpComponent));
            ComponentDataUtil.renderTreeMethod(lcdpComponent, ctx, params);
        }
    }

    private static boolean isCacheable(Ctx ctx, LcdpComponent lcdpComponent, List<String> dataItems) {
        ComponentReference reference;
        GetValueBO getValueBO = ComponentDataUtil.getComponentDataItemGetValue(lcdpComponent, dataItems);
        if (ToolUtil.isNotEmpty((Object)getValueBO) && ToolUtil.isNotEmpty((Object)(reference = getValueBO.getComponentGetData()))) {
            LcdpComponent fromComponent = (LcdpComponent)ctx.getComponentMap().get(reference.getInstanceKey());
            if (reference.getType().equals("formula")) {
                for (ExtendFormulaParam param : reference.getFormulaEditor().getFormulaParam()) {
                    if (!ToolUtil.isNotEmpty((Object)param.getInstanceData()) || !((String)param.getInstanceData().get(0)).equals("fullData")) continue;
                    return false;
                }
            } else if (ToolUtil.isNotEmpty((Object)fromComponent)) {
                return !fromComponent.getName().equals("com.jxdinfo.elementui.JXDHEditTable") || !((String)reference.getInstanceData().get(0)).equals("fullData");
            }
        }
        return true;
    }

    public static void renderDataItemMethod(LcdpComponent lcdpComponent, Ctx ctx, String dataSuffix, List<String> dataItems) throws LcdpException {
        ComponentValueStatusEnum dataItemValueStatus = ComponentDataUtil.getComponentValueStatus(lcdpComponent, ctx, dataItems);
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (ComponentValueStatusEnum.SPECICAL_QUOTE.equals((Object)dataItemValueStatus) || ComponentValueStatusEnum.GET_VALUE.equals((Object)dataItemValueStatus)) {
            ComponentReference to = ComponentDataUtil.dealCurrDataItem(lcdpComponent, ctx, dataItems, params);
            ComponentData toData = DataConfigUtil.getDataConfigValue((Ctx)ctx, (ComponentReference)to);
            if (ComponentValueStatusEnum.SPECICAL_QUOTE.equals((Object)dataItemValueStatus)) {
                String fromDataType = ComponentDataUtil.dealSpecialQuoteRenderParam(lcdpComponent, ctx, dataItems, params, to);
            } else {
                String fromDataType = ComponentDataUtil.dealGetValueRenderParam(lcdpComponent, ctx, dataItems, params, to);
            }
            params.put("instanceKey", lcdpComponent.getInstanceKey());
            params.put("getValueData", RenderUtil.renderTemplate((String)"/template/common/dataitem/data_convert_mapping.ftl", params));
            ctx.addMethod("cal" + ToolUtil.firstLetterToUpper((String)lcdpComponent.getInstanceKey()) + dataSuffix, RenderUtil.renderTemplate((String)"/template/common/dataitem/value_method.ftl", params), true);
            ComponentDataUtil.renderTreeMethod(lcdpComponent, ctx, params);
        }
    }

    public static void renderTreeMethod(LcdpComponent lcdpComponent, Ctx ctx, Map<String, Object> params) throws LcdpException {
        if (ToolUtil.isNotEmpty((Object)params.get("fromDataType")) && ToolUtil.isNotEmpty((Object)params.get("toDataType"))) {
            if (params.get("toDataType").equals(ComponentData.DataTypeEnum.TREE_OBJECT.getValue()) && params.get("fromDataType").equals(ComponentData.DataTypeEnum.TREE_OBJECT.getValue())) {
                List<String> args = Arrays.asList("fromData", "computedRes");
                ctx.addMethod(lcdpComponent.getInstanceKey() + "fromTreeGetValue", args, RenderUtil.renderTemplate((String)"/template/common/dataitem/get_value_from_tree.ftl", params), true);
            }
            if (params.get("toDataType").equals(ComponentData.DataTypeEnum.TREE_OBJECT.getValue()) && params.get("fromDataType").equals(ComponentData.DataTypeEnum.ARRAY_OBJECT.getValue())) {
                List<String> getValueArgs = Collections.singletonList("fromData");
                List<String> getValueChildrenArgs = Arrays.asList("datas", "rootDataArray");
                List mappingList = (List)params.get("mapping");
                String idField = "id";
                String pidField = "pid";
                JSONArray hiddenCols = (JSONArray)lcdpComponent.getProps().get("hidden_cols");
                if (ToolUtil.isNotEmpty((Object)hiddenCols)) {
                    for (Object col : hiddenCols) {
                        JSONObject colObj = (JSONObject)col;
                        if ("jxd-tree-table-fix-id".equals(colObj.getString("id"))) {
                            idField = colObj.getString("field");
                        }
                        if (!"jxd-tree-table-fix-pid".equals(colObj.getString("id"))) continue;
                        pidField = colObj.getString("field");
                    }
                }
                params.put("id", idField);
                if (ToolUtil.isNotEmpty(lcdpComponent.getProps().get("root"))) {
                    String root = String.valueOf(lcdpComponent.getProps().get("root"));
                    params.put("root", root);
                }
                if (ToolUtil.isNotEmpty((Object)mappingList)) {
                    AtomicBoolean havePid = new AtomicBoolean(false);
                    String pid = pidField;
                    mappingList.forEach(mapping -> {
                        DataItemMappingBO dataItemMappingBO = (DataItemMappingBO)mapping;
                        if (((String)dataItemMappingBO.getToDataItem()).equals(pid)) {
                            params.put("pid", dataItemMappingBO.getFromDataItem());
                            havePid.set(true);
                        }
                    });
                    if (!havePid.get()) {
                        params.put("pid", pidField);
                    }
                    ctx.addMethod(lcdpComponent.getInstanceKey() + "fromArrayGetValue", getValueArgs, RenderUtil.renderTemplate((String)"/template/common/dataitem/get_value_from_array.ftl", params), true);
                    ctx.addMethod(lcdpComponent.getInstanceKey() + "fromArrayGetValueChildren", getValueChildrenArgs, RenderUtil.renderTemplate((String)"/template/common/dataitem/get_value_from_array_children.ftl", params), false);
                }
            }
        }
    }

    private static String dealGetValueRenderParam(LcdpComponent lcdpComponent, Ctx ctx, List<String> dataItems, Map<String, Object> params, ComponentReference to) throws LcdpException {
        ComponentData getValueData;
        GetValueBO getValueBO = ComponentDataUtil.getComponentDataItemGetValue(lcdpComponent, dataItems);
        if (HussarUtils.isNotEmpty((Object)getValueBO) && HussarUtils.isNotEmpty((Object)(getValueData = DataConfigUtil.getDataConfigValue((Ctx)ctx, (ComponentReference)getValueBO.getComponentGetData()))) && ToolUtil.isNotEmpty((Object)getValueData.getRenderValue())) {
            params.put("getValueData", getValueData.getRenderValue());
            Map<String, Object> resultMap = MappingUtils.getMappingResult(ctx, getValueBO.getComponentGetData().getMapping(), getValueBO.getComponentGetData(), to);
            params.putAll(resultMap);
            params.put("fromDataItem", getValueData.getRenderValue());
            params.put("fromDataType", getValueData.getDataType().getValue());
            params.put("dataType", getValueBO.getComponentGetData().getType());
            return getValueData.getDataType().getValue();
        }
        return "";
    }

    private static String dealFlowChartGetValueRenderParam(LcdpComponent lcdpComponent, Ctx ctx, List<String> dataItems, Map<String, Object> params, ComponentReference to) throws LcdpException {
        ComponentData getValueData;
        GetValueBO getValueBO = ComponentDataUtil.getFlowChartDataItemGetValue(lcdpComponent, dataItems);
        if (HussarUtils.isNotEmpty((Object)getValueBO) && HussarUtils.isNotEmpty((Object)(getValueData = DataConfigUtil.getDataConfigValue((Ctx)ctx, (ComponentReference)getValueBO.getComponentGetData()))) && ToolUtil.isNotEmpty((Object)getValueData.getRenderValue())) {
            params.put("getValueData", getValueData.getRenderValue());
            Map<String, Object> resultMap = MappingUtils.getMappingResult(ctx, getValueBO.getComponentGetData().getMapping(), getValueBO.getComponentGetData(), to);
            params.putAll(resultMap);
            params.put("fromDataItem", getValueData.getRenderValue());
            params.put("fromDataType", getValueData.getDataType().getValue());
            params.put("dataType", getValueBO.getComponentGetData().getType());
            return getValueData.getDataType().getValue();
        }
        return "";
    }

    public static boolean judgeIsFromCollapse(LcdpComponent lcdpComponent, Ctx ctx, List<String> dataItems, ComponentValueStatusEnum dataItemValueStatus, Map<String, Object> params) {
        boolean fromCollapse = false;
        List<Object> fromKeys = new ArrayList();
        if (ComponentValueStatusEnum.SPECICAL_QUOTE.equals((Object)dataItemValueStatus)) {
            QuoteBO quoteBO = ComponentDataUtil.getComponentDataItemQuote(lcdpComponent, dataItems);
            if (null != quoteBO && ToolUtil.isNotEmpty((Object)quoteBO.getSpecialQuote())) {
                fromKeys = ComponentDataUtil.getFromKeys(quoteBO.getSpecialQuote());
            }
        } else {
            GetValueBO getValueBO = ComponentDataUtil.getComponentDataItemGetValue(lcdpComponent, dataItems);
            if (null != getValueBO) {
                fromKeys = ComponentDataUtil.getFromKeys(getValueBO.getComponentGetData());
            }
        }
        ArrayList<String> collapseKeys = new ArrayList<String>();
        for (String string : fromKeys) {
            String fromInsName = ((LcdpComponent)ctx.getComponentMap().get(string)).getName();
            if (!"com.jxdinfo.bjzjelement.JXDElCollapse".equals(fromInsName)) continue;
            fromCollapse = true;
            collapseKeys.add(string);
        }
        params.put("collapseKeys", collapseKeys);
        return fromCollapse;
    }

    private static List<String> getFromKeys(ComponentReference quoteData) {
        ArrayList<String> fromKeys = new ArrayList<String>();
        if (null != quoteData) {
            if (null != quoteData.getInstanceKey() && ToolUtil.isNotEmpty((Object)quoteData.getInstanceKey())) {
                fromKeys.add(quoteData.getInstanceKey());
            }
            if (HussarUtils.isNotEmpty((Object)quoteData.getCalData()) && quoteData.getCalData().size() != 0) {
                for (ComponentReference cal : quoteData.getCalData()) {
                    if (null == cal.getInstanceKey() || !ToolUtil.isNotEmpty((Object)cal.getInstanceKey())) continue;
                    fromKeys.add(cal.getInstanceKey());
                }
            }
        }
        return fromKeys;
    }

    private static String dealSpecialQuoteRenderParam(LcdpComponent lcdpComponent, Ctx ctx, List<String> dataItems, Map<String, Object> params, ComponentReference to) throws LcdpException {
        ComponentData quoteData;
        QuoteBO quoteBO = ComponentDataUtil.getComponentDataItemQuote(lcdpComponent, dataItems);
        if (HussarUtils.isNotEmpty((Object)quoteBO) && HussarUtils.isNotEmpty((Object)(quoteData = DataConfigUtil.getDataConfigValue((Ctx)ctx, (ComponentReference)quoteBO.getComponentQuote())))) {
            ComponentData specialQuoteData;
            String renderValue;
            if (ToolUtil.isNotEmpty((Object)quoteData.getRenderValue()) && !(renderValue = quoteData.getRenderValue()).contains("(")) {
                params.put("quoteData", quoteData.getRenderValue());
            }
            if (HussarUtils.isNotEmpty((Object)(specialQuoteData = DataConfigUtil.getDataConfigValue((Ctx)ctx, (ComponentReference)quoteBO.getSpecialQuote()))) && ToolUtil.isNotEmpty((Object)specialQuoteData.getRenderValue()) && ToolUtil.isNotEmpty((Object)quoteBO.getSpecialQuote())) {
                Map<String, Object> resultMap = MappingUtils.getMappingResult(ctx, quoteBO.getSpecialQuote().getMapping(), quoteBO.getSpecialQuote(), to);
                params.putAll(resultMap);
                params.put("fromDataItem", specialQuoteData.getRenderValue());
                params.put("fromDataType", specialQuoteData.getDataType().getValue());
                params.put("dataType", quoteBO.getSpecialQuote().getType());
                return specialQuoteData.getDataType().getValue();
            }
        }
        return "";
    }

    private static ComponentReference dealCurrDataItem(LcdpComponent lcdpComponent, Ctx ctx, List<String> dataItems, Map<String, Object> params) throws LcdpException {
        ComponentReference to = new ComponentReference(lcdpComponent.getInstanceKey(), dataItems);
        ComponentData toData = DataConfigUtil.getDataConfigValue((Ctx)ctx, (ComponentReference)to);
        params.put("toDataItem", "computedRes");
        if (HussarUtils.isNotEmpty((Object)toData)) {
            params.put("toDataType", toData.getDataType().getValue());
        } else {
            params.put("toDataType", ComponentData.DataTypeEnum.OBJECT.getValue());
        }
        return to;
    }

    public static boolean judgeCircleQuote(QuoteBO quoteBO, Ctx ctx, Map<String, List<List<String>>> quoteMap) throws LcdpException {
        List<List<String>> dataItemList;
        ComponentReference reference = quoteBO.getComponentQuote();
        if (reference.isConfigComplete(ctx) && DataFromEnum.VARIABLE.getValue().equals(reference.getType())) {
            return true;
        }
        LcdpComponent quoteComponent = (LcdpComponent)ctx.getComponentMap().get(reference.getInstanceKey());
        List quoteDataItems = reference.getInstanceData();
        boolean keyInMap = quoteMap.containsKey(quoteComponent.getInstanceKey());
        if (keyInMap && ToolUtil.isNotEmpty(dataItemList = quoteMap.get(quoteComponent.getInstanceKey()))) {
            for (List<String> item : dataItemList) {
                if (!item.equals(quoteDataItems)) continue;
                return false;
            }
        }
        if (ComponentValueStatusEnum.QUOTE.equals((Object)ComponentDataUtil.getComponentValueStatus(quoteComponent, ctx, quoteDataItems))) {
            if (keyInMap) {
                quoteMap.get(quoteComponent.getInstanceKey()).add(quoteDataItems);
            } else {
                ArrayList<List> dataItems = new ArrayList<List>();
                dataItems.add(quoteDataItems);
                quoteMap.put(quoteComponent.getInstanceKey(), dataItems);
            }
            QuoteBO nextQuoteBO = ComponentDataUtil.getComponentDataItemQuote(quoteComponent, quoteDataItems);
            return ComponentDataUtil.judgeCircleQuote(nextQuoteBO, ctx, quoteMap);
        }
        return true;
    }

    public static ComponentValueStatusEnum getComponentValueStatus(LcdpComponent lcdpComponent, Ctx ctx, List<String> dataItems) throws LcdpException {
        QuoteBO quoteBO = ComponentDataUtil.getComponentDataItemQuote(lcdpComponent, dataItems);
        GetValueBO getValueBO = ComponentDataUtil.getComponentDataItemGetValue(lcdpComponent, dataItems);
        if (null != quoteBO && ToolUtil.isNotEmpty((Object)quoteBO.getComponentQuote()) && quoteBO.getComponentQuote().isConfigComplete(ctx)) {
            if (ToolUtil.isNotEmpty((Object)quoteBO.getSpecialQuote()) && quoteBO.getSpecialQuote().isConfigComplete(ctx)) {
                return ComponentValueStatusEnum.SPECICAL_QUOTE;
            }
            ComponentData quoteData = DataConfigUtil.getDataConfigValue((Ctx)ctx, (ComponentReference)quoteBO.getComponentQuote());
            if (null != quoteData && ToolUtil.isNotEmpty((Object)quoteData.getRenderValue()) && !ComponentData.DataItemSourceEnum.READONLY.equals((Object)quoteData.getDataItemSource())) {
                return ComponentValueStatusEnum.QUOTE;
            }
            return ComponentValueStatusEnum.NONE;
        }
        if (null != getValueBO && ToolUtil.isNotEmpty((Object)getValueBO.getComponentGetData()) && getValueBO.getComponentGetData().isConfigComplete(ctx)) {
            return ComponentValueStatusEnum.GET_VALUE;
        }
        return ComponentValueStatusEnum.NONE;
    }

    public static ComponentValueStatusEnum getFlowChartValueStatus(LcdpComponent lcdpComponent, Ctx ctx, List<String> dataItems) {
        GetValueBO getValueBO = ComponentDataUtil.getFlowChartDataItemGetValue(lcdpComponent, dataItems);
        return null != getValueBO && ToolUtil.isNotEmpty((Object)getValueBO.getComponentGetData()) && getValueBO.getComponentGetData().isConfigComplete(ctx) ? ComponentValueStatusEnum.GET_VALUE : ComponentValueStatusEnum.NONE;
    }

    public static GetValueBO getFlowChartDataItemGetValue(LcdpComponent lcdpComponent, List<String> dataItems) {
        List<GetValueBO> getValueBOS = ComponentDataUtil.getFlowChartGetValue(lcdpComponent, dataItems);
        if (ToolUtil.isNotEmpty(getValueBOS)) {
            for (GetValueBO getValueBO : getValueBOS) {
                if (!getValueBO.getCurrentData().equals(dataItems)) continue;
                return getValueBO;
            }
        }
        return null;
    }

    public static List<GetValueBO> getComponentGetValue(LcdpComponent lcdpComponent) {
        JSONArray getValues = (JSONArray)lcdpComponent.getProps().get("calculateRefer");
        if (ToolUtil.isNotEmpty((Object)getValues)) {
            return JSON.parseArray((String)getValues.toJSONString(), GetValueBO.class);
        }
        return new ArrayList<GetValueBO>();
    }

    private static List<GetValueBO> getFlowChartGetValue(LcdpComponent lcdpComponent, List<String> dataItems) {
        String key = dataItems.get(0);
        JSONArray getValues = (JSONArray)lcdpComponent.getProps().get(key);
        return ToolUtil.isNotEmpty((Object)getValues) ? JSON.parseArray((String)getValues.toJSONString(), GetValueBO.class) : new ArrayList();
    }

    public static GetValueBO getComponentDataItemGetValue(LcdpComponent lcdpComponent, List<String> dataItems) {
        List<GetValueBO> getValueBOS = ComponentDataUtil.getComponentGetValue(lcdpComponent);
        if (ToolUtil.isNotEmpty(getValueBOS)) {
            for (GetValueBO getValueBO : getValueBOS) {
                if (!getValueBO.getCurrentData().equals(dataItems)) continue;
                return getValueBO;
            }
        }
        return null;
    }

    public static QuoteBO getComponentDataItemQuote(LcdpComponent lcdpComponent, List<String> dataItems) {
        List<QuoteBO> quoteBOS = ComponentDataUtil.getComponentQuoteValue(lcdpComponent);
        if (ToolUtil.isNotEmpty(quoteBOS)) {
            for (QuoteBO quoteBO : quoteBOS) {
                if (!quoteBO.getCurrentData().equals(dataItems)) continue;
                return quoteBO;
            }
        }
        return null;
    }

    private static List<QuoteBO> getComponentQuoteValue(LcdpComponent lcdpComponent) {
        JSONArray quotes = (JSONArray)lcdpComponent.getProps().get("reference");
        if (ToolUtil.isNotEmpty((Object)quotes)) {
            return JSON.parseArray((String)quotes.toJSONString(), QuoteBO.class);
        }
        return new ArrayList<QuoteBO>();
    }

    public static String dealPrefixThis(String str) {
        if (ToolUtil.isNotEmpty((Object)str)) {
            if (str.startsWith(CodePrefix._THIS.getType())) {
                str = str.replaceFirst(CodePrefix._THIS.getType(), "");
            }
            if (str.startsWith(CodePrefix._SELF.getType())) {
                str = str.replaceFirst(CodePrefix._SELF.getType(), "");
            }
            if (str.startsWith(CodePrefix._THIS.getType()) || str.startsWith(CodePrefix._SELF.getType())) {
                str = ComponentDataUtil.dealPrefixThis(str);
            }
        }
        return str;
    }

    public static void addPackageTreeFieldMethod(Ctx ctx) {
        if (!ctx.getMethods().containsKey(PACKAGE_TREE_FIELD_FUNCTION)) {
            List<String> args = Arrays.asList("res", "data", "field");
            ctx.addMethod(PACKAGE_TREE_FIELD_FUNCTION, args, "data.forEach((item) => {\nres.push(item[field]);\nif (item.children && item.children.length > 0) {\n" + CodePrefix._SELF.getType() + PACKAGE_TREE_FIELD_FUNCTION + "(res, item.children, field);\n}\n});", false);
        }
    }

    @SafeVarargs
    public static String listToString(List<String> ... lists) {
        if (ToolUtil.isNotEmpty(lists)) {
            List collect = Stream.of(lists).flatMap(Collection::stream).collect(Collectors.toList());
            return StringUtil.join(collect);
        }
        return "";
    }

    public static void getTreeFieldMethod(Ctx ctx) {
        if (!ctx.getMethods().containsKey(GET_TREEFIELDVALUE_FUNCTION)) {
            List<String> args = Arrays.asList("valueField", "value", "options", "field");
            ctx.addMethod(GET_TREEFIELDVALUE_FUNCTION, args, "if (!value && value !== 0) {\n    return '';\n  }\n  for (let i = 0; i < options.length; i++) {\n    const item = options[i];\n    if (item[valueField] == value) {\n      return item[field];\n    } else {\n      if (item.children && item.children.length > 0) {\n        const res = self.getTreeFieldValue(valueField, value, item.children, field);\n        if (res) {\n          return res;\n        }\n      }\n    }\n  }", false);
        }
    }

    public static enum ComponentValueStatusEnum {
        NONE,
        GET_VALUE,
        QUOTE,
        SPECICAL_QUOTE;

    }
}

