/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.base.common.utils;

import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.datas.DataSConditionListAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.datas.DataSParamConfigs;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.dataset.DataSetParamModel;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.dataset.DataSetQueryField;
import com.jxdinfo.hussar.formdesign.codegenerator.core.data.constant.DataFromEnum;
import com.jxdinfo.hussar.formdesign.codegenerator.core.data.model.ComponentReference;
import com.jxdinfo.hussar.formdesign.codegenerator.core.util.DataConfigUtil;
import com.jxdinfo.hussar.formdesign.common.ctx.Ctx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ComponentData;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class QueryAttrUtil {
    public static StringBuilder getQueryAttr(List<DataSConditionListAnalysis> conditionList, Ctx ctx) throws LcdpException {
        StringBuilder queryAttr = new StringBuilder(128);
        if (ToolUtil.isNotEmpty(conditionList)) {
            for (DataSConditionListAnalysis dataSConditionListAnalysis : conditionList) {
                String attrName = dataSConditionListAnalysis.getQueryAttrName();
                ComponentReference componentReference = dataSConditionListAnalysis.getDataItem();
                ComponentData data = DataConfigUtil.getDataConfigValue((Ctx)ctx, (ComponentReference)componentReference);
                String renderGet = null != data ? data.getRenderValue() : "''";
                if ("".equals(attrName)) continue;
                queryAttr.append(attrName).append(": ").append(renderGet).append(",");
            }
        }
        return queryAttr;
    }

    public static StringBuilder getQueryCheck(List<DataSConditionListAnalysis> conditionList, String objName) {
        StringBuilder queryCheck = new StringBuilder(128);
        if (ToolUtil.isNotEmpty(conditionList)) {
            for (DataSConditionListAnalysis dataSConditionListAnalysis : conditionList) {
                String attrName = dataSConditionListAnalysis.getQueryAttrName();
                ComponentReference componentReference = dataSConditionListAnalysis.getDataItem();
                String dataItemType = componentReference.getType();
                if (DataFromEnum.INPUT.getValue().equals(dataItemType)) continue;
                if (ToolUtil.isNotEmpty((Object)queryCheck.toString())) {
                    queryCheck.append(" && ").append("!").append(objName).append("Obj.").append(attrName);
                    continue;
                }
                queryCheck.append(" !").append(objName).append("Obj.").append(attrName);
            }
        }
        return queryCheck;
    }

    public static StringBuilder getQueryConditionVariable(List<DataSConditionListAnalysis> conditionList) {
        HashMap<String, String> queryConditionVariable = new HashMap<String, String>();
        StringBuilder stringBuilder = new StringBuilder();
        for (DataSConditionListAnalysis dataSConditionListAnalysis : conditionList) {
            queryConditionVariable.put(dataSConditionListAnalysis.getQueryAttrName(), dataSConditionListAnalysis.getDataItem().getDataType());
        }
        for (Map.Entry entry : queryConditionVariable.entrySet()) {
            stringBuilder.append((String)entry.getKey()).append(": ").append("'").append((String)entry.getValue()).append("'").append(",");
        }
        return stringBuilder;
    }

    public static StringBuilder getQueryCondition(StringBuilder result, Ctx ctx, List<DataSetQueryField> dataSetQuery) throws LcdpException {
        for (DataSetQueryField dataSetQueryCondition : dataSetQuery) {
            result.append("{ ");
            if ("row".equals(dataSetQueryCondition.getType())) {
                StringBuilder builder = QueryAttrUtil.getDataSetQueryCondition(ctx, dataSetQueryCondition);
                result.append((CharSequence)builder);
                continue;
            }
            if (!"child".equals(dataSetQueryCondition.getType()) || !HussarUtils.isNotEmpty(dataSetQueryCondition.getChildren())) continue;
            result.append("children: [ ");
            QueryAttrUtil.getQueryCondition(result, ctx, dataSetQueryCondition.getChildren());
            result.append("],},");
        }
        char lastChar = result.charAt(result.length() - 1);
        if (lastChar == ',') {
            result.delete(result.length() - 1, result.length());
        }
        return result;
    }

    public static StringBuilder getDataSetQueryCondition(Ctx ctx, DataSetQueryField dataSetQueryCondition) throws LcdpException {
        HashMap<String, String> queryConditionMap = new HashMap<String, String>();
        StringBuilder result = new StringBuilder();
        StringBuilder stringBuilder = new StringBuilder();
        String connect = dataSetQueryCondition.getConnect();
        String symbol = dataSetQueryCondition.getSymbol();
        String fromModelField = dataSetQueryCondition.getFromModelField();
        ComponentReference dataItem = dataSetQueryCondition.getDataItem();
        if (ToolUtil.isNotEmpty((Object)dataItem.getConfigData())) {
            queryConditionMap.put("val", dataItem.getConfigData());
        } else {
            ComponentData data = DataConfigUtil.getDataConfigValue((Ctx)ctx, (ComponentReference)dataItem);
            queryConditionMap.put("val", data.getRenderValue());
        }
        queryConditionMap.put("rule", symbol);
        queryConditionMap.put("match", connect);
        queryConditionMap.put("field", fromModelField);
        for (Map.Entry entry : queryConditionMap.entrySet()) {
            stringBuilder.append((String)entry.getKey()).append(": ");
            if (((String)entry.getValue()).contains("self.")) {
                stringBuilder.append((String)entry.getValue()).append(",");
                continue;
            }
            stringBuilder.append("'").append((String)entry.getValue()).append("'").append(",");
        }
        result.append((CharSequence)stringBuilder).append(" },");
        return result;
    }

    public static StringBuilder getDataSetQueryCondition(Ctx ctx, List<DataSetQueryField> conditionList) throws LcdpException {
        HashMap<String, String> queryConditionMap = new HashMap<String, String>();
        StringBuilder result = new StringBuilder();
        if (ToolUtil.isNotEmpty(conditionList)) {
            for (DataSetQueryField dataSetQueryField : conditionList) {
                StringBuilder stringBuilder = new StringBuilder();
                String connect = dataSetQueryField.getConnect();
                String symbol = dataSetQueryField.getSymbol();
                String fromModelField = dataSetQueryField.getFromModelField();
                ComponentReference dataItem = dataSetQueryField.getDataItem();
                if (ToolUtil.isNotEmpty((Object)dataItem.getConfigData())) {
                    queryConditionMap.put("val", dataItem.getConfigData());
                } else {
                    ComponentData data = DataConfigUtil.getDataConfigValue((Ctx)ctx, (ComponentReference)dataItem);
                    queryConditionMap.put("val", data.getRenderValue());
                }
                queryConditionMap.put("rule", symbol);
                queryConditionMap.put("match", connect);
                queryConditionMap.put("field", fromModelField);
                for (Map.Entry entry : queryConditionMap.entrySet()) {
                    stringBuilder.append((String)entry.getKey()).append(": ");
                    if (((String)entry.getValue()).contains("self.")) {
                        stringBuilder.append((String)entry.getValue()).append(",");
                        continue;
                    }
                    stringBuilder.append("'").append((String)entry.getValue()).append("'").append(",");
                }
                result.append("{ ").append((CharSequence)stringBuilder).append(" },");
            }
        }
        return result;
    }

    public static String getParamconfigData(String paramId, List<DataSetParamModel> params) {
        List paramModels = params.stream().filter(param -> param.getId().equals(paramId)).collect(Collectors.toList());
        String configData = null;
        if (ToolUtil.isNotEmpty(paramModels)) {
            configData = ((DataSetParamModel)paramModels.get(0)).getParamData().get(0).getConfigData();
        }
        return configData;
    }

    public static StringBuilder getDataSetQueryAttr(List<DataSConditionListAnalysis> conditionList, List<DataSParamConfigs> paramConfigs, Ctx ctx, String dataModelId) throws LcdpException {
        StringBuilder queryAttr = new StringBuilder(128);
        if (ToolUtil.isNotEmpty(conditionList)) {
            for (DataSConditionListAnalysis dataSConditionListAnalysis : conditionList) {
                String attrName = dataSConditionListAnalysis.getQueryAttrName();
                ComponentReference componentReference = dataSConditionListAnalysis.getDataItem();
                ComponentData data = DataConfigUtil.getDataConfigValue((Ctx)ctx, (ComponentReference)componentReference);
                String renderGet = null != data ? data.getRenderValue() : "''";
                if ("".equals(attrName)) continue;
                queryAttr.append(attrName).append(": ").append(renderGet).append(",");
            }
        }
        if (ToolUtil.isNotEmpty(paramConfigs)) {
            for (DataSParamConfigs paramConfig : paramConfigs) {
                if (!ToolUtil.isNotEmpty((Object)paramConfig) || !ToolUtil.isNotEmpty((Object)paramConfig.getCurrentData())) continue;
                String dataModelParamName = DataModelUtil.getDataModelParamName((String)dataModelId, (String)paramConfig.getCurrentData());
                ComponentData data = DataConfigUtil.getDataConfigValue((Ctx)ctx, (ComponentReference)paramConfig.getComponentReference());
                String renderGet = null != data ? data.getRenderValue() : "''";
                if ("".equals(dataModelParamName)) continue;
                queryAttr.append(dataModelParamName).append(": ").append(renderGet).append(",");
            }
        }
        return queryAttr;
    }
}

