/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.base.common.event;

import com.alibaba.fastjson.JSONArray;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.clearvalue.ClearValueRecord;
import com.jxdinfo.hussar.formdesign.base.common.utils.MultilineExegesisUtil;
import com.jxdinfo.hussar.formdesign.codegenerator.core.data.constant.DataFromEnum;
import com.jxdinfo.hussar.formdesign.common.ctx.Ctx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.model.variables.PageVariables;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.Action;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ComponentData;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.LcdpComponent;
import com.jxdinfo.hussar.formdesign.common.render.RenderCore;
import com.jxdinfo.hussar.formdesign.common.render.RenderResult;
import com.jxdinfo.hussar.formdesign.common.util.DynDataUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.visitor.ActionVisitor;
import com.jxdinfo.hussar.formdesign.common.visitor.BaseProvideVisitor;
import com.jxdinfo.hussar.formdesign.common.visitor.ValueVisitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component(value="Base.ClearValueAction")
public class ClearValue
implements ActionVisitor {
    public void visitor(Action action, Ctx ctx) throws Exception {
        HashMap<String, Object> encapsulationValueMap = new HashMap<String, Object>();
        RenderCore renderCore = new RenderCore();
        renderCore.registerTemplatePath("/template/common/event/ClearValue.ftl");
        LcdpComponent myLcdpComponent = action.getCurrentLcdpComponent();
        String trigger = action.getTrigger();
        String triggerName = myLcdpComponent.getInstanceKey() + ToolUtil.firstLetterToUpper((String)trigger);
        encapsulationValueMap.put("trigger", triggerName);
        Map params = action.getParamValues();
        HashMap<String, String> toResultMap = new HashMap<String, String>();
        if (ToolUtil.isNotEmpty((Object)params)) {
            Object values = params.get("clearValue");
            if (ToolUtil.isNotEmpty(values)) {
                if (DynDataUtil.isArrayType(values)) {
                    List clearValues = (List)values;
                    List<Object> idList = new ArrayList();
                    JSONArray jsonArray = new JSONArray();
                    jsonArray.addAll((Collection)clearValues);
                    for (ClearValueRecord clearValue : jsonArray.toJavaList(ClearValueRecord.class)) {
                        if (DataFromEnum.VARIABLE.getValue().equals(clearValue.getType())) {
                            String keys = clearValue.getKey();
                            idList = Arrays.asList(keys.split(","));
                            if (!ToolUtil.isNotEmpty(idList)) continue;
                            List pageVariablesList = ctx.getPageInfo().getPageVariables();
                            for (String string : idList) {
                                for (PageVariables p : pageVariablesList) {
                                    if (!p.getVariablesName().equals(string)) continue;
                                    toResultMap.put("self." + string, p.getVariablesDataType());
                                }
                            }
                            continue;
                        }
                        if (!DataFromEnum.INSTANCE.getValue().equals(clearValue.getType())) continue;
                        Map<String, String> map = this.handleToMapByInsKey(clearValue.getKey(), ctx, params);
                        toResultMap.putAll(map);
                    }
                } else if (DynDataUtil.isStringType(values)) {
                    Map<String, String> map = this.handleToMapByInsKey((String)values, ctx, params);
                    toResultMap.putAll(map);
                }
            }
            encapsulationValueMap.put("toResults", toResultMap);
        }
        encapsulationValueMap.put("exegesisResult", MultilineExegesisUtil.handleActionExegesisText(action));
        renderCore.registerParam(encapsulationValueMap);
        RenderResult renderResult = renderCore.render();
        if (renderResult.isStatus()) {
            ctx.addMethod(triggerName, renderResult.getRenderString(), false);
        }
    }

    private Map<String, String> handleToMapByInsKey(String values, Ctx ctx, Map<String, Object> params) throws LcdpException {
        HashMap<String, String> toResultMap = new HashMap<String, String>();
        String ids = values;
        List<String> idList = Arrays.asList(ids.split(","));
        for (String id : idList) {
            LcdpComponent toComponent = (LcdpComponent)ctx.getComponentMap().get(id);
            if (!ToolUtil.isNotEmpty((Object)toComponent)) continue;
            ValueVisitor toProvideVisitor = (ValueVisitor)toComponent.getProvideVisitor("value");
            toComponent.accept((BaseProvideVisitor)toProvideVisitor, ctx, params);
            List toResults = toProvideVisitor.getClearValue(null);
            for (ComponentData toResult : toResults) {
                String value = toResult.getRenderValue();
                if (ToolUtil.isNotEmpty(toComponent.getProps().get("relateForm")) && ((Boolean)toComponent.getProps().get("relateForm")).booleanValue()) {
                    value = value + "Form";
                }
                toResultMap.put(value, toResult.getDataType().getValue());
            }
        }
        return toResultMap;
    }
}

