/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.base.common.event.apiInvoke;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.back.model.apiModel.ApiDataModel;
import com.jxdinfo.hussar.formdesign.back.model.apiModel.ApiDataModelOperation;
import com.jxdinfo.hussar.formdesign.back.model.apiModel.ApiRequestMethod;
import com.jxdinfo.hussar.formdesign.base.common.event.apiInvoke.model.ApiActionModel;
import com.jxdinfo.hussar.formdesign.base.common.event.apiInvoke.model.ApiParamModel;
import com.jxdinfo.hussar.formdesign.base.common.event.apiInvoke.templateParam.ApiBaseTypeParam;
import com.jxdinfo.hussar.formdesign.base.common.event.apiInvoke.templateParam.ApiBodyTypeParam;
import com.jxdinfo.hussar.formdesign.base.common.event.apiInvoke.templateParam.ApiRequestParam;
import com.jxdinfo.hussar.formdesign.base.common.event.apiInvoke.templateParam.WebTemplateParam;
import com.jxdinfo.hussar.formdesign.base.common.utils.MappingUtils;
import com.jxdinfo.hussar.formdesign.codegenerator.core.data.mapping.DataItemMappingBO;
import com.jxdinfo.hussar.formdesign.codegenerator.core.data.model.ComponentReference;
import com.jxdinfo.hussar.formdesign.codegenerator.core.util.DataConfigUtil;
import com.jxdinfo.hussar.formdesign.common.ctx.Ctx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ComponentData;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ApiInvoke {
    private ApiActionModel action;
    private ApiDataModel apiDataModel;
    private Ctx ctx;
    private JSONObject appStructDataModel;

    public ApiInvoke(Ctx ctx, ApiDataModel apiDataModel, ApiActionModel action) {
        this.action = action;
        this.apiDataModel = apiDataModel;
        this.ctx = ctx;
    }

    public ApiInvoke(ApiActionModel action, Ctx ctx, JSONObject appStructDataModel) {
        this.action = action;
        this.ctx = ctx;
        this.appStructDataModel = appStructDataModel;
    }

    public WebTemplateParam buildWebParam() throws LcdpException {
        ApiRequestParam apiRequestParam;
        ApiDataModelOperation operation = this.apiDataModel.getOperationById(this.action.getOperationId());
        if (operation != null && operation.getRequestMode().equals((Object)ApiRequestMethod.GET)) {
            apiRequestParam = this.build(this.apiDataModel.getId2NameOfQuery(this.action.getOperationId()));
        } else if (operation != null && operation.getRequestMode().equals((Object)ApiRequestMethod.POST)) {
            apiRequestParam = this.build(this.apiDataModel.getId2NameOfBody(this.action.getOperationId()));
        } else {
            throw new LcdpException(LcdpExceptionEnum.ERROR, "\u4e0d\u652f\u6301GET\u3001POST\u4ee5\u5916\u7684\u65b9\u5f0f");
        }
        return new WebTemplateParam(this.apiDataModel.getName(), operation.getName(), apiRequestParam, "");
    }

    public WebTemplateParam buildAppParam() throws LcdpException {
        ApiRequestParam apiRequestParam = this.appBuild(this.getIdNameOfBody(this.action.getOperationId()));
        return new WebTemplateParam((String)this.appStructDataModel.get((Object)"name"), this.getOptionNameById(this.action.getOperationId()), apiRequestParam, "");
    }

    private String getOptionNameById(String operationId) {
        if (HussarUtils.isEmpty((Object)this.appStructDataModel)) {
            return "";
        }
        List operations = (List)this.appStructDataModel.get((Object)"operations");
        if (HussarUtils.isEmpty((Object)operations)) {
            return "";
        }
        for (JSONObject operation : operations) {
            if (HussarUtils.isEmpty((Object)operation) || !HussarUtils.equals((Object)operationId, (Object)operation.get((Object)"id"))) continue;
            String name = (String)operation.get((Object)"name");
            String appCode = (String)operation.get((Object)"appCode");
            if (HussarUtils.isNotBlank((CharSequence)appCode)) {
                name = name + "_" + appCode;
            }
            return name;
        }
        return "";
    }

    private Map<String, ApiDataModel.DatasetIdName> getIdNameOfBody(String operationId) {
        HashMap<String, ApiDataModel.DatasetIdName> idNameMap = new HashMap<String, ApiDataModel.DatasetIdName>();
        if (HussarUtils.isEmpty((Object)this.appStructDataModel)) {
            return idNameMap;
        }
        List operations = (List)this.appStructDataModel.get((Object)"operations");
        if (HussarUtils.isEmpty((Object)operations)) {
            return idNameMap;
        }
        for (JSONObject operation : operations) {
            List body;
            JSONObject inParams;
            if (HussarUtils.isEmpty((Object)operation) || !HussarUtils.equals((Object)operationId, (Object)operation.get((Object)"id")) || !HussarUtils.isNotEmpty((Object)(inParams = (JSONObject)operation.get((Object)"inParams"))) || !HussarUtils.isNotEmpty((Object)(body = (List)inParams.get((Object)"body")))) continue;
            this.getIdName(idNameMap, body, true);
        }
        return idNameMap;
    }

    private void getIdName(Map<String, ApiDataModel.DatasetIdName> idNameMap, List<JSONObject> inParams, boolean fromBody) {
        for (JSONObject param : inParams) {
            String id = (String)param.get((Object)"id");
            String name = (String)param.get((Object)"name");
            ApiDataModel.DatasetIdName datasetIdName = null;
            Integer type = (Integer)param.get((Object)"type");
            Integer itemType = null;
            if (type == 6) {
                itemType = (Integer)param.get((Object)"itemType");
            }
            List items = (List)param.get((Object)"items");
            if ((type == 7 || type == 6 && itemType == 6) && HussarUtils.isNotEmpty((Object)items)) {
                datasetIdName = new ApiDataModel.DatasetIdName(id, name, fromBody);
                this.getIdName(idNameMap, items, false);
            } else if (type == 6 && itemType == 7 && HussarUtils.isNotEmpty((Object)items) && items.size() > 0) {
                datasetIdName = new ApiDataModel.DatasetIdName(id, name, fromBody);
                List objectItems = (List)((JSONObject)items.get(0)).get((Object)"items");
                if (HussarUtils.isNotEmpty((Object)objectItems)) {
                    this.getIdName(idNameMap, objectItems, false);
                }
            }
            if (datasetIdName == null) {
                datasetIdName = new ApiDataModel.DatasetIdName(id, name, false);
            }
            idNameMap.put(id, datasetIdName);
        }
    }

    private ApiRequestParam build(Map<String, ApiDataModel.DatasetIdName> datasetId2Name) throws LcdpException {
        List<ApiParamModel> paramConfigs = this.action.getParamConfigs();
        ApiRequestParam apiRequestParam = new ApiRequestParam(this.action.getName());
        for (ApiParamModel paramConfig : paramConfigs) {
            if (!datasetId2Name.containsKey(paramConfig.getCurrentData())) continue;
            if (datasetId2Name.get(paramConfig.getCurrentData()).getFromBody()) {
                ApiBodyTypeParam bodyParam = this.bodyObjectTypeHandle(datasetId2Name, paramConfig);
                apiRequestParam.setBodyParam(bodyParam);
                continue;
            }
            ApiBaseTypeParam apiBaseTypeParam = this.baseTypeHandle(datasetId2Name, paramConfig);
            apiRequestParam.getApiBaseTypeParams().add(apiBaseTypeParam);
        }
        return apiRequestParam;
    }

    private ApiRequestParam appBuild(Map<String, ApiDataModel.DatasetIdName> datasetId2Name) throws LcdpException {
        List<ApiParamModel> paramConfigs = this.action.getParamConfigs();
        ApiRequestParam apiRequestParam = new ApiRequestParam(this.action.getName());
        apiRequestParam.setApp(true);
        ApiBodyTypeParam params = new ApiBodyTypeParam();
        params.setDatasetType("app");
        params.setApiBaseTypeParams(new ArrayList<ApiBaseTypeParam>());
        params.setApiBodyTypeParams(new ArrayList<ApiBodyTypeParam>());
        apiRequestParam.setBodyParam(params);
        for (ApiParamModel paramConfig : paramConfigs) {
            if (!datasetId2Name.containsKey(paramConfig.getCurrentData())) continue;
            if (datasetId2Name.get(paramConfig.getCurrentData()).getFromBody()) {
                ApiBodyTypeParam bodyParam = this.bodyObjectTypeHandle(datasetId2Name, paramConfig);
                bodyParam.setBodyName(datasetId2Name.get(paramConfig.getCurrentData()).getName());
                params.addApiBodyTypeParams(bodyParam);
                continue;
            }
            ApiBaseTypeParam apiBaseTypeParam = this.baseTypeHandle(datasetId2Name, paramConfig);
            params.addApiBaseTypeParams(apiBaseTypeParam);
        }
        return apiRequestParam;
    }

    private ApiBodyTypeParam bodyObjectTypeHandle(Map<String, ApiDataModel.DatasetIdName> datasetId2Name, ApiParamModel paramConfig) throws LcdpException {
        ComponentData dataConfigValue = DataConfigUtil.getDataConfigValue((Ctx)this.ctx, (ComponentReference)paramConfig.getComponentReference());
        if (dataConfigValue == null) {
            dataConfigValue = new ComponentData(ComponentData.DataTypeEnum.STRING, ComponentData.DataItemSourceEnum.READONLY, "''");
        }
        ApiBodyTypeParam apiObjectTypeParam = new ApiBodyTypeParam();
        apiObjectTypeParam.setJsVariable(dataConfigValue.getRenderValue());
        apiObjectTypeParam.setParentDataSetNames("");
        apiObjectTypeParam.setDatasetType(paramConfig.getCurrentDataType());
        apiObjectTypeParam.setApiBaseTypeParams(new ArrayList<ApiBaseTypeParam>());
        if (paramConfig.getMapping().size() > 0) {
            Map<String, String> componentId2JsVariable = MappingUtils.getFieldMapping(paramConfig.getComponentReference(), this.ctx);
            List<DataItemMappingBO<String>> componentId2DatasetId = paramConfig.getMapping();
            List<DataItemMappingBO<String>> jsVariable2DatasetNameList = MappingUtils.getDataItemMappingBOS(componentId2DatasetId, componentId2JsVariable, this.datasetId2NameTransfer(datasetId2Name));
            jsVariable2DatasetNameList.forEach(jsVariable2DatasetName -> apiObjectTypeParam.getApiBaseTypeParams().add(new ApiBaseTypeParam((String)jsVariable2DatasetName.getToDataItem(), (String)jsVariable2DatasetName.getFromDataItem())));
        }
        return apiObjectTypeParam;
    }

    private Map<String, String> datasetId2NameTransfer(Map<String, ApiDataModel.DatasetIdName> datasetId2Name) {
        if (CollectionUtil.isEmpty(datasetId2Name)) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> res = new HashMap<String, String>();
        datasetId2Name.entrySet().forEach(entry -> res.put((String)entry.getKey(), ((ApiDataModel.DatasetIdName)entry.getValue()).getName()));
        return res;
    }

    private ApiBaseTypeParam baseTypeHandle(Map<String, ApiDataModel.DatasetIdName> datasetId2Name, ApiParamModel paramConfig) throws LcdpException {
        ComponentData dataConfigValue = DataConfigUtil.getDataConfigValue((Ctx)this.ctx, (ComponentReference)paramConfig.getComponentReference());
        if (dataConfigValue == null) {
            dataConfigValue = new ComponentData(ComponentData.DataTypeEnum.STRING, ComponentData.DataItemSourceEnum.READONLY, "''");
        }
        ApiBaseTypeParam apiBaseTypeParam = new ApiBaseTypeParam();
        apiBaseTypeParam.setDataSetName(datasetId2Name.get(paramConfig.getCurrentData()).getName());
        apiBaseTypeParam.setJsVariable(dataConfigValue.getRenderValue());
        return apiBaseTypeParam;
    }
}

