/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.base.common.event;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.base.common.utils.MultilineExegesisUtil;
import com.jxdinfo.hussar.formdesign.codegenerator.core.data.model.ComponentReference;
import com.jxdinfo.hussar.formdesign.codegenerator.core.util.DataConfigUtil;
import com.jxdinfo.hussar.formdesign.common.ctx.Ctx;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.Action;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ComponentData;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.LcdpComponent;
import com.jxdinfo.hussar.formdesign.common.render.RenderCore;
import com.jxdinfo.hussar.formdesign.common.render.RenderResult;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.visitor.ActionVisitor;
import java.util.HashMap;
import org.springframework.stereotype.Component;

@Component(value="Base.PreviewDocumentAction")
public class PreviewDocument
implements ActionVisitor {
    public void visitor(Action action, Ctx ctx) throws Exception {
        JSONObject documentSize;
        JSONObject documentName;
        HashMap<String, String> encapsulationValueMap = new HashMap<String, String>();
        RenderCore renderCore = new RenderCore();
        renderCore.registerTemplatePath("/template/common/event/PreviewDocument.ftl");
        LcdpComponent myLcdpComponent = action.getCurrentLcdpComponent();
        String trigger = action.getTrigger();
        String triggerName = myLcdpComponent.getInstanceKey() + ToolUtil.firstLetterToUpper((String)trigger);
        encapsulationValueMap.put("trigger", triggerName);
        JSONObject documentUrl = (JSONObject)action.getParamValues().get("documentUrl");
        if (ToolUtil.isNotEmpty((Object)documentUrl)) {
            ComponentData documentUrlData = new ComponentData();
            ComponentReference from = (ComponentReference)JSON.parseObject((String)JSON.toJSONString((Object)documentUrl), ComponentReference.class);
            documentUrlData = DataConfigUtil.getDataConfigValue((Ctx)ctx, (ComponentReference)from);
            if (this.isComponentDataEmpty(documentUrlData).booleanValue()) {
                documentUrlData.setRenderValue(documentUrlData.getRenderValue());
                encapsulationValueMap.put("documentUrl", documentUrlData.getRenderValue());
            }
        }
        if (ToolUtil.isNotEmpty((Object)(documentName = (JSONObject)action.getParamValues().get("documentName")))) {
            ComponentData documentNameData = new ComponentData();
            ComponentReference from = (ComponentReference)JSON.parseObject((String)JSON.toJSONString((Object)documentName), ComponentReference.class);
            documentNameData = DataConfigUtil.getDataConfigValue((Ctx)ctx, (ComponentReference)from);
            if (this.isComponentDataEmpty(documentNameData).booleanValue()) {
                documentNameData.setRenderValue(documentNameData.getRenderValue());
                encapsulationValueMap.put("documentName", documentNameData.getRenderValue());
            }
        }
        if (ToolUtil.isNotEmpty((Object)(documentSize = (JSONObject)action.getParamValues().get("documentName")))) {
            ComponentData documentSizeData = new ComponentData();
            ComponentReference from = (ComponentReference)JSON.parseObject((String)JSON.toJSONString((Object)documentSize), ComponentReference.class);
            documentSizeData = DataConfigUtil.getDataConfigValue((Ctx)ctx, (ComponentReference)from);
            if (this.isComponentDataEmpty(documentSizeData).booleanValue()) {
                documentSizeData.setRenderValue(documentSizeData.getRenderValue());
                encapsulationValueMap.put("documentSize", documentSizeData.getRenderValue());
            }
        }
        encapsulationValueMap.put("exegesisResult", MultilineExegesisUtil.handleActionExegesisText(action));
        renderCore.registerParam(encapsulationValueMap);
        RenderResult renderResult = renderCore.render();
        if (renderResult.isStatus()) {
            ctx.addMethod(triggerName, renderResult.getRenderString(), false);
        }
    }

    private Boolean isComponentDataEmpty(ComponentData componentData) {
        Boolean isOk = true;
        if (ToolUtil.isNotEmpty((Object)componentData)) {
            if ("".equals(componentData.getRenderValue())) {
                isOk = false;
            }
            if (ToolUtil.isEmpty((Object)componentData.getDataType()) || "".equals(componentData.getDataType().getValue())) {
                isOk = false;
            }
        } else {
            isOk = false;
        }
        return isOk;
    }
}

