/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.base.common.event;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.base.common.utils.MultilineExegesisUtil;
import com.jxdinfo.hussar.formdesign.common.ctx.Ctx;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.Action;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.LcdpComponent;
import com.jxdinfo.hussar.formdesign.common.render.RenderCore;
import com.jxdinfo.hussar.formdesign.common.render.RenderResult;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.visitor.ActionVisitor;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component(value="Base.AlertMessageAction")
public class AlertMessage
implements ActionVisitor {
    public void visitor(Action action, Ctx ctx) throws Exception {
        String messageContent;
        HashMap<String, Object> moduleMap = new HashMap<String, Object>();
        RenderCore renderCore = new RenderCore();
        String pageType = ctx.getPageInfo().getType();
        if ("MobilePage".equals(pageType)) {
            renderCore.registerTemplatePath("/template/common/event/AlertMobileMessage.ftl");
        } else {
            renderCore.registerTemplatePath("/template/common/event/AlertMessage.ftl");
        }
        LcdpComponent myLcdpComponent = action.getCurrentLcdpComponent();
        String trigger = action.getTrigger();
        String triggerName = myLcdpComponent.getInstanceKey() + ToolUtil.firstLetterToUpper((String)trigger);
        moduleMap.put("trigger", triggerName);
        Map params = action.getParamValues();
        String alertMessageType = (String)params.get("alertMessageType");
        if (ToolUtil.isEmpty(params.get("messageContent"))) {
            messageContent = "";
        } else if (params.get("messageContent").getClass() == String.class) {
            messageContent = (String)params.get("messageContent");
        } else {
            JSONObject paramValues = (JSONObject)params.get("messageContent");
            if (paramValues.get((Object)"international").equals(true)) {
                String internationalCode = (String)paramValues.get((Object)"internationalCode");
                messageContent = "this.$t('" + internationalCode + "')";
                moduleMap.put("international", true);
            } else {
                messageContent = (String)paramValues.get((Object)"internationalCode");
            }
        }
        String messagePosition = (String)params.get("messagePosition");
        if ("text".equals(alertMessageType)) {
            alertMessageType = "";
        }
        if (ToolUtil.isEmpty((Object)messagePosition)) {
            messagePosition = "";
        }
        moduleMap.put("alertMessageType", alertMessageType);
        moduleMap.put("messageContent", messageContent);
        moduleMap.put("messagePosition", messagePosition);
        moduleMap.put("exegesisResult", MultilineExegesisUtil.handleActionExegesisText(action));
        renderCore.registerParam(moduleMap);
        RenderResult renderResult = renderCore.render();
        if (renderResult.isStatus()) {
            if (action.getGetResult().booleanValue()) {
                action.setRenderResult(renderResult.getRenderString());
            } else {
                ctx.addMethod(triggerName, renderResult.getRenderString(), false);
            }
        }
    }
}

