/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.base.common.event.apiInvoke;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.back.model.apiModel.ApiDataModel;
import com.jxdinfo.hussar.formdesign.base.common.event.apiInvoke.ApiInvoke;
import com.jxdinfo.hussar.formdesign.base.common.event.apiInvoke.ApiInvokeFactory;
import com.jxdinfo.hussar.formdesign.base.common.event.apiInvoke.model.ApiActionModel;
import com.jxdinfo.hussar.formdesign.base.common.event.apiInvoke.templateParam.WebTemplateParam;
import com.jxdinfo.hussar.formdesign.base.common.utils.AsyncActionUtil;
import com.jxdinfo.hussar.formdesign.base.common.utils.MultilineExegesisUtil;
import com.jxdinfo.hussar.formdesign.common.ctx.Ctx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.Action;
import com.jxdinfo.hussar.formdesign.common.render.RenderCore;
import com.jxdinfo.hussar.formdesign.common.render.RenderResult;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.visitor.ActionVisitor;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="Base.ApiInvokeAction")
public class ApiInvokeService
implements ActionVisitor {
    private static final String API_INVOKE_TFL_PATH = "/template/common/event/ApiInvoke.ftl";
    @Autowired
    private FileMappingService fileMappingService;

    public void visitor(Action action, Ctx ctx) throws Exception {
        List<ApiActionModel> apiActionModels = ApiInvokeFactory.getApiAction(action);
        for (ApiActionModel apiActionModel : apiActionModels) {
            JSONObject object = DataModelUtil.getDataModelJson((String)apiActionModel.getModelId());
            String dataSourceName = (String)object.get((Object)"dataSourceName");
            WebTemplateParam webTemplateParam = null;
            String name = "";
            if (HussarUtils.equals((Object)dataSourceName, (Object)"APP")) {
                webTemplateParam = this.buildAppTemplateParam(ctx, apiActionModel, object);
                name = (String)object.get((Object)"name");
            } else {
                ApiDataModel apiDataModel = (ApiDataModel)DataModelUtil.getDataModelObject((String)apiActionModel.getModelId(), ApiDataModel.class);
                webTemplateParam = this.buildWebTemplateParam(ctx, apiActionModel, apiDataModel);
                name = apiDataModel.getName();
            }
            String trigger = action.getTrigger();
            String triggerName = action.getCurrentLcdpComponent().getInstanceKey() + ToolUtil.firstLetterToUpper((String)trigger);
            List bodies = action.getBodies();
            RenderResult renderResult = this.render(action, webTemplateParam, AsyncActionUtil.getAsyncBodyCode(bodies));
            if (renderResult.isStatus()) {
                ctx.addMethod(trigger, triggerName, renderResult.getRenderString());
            }
            ctx.addImports("*", name, this.fileMappingService.getImportPath((String)object.get((Object)"id")));
        }
    }

    private RenderResult render(Action action, WebTemplateParam webTemplateParam, String bodies) throws LcdpException {
        RenderCore renderCore = new RenderCore();
        renderCore.registerTemplatePath(API_INVOKE_TFL_PATH);
        HashMap<String, Object> map = new HashMap<String, Object>(webTemplateParam.toMap());
        map.put("asyncBodyCode", bodies);
        map.put("exegesisResult", MultilineExegesisUtil.handleActionExegesisText(action));
        renderCore.registerParam(map);
        return renderCore.render();
    }

    private WebTemplateParam buildWebTemplateParam(Ctx ctx, ApiActionModel apiActionModel, ApiDataModel apiDataModel) throws LcdpException {
        ApiInvoke apiInvoke = new ApiInvoke(ctx, apiDataModel, apiActionModel);
        return apiInvoke.buildWebParam();
    }

    private WebTemplateParam buildAppTemplateParam(Ctx ctx, ApiActionModel apiActionModel, JSONObject object) throws LcdpException {
        ApiInvoke apiInvoke = new ApiInvoke(apiActionModel, ctx, object);
        return apiInvoke.buildAppParam();
    }
}

