/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.base.common.utils;

import com.jxdinfo.hussar.formdesign.back.adapter.ModelProvideAdapter;
import com.jxdinfo.hussar.formdesign.back.model.dataset.DataSet;
import com.jxdinfo.hussar.formdesign.back.model.dataset.DataSetObject;
import com.jxdinfo.hussar.formdesign.back.model.dataset.ValueObjectProperty;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.data.structure.publish.model.DataStructure;
import com.jxdinfo.hussar.formdesign.data.structure.publish.model.DataStructureProperty;
import com.jxdinfo.hussar.formdesign.data.structure.util.DataStructureUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AnalyzeLogicTypeUtil {
    private static final String LOGIC_LIST = "list";
    private static final String LOGIC_MAP = "map";
    private static final String LOGIC_STRING = "string";
    private static final String LOGIC_BOOLEAN = "boolean";
    private static final String LOGIC_INT = "int";
    private static final String LOGIC_LONG = "long";
    private static final String LOGIC_DATE = "date";
    private static final String LOGIC_DOUBLE = "double";
    private static final String LOGIC_MODEL = "model";
    private static final String LOGIC_STRUCT = "struct";
    private static final String LOGIC_CLASS = "class";
    private static final String LOGIC_PAGE = "Page";
    private static final String LOGIC_APIRESPONSE = "ApiResponse";
    private static final String LOGIC_ORDERITEM = "OrderItem";

    public static Map<String, String> analyzeLogicType(List<String> quote) {
        Map<String, String> mapCtx = new HashMap<String, String>();
        if (ToolUtil.isNotEmpty(quote)) {
            if (AnalyzeLogicTypeUtil.judgmentType(quote.get(0))) {
                return mapCtx;
            }
            switch (quote.get(0)) {
                case "list": {
                    if (AnalyzeLogicTypeUtil.judgmentType(quote.get(0))) {
                        return mapCtx;
                    }
                    mapCtx = AnalyzeLogicTypeUtil.analyzeQuoteType(quote.get(1), mapCtx);
                    break;
                }
                case "map": {
                    break;
                }
                default: {
                    mapCtx = AnalyzeLogicTypeUtil.analyzeQuoteType(quote.get(0), mapCtx);
                }
            }
        }
        return mapCtx;
    }

    private static boolean judgmentType(String type) {
        if (ToolUtil.isNotEmpty((Object)type)) {
            switch (type) {
                case "string": 
                case "boolean": 
                case "int": 
                case "long": 
                case "date": 
                case "double": {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private static Map<String, String> analyzeQuoteType(String logicType, Map<String, String> mapCtx) {
        Map<String, String> map = new HashMap<String, String>();
        if (ToolUtil.isNotEmpty((Object)logicType)) {
            String[] logicTypes = logicType.split(":", 2);
            try {
                switch (logicTypes[0]) {
                    case "model": {
                        map = AnalyzeLogicTypeUtil.analyzeModel(logicType);
                        break;
                    }
                    case "struct": {
                        map = AnalyzeLogicTypeUtil.analyzeStruct(logicType, mapCtx);
                        break;
                    }
                    case "class": {
                        map = AnalyzeLogicTypeUtil.analyzeClass(logicType);
                        break;
                    }
                }
            }
            catch (LcdpException | IOException | CloneNotSupportedException e) {
                e.printStackTrace();
            }
        }
        return map;
    }

    private static Map<String, String> analyzeModel(String logicType) throws LcdpException, IOException, CloneNotSupportedException {
        String[] modelSplit = logicType.split(":", 3);
        return ModelProvideAdapter.adaptor((String)modelSplit[1]).getAnalyzeModel(modelSplit[1], modelSplit[2]);
    }

    private static Map<String, String> analyzeStruct(String logicType, Map<String, String> mapCtx) {
        String[] structSplit = logicType.split(":", 2);
        if (structSplit.length == 2 && LOGIC_STRUCT.equals(structSplit[0])) {
            String id = structSplit[1];
            DataStructure dataStructure = DataStructureUtil.getDataStructure((String)id);
            if (HussarUtils.isEmpty((Object)dataStructure)) {
                return mapCtx;
            }
            for (DataStructureProperty property : dataStructure.getDataSetObject().getProperties()) {
                mapCtx.put(property.getId(), property.getName());
            }
        }
        return mapCtx;
    }

    private static Map<String, String> analyzeClass(String logicType) {
        HashMap<String, String> map = new HashMap<String, String>();
        String[] structSplit = logicType.split(":", 2);
        String[] baseClass = structSplit[1].split("\\.");
        String baseClassType = baseClass[baseClass.length - 1];
        if (LOGIC_CLASS.equals(structSplit[0])) {
            if (LOGIC_PAGE.equals(baseClassType)) {
                map.put("records", "records");
                map.put("total", "total");
                map.put("size", "size");
                map.put("current", "current");
                map.put("orders", "orders");
                map.put("optimizeCountSql", "optimizeCountSql");
                map.put("searchCount", "searchCount");
                map.put("optimizeJoinOfCountSql", "optimizeJoinOfCountSql");
                map.put("countId", "countId");
                map.put("maxLimit", "maxLimit");
            } else if (LOGIC_APIRESPONSE.equals(baseClassType)) {
                map.put("code", "code");
                map.put("success", "success");
                map.put("data", "data");
                map.put("msg", "msg");
            } else if (LOGIC_ORDERITEM.equals(baseClassType)) {
                map.put("column", "column");
                map.put("asc", "asc");
            }
        }
        return map;
    }

    public static String getLogicReturnValueToFront(List<String> quote, List<String> dataItems) {
        String returnValue = "";
        if (ToolUtil.isNotEmpty(quote)) {
            if (AnalyzeLogicTypeUtil.judgmentType(quote.get(0))) {
                return returnValue;
            }
            switch (quote.get(0)) {
                case "list": {
                    if (AnalyzeLogicTypeUtil.judgmentType(quote.get(0))) {
                        return returnValue;
                    }
                    returnValue = AnalyzeLogicTypeUtil.analyzeReturnQuoteType(quote.get(1), dataItems);
                    break;
                }
                case "map": {
                    break;
                }
                default: {
                    returnValue = AnalyzeLogicTypeUtil.analyzeReturnQuoteType(quote.get(0), dataItems);
                }
            }
        }
        return returnValue;
    }

    private static String analyzeReturnQuoteType(String logicType, List<String> dataItems) {
        String returnValue = "";
        if (ToolUtil.isNotEmpty((Object)logicType)) {
            String[] logicTypes = logicType.split(":", 2);
            try {
                switch (logicTypes[0]) {
                    case "model": {
                        returnValue = AnalyzeLogicTypeUtil.analyzeModelReturn(logicType, dataItems);
                        break;
                    }
                    case "struct": {
                        returnValue = AnalyzeLogicTypeUtil.analyzeStructReturn(logicType, dataItems);
                        break;
                    }
                    case "class": {
                        returnValue = AnalyzeLogicTypeUtil.analyzeClassReturn(logicType, dataItems);
                        break;
                    }
                }
            }
            catch (LcdpException | IOException | CloneNotSupportedException e) {
                e.printStackTrace();
            }
        }
        return returnValue;
    }

    private static String analyzeModelReturn(String logicType, List<String> dataItems) throws LcdpException, IOException, CloneNotSupportedException {
        String[] modelSplit = logicType.split(":", 3);
        DataSet dataSet = ModelProvideAdapter.adaptor((String)modelSplit[1]).getModelToDataSet(modelSplit[1], modelSplit[2]);
        DataSetObject dataSetObject = dataSet.getDataSetObject();
        List properties = dataSetObject.getProperties();
        return AnalyzeLogicTypeUtil.getDataItemName(dataItems, properties, 1);
    }

    private static String getDataItemName(List<String> dataItems, List<ValueObjectProperty> properties, int index) {
        if (ToolUtil.isNotEmpty(dataItems) && dataItems.size() >= index) {
            String key = dataItems.get(index);
            for (ValueObjectProperty property : properties) {
                if (!ToolUtil.isNotEmpty((Object)property) || !key.equals(property.getId())) continue;
                if (index == dataItems.size() - 1) {
                    return property.getName();
                }
                return property.getName() + "." + AnalyzeLogicTypeUtil.getDataItemName(dataItems, property.getProperties(), ++index);
            }
        }
        return "";
    }

    private static String analyzeStructReturn(String logicType, List<String> dataItems) {
        String[] modelSplit = logicType.split(":");
        if (HussarUtils.isEmpty(dataItems)) {
            return null;
        }
        if (modelSplit.length == 2 && HussarUtils.equals((Object)LOGIC_STRUCT, (Object)modelSplit[0]) && dataItems.size() >= 2) {
            String id = modelSplit[1];
            return AnalyzeLogicTypeUtil.getStructName(id, 1, dataItems);
        }
        return "";
    }

    private static String getStructName(String id, int index, List<String> dataItems) {
        if (index > dataItems.size()) {
            return "";
        }
        DataStructure dataStructure = DataStructureUtil.getDataStructure((String)id);
        List properties = dataStructure.getDataSetObject().getProperties();
        for (DataStructureProperty property : properties) {
            if (!HussarUtils.equals((Object)property.getId(), (Object)dataItems.get(index))) continue;
            if (index == dataItems.size() - 1) {
                return property.getName();
            }
            return property.getName() + "." + AnalyzeLogicTypeUtil.getStructName(property.getReference(), ++index, dataItems);
        }
        return "";
    }

    private static String analyzeClassReturn(String logicType, List<String> dataItems) {
        String[] modelSplit = logicType.split(":");
        return dataItems.get(1);
    }

    public static Map<String, String> getReturnValueMapping(List<String> quote, List<String> dataItems) throws IOException, LcdpException, CloneNotSupportedException {
        Map<String, String> returnMap = new HashMap<String, String>();
        if (ToolUtil.isNotEmpty(quote)) {
            if (AnalyzeLogicTypeUtil.judgmentType(quote.get(0))) {
                return returnMap;
            }
            block4 : switch (quote.get(0)) {
                case "list": {
                    if (AnalyzeLogicTypeUtil.judgmentType(quote.get(0))) {
                        return returnMap;
                    }
                    returnMap = AnalyzeLogicTypeUtil.analyzeReturnType(quote.get(1), dataItems, returnMap);
                    break;
                }
                case "map": {
                    break;
                }
                default: {
                    for (String s : quote) {
                        String[] logicTypes = s.split(":", 2);
                        if (LOGIC_CLASS.equals(logicTypes[0])) {
                            returnMap = AnalyzeLogicTypeUtil.analyzeReturnClass(quote, dataItems);
                            break block4;
                        }
                        returnMap = AnalyzeLogicTypeUtil.analyzeReturnType(quote.get(0), dataItems, returnMap);
                    }
                }
            }
        }
        return returnMap;
    }

    private static Map<String, String> analyzeReturnType(String logicType, List<String> dataItems, Map<String, String> returnMap) {
        Map<String, String> map = new HashMap<String, String>();
        if (ToolUtil.isNotEmpty((Object)logicType)) {
            String[] logicTypes = logicType.split(":", 2);
            try {
                switch (logicTypes[0]) {
                    case "model": {
                        map = AnalyzeLogicTypeUtil.analyzeReturnModel(logicType, dataItems);
                        break;
                    }
                    case "struct": {
                        map = AnalyzeLogicTypeUtil.analyzeReturnSturct(logicType, dataItems, returnMap);
                        break;
                    }
                }
            }
            catch (LcdpException | IOException | CloneNotSupportedException e) {
                e.printStackTrace();
            }
        }
        return map;
    }

    private static Map<String, String> analyzeReturnModel(String logicType, List<String> dataItems) throws LcdpException, IOException, CloneNotSupportedException {
        String[] modelSplit = logicType.split(":", 3);
        DataSet dataSet = ModelProvideAdapter.adaptor((String)modelSplit[1]).getModelToDataSet(modelSplit[1], modelSplit[2]);
        DataSetObject dataSetObject = dataSet.getDataSetObject();
        List properties = dataSetObject.getProperties();
        if (dataItems.size() == 1) {
            HashMap<String, String> map = new HashMap<String, String>();
            for (ValueObjectProperty property : properties) {
                map.put(property.getId(), property.getName());
            }
            return map;
        }
        return AnalyzeLogicTypeUtil.getDataItemMap(properties, dataItems, 1);
    }

    private static Map<String, String> getDataItemMap(List<ValueObjectProperty> properties, List<String> dataItems, int index) {
        if (ToolUtil.isNotEmpty(dataItems) && dataItems.size() >= index && dataItems.size() != 1) {
            String key = dataItems.get(index);
            for (ValueObjectProperty property : properties) {
                if (!ToolUtil.isNotEmpty((Object)property) || !key.equals(property.getId())) continue;
                if (index == dataItems.size() - 1) {
                    List propertyProperties = property.getProperties();
                    HashMap<String, String> map = new HashMap<String, String>();
                    for (ValueObjectProperty propertyProperty : propertyProperties) {
                        map.put(propertyProperty.getId(), propertyProperty.getName());
                    }
                    return map;
                }
                return AnalyzeLogicTypeUtil.getDataItemMap(property.getProperties(), dataItems, ++index);
            }
        }
        return new HashMap<String, String>();
    }

    private static Map<String, String> analyzeReturnSturct(String logicType, List<String> dataItems, Map<String, String> returnMap) {
        String[] sturctSplit = logicType.split(":");
        if (sturctSplit.length == 2 && HussarUtils.equals((Object)LOGIC_STRUCT, (Object)sturctSplit[0])) {
            String id = sturctSplit[1];
            return AnalyzeLogicTypeUtil.setStructMap(id, 1, dataItems, returnMap);
        }
        return returnMap;
    }

    private static Map<String, String> setStructMap(String id, int index, List<String> dataItems, Map<String, String> returnMap) {
        DataStructure dataStructure = DataStructureUtil.getDataStructure((String)id);
        List properties = dataStructure.getDataSetObject().getProperties();
        if (index == dataItems.size()) {
            for (DataStructureProperty property : properties) {
                returnMap.put(property.getId(), property.getName());
            }
            return returnMap;
        }
        for (DataStructureProperty property : properties) {
            if (!HussarUtils.equals((Object)property.getId(), (Object)dataItems.get(index))) continue;
            return AnalyzeLogicTypeUtil.setStructMap(property.getReference(), ++index, dataItems, returnMap);
        }
        return returnMap;
    }

    private static Map<String, String> analyzeReturnClass(List quote, List<String> dataItems) throws IOException, LcdpException, CloneNotSupportedException {
        Map<Object, Object> map = new HashMap();
        String typeDescription = (String)quote.get(1);
        String[] type = typeDescription.split(":");
        if (LOGIC_MODEL.equals(type[0])) {
            map = AnalyzeLogicTypeUtil.analyzeModel(typeDescription);
        } else if (LOGIC_STRUCT.equals(type[0])) {
            map = AnalyzeLogicTypeUtil.analyzeStruct(typeDescription, map);
        }
        return map;
    }
}

