/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.base.common.event;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.base.common.utils.AnalyzeLogicTypeUtil;
import com.jxdinfo.hussar.formdesign.base.common.utils.AsyncActionUtil;
import com.jxdinfo.hussar.formdesign.base.common.utils.MappingUtils;
import com.jxdinfo.hussar.formdesign.base.common.utils.MultilineExegesisUtil;
import com.jxdinfo.hussar.formdesign.codegenerator.core.data.mapping.DataItemMappingBO;
import com.jxdinfo.hussar.formdesign.codegenerator.core.data.model.ComponentReference;
import com.jxdinfo.hussar.formdesign.codegenerator.core.util.DataConfigUtil;
import com.jxdinfo.hussar.formdesign.common.ctx.Ctx;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.Action;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ComponentData;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.visitor.ActionVisitor;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="Base.LogicInvokeAction")
public class LogicInvoke
implements ActionVisitor {
    @Autowired
    private FileMappingService fileMappingService;
    private static final String MAPPING_KEY = "mapping";

    public void visitor(Action action, Ctx ctx) throws Exception {
        HashMap<String, Object> templateParamMap = new HashMap<String, Object>();
        String trigger = action.getTrigger();
        String triggerName = action.getCurrentLcdpComponent().getInstanceKey() + ToolUtil.firstLetterToUpper((String)trigger);
        Map allParams = action.getParamValues();
        JSONObject logicInvokeParam = (JSONObject)allParams.get("LogicInvoke");
        if (ToolUtil.isEmpty((Object)logicInvokeParam)) {
            return;
        }
        String assetsId = logicInvokeParam.getString("assetsId");
        JSONObject logicFile = this.fileMappingService.getJsonObjectById(assetsId);
        String assetsName = logicFile.getString("name");
        JSONArray params = logicFile.getJSONArray("params");
        JSONArray paramConfigs = logicInvokeParam.getJSONArray("paramConfigs");
        ArrayList inputMapping = new ArrayList();
        for (Object paramConfig : paramConfigs) {
            JSONArray mapping;
            JSONObject paramConfigObj = (JSONObject)paramConfig;
            ComponentReference paramFrom = (ComponentReference)JSON.parseObject((String)paramConfigObj.getString("componentReference"), ComponentReference.class);
            ComponentData fromComponentData = DataConfigUtil.getDataConfigValue((Ctx)ctx, (ComponentReference)paramFrom);
            JSONObject param = this.getParamById(paramConfigObj.getString("currentData"), params);
            if (ToolUtil.isEmpty((Object)fromComponentData) || ToolUtil.isEmpty((Object)param)) continue;
            String currentName = param.getString("name");
            String currentDataType = paramConfigObj.getString("currentDataType");
            JSONArray paramsType = param.getJSONArray("type");
            List quote = JSON.parseArray((String)Optional.ofNullable(paramsType.toString()).orElseThrow(NullPointerException::new), String.class);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("currentName", currentName);
            map.put("fromComponentData", fromComponentData.getRenderValue());
            if (("array".equals(currentDataType) || "object".equals(currentDataType)) && ToolUtil.isNotEmpty((Object)(mapping = paramConfigObj.getJSONArray(MAPPING_KEY)))) {
                map.put("currentDataType", paramConfigObj.getString("currentDataType"));
                List mapsList = mapping.toJavaList(DataItemMappingBO.class);
                Map<String, String> componentId2JsVariable = MappingUtils.getFieldMapping(paramFrom, ctx);
                Map<String, String> toMapping = AnalyzeLogicTypeUtil.analyzeLogicType(quote);
                List<DataItemMappingBO<String>> dataItemMappingBOS = MappingUtils.getDataItemMappingBOS(mapsList, componentId2JsVariable, toMapping);
                map.put(MAPPING_KEY, dataItemMappingBOS);
            }
            inputMapping.add(map);
        }
        templateParamMap.put("inputMapping", inputMapping);
        templateParamMap.put("apiName", assetsName);
        templateParamMap.put("operation", "invoke" + StringUtil.firstCharToUpper((String)assetsName));
        templateParamMap.put("actionName", assetsName + templateParamMap.get("operation"));
        List bodies = action.getBodies();
        templateParamMap.put("asyncBodyCode", AsyncActionUtil.getAsyncBodyCode(bodies));
        templateParamMap.put("exegesisResult", MultilineExegesisUtil.handleActionExegesisText(action));
        ctx.addMethod(triggerName, RenderUtil.renderTemplate((String)"/template/common/event/LogicInvoke.ftl", templateParamMap));
        ctx.addImports("*", assetsName, this.fileMappingService.getLogicImportPath(assetsId));
    }

    private JSONObject getParamById(String paramId, JSONArray params) {
        for (Object param : params) {
            JSONObject paramObj = (JSONObject)param;
            if (!paramId.equals(paramObj.getString("id"))) continue;
            return paramObj;
        }
        return null;
    }
}

