/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.base.config.controller;

import com.jxdinfo.hussar.core.util.LicenseInfo;
import com.jxdinfo.hussar.formdesign.base.config.service.FlowAuthConfigService;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/flowAuth"})
public class FlowAuthConfigController {
    @Autowired
    private FlowAuthConfigService flowAuthConfigService;

    @PostMapping(value={"/getAllAuthConfigs"})
    public Map<String, Object> getAllAuthConfigs(@RequestBody Map<String, Object> map) throws LcdpException {
        String formName = (String)map.get("formName");
        String processKey = (String)map.get("processKey");
        String formType = (String)map.get("formType");
        String taskDefinitionKey = (String)map.get("taskDefinitionKey");
        String formState = (String)map.get("formState");
        Integer version = (Integer)map.get("version");
        String taskId = (String)map.get("taskId");
        try {
            List allConfigs = new ArrayList();
            if (ToolUtil.isNotEmpty((Object)formName) && ToolUtil.isNotEmpty((Object)processKey)) {
                allConfigs = (List)AppContextUtil.computeInAppDs(() -> this.flowAuthConfigService.getAllAuthConfigs(formName, processKey, formType, taskDefinitionKey, formState, version, taskId));
            }
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("data", allConfigs);
            return result;
        }
        catch (AppContextUtil.AppDsExecutionTargetException e) {
            e.printStackTrace();
            Throwable cause = e.getCause();
            if (cause instanceof LcdpException) {
                throw (LcdpException)cause;
            }
            throw e;
        }
    }

    @PostMapping(value={"/saveAuthConfigs"})
    public FormDesignResponse<Void> saveAuthConfigs(@RequestBody Map<String, Object> paramMap) throws LcdpException {
        try {
            return (FormDesignResponse)AppContextUtil.computeInAppDs(() -> this.flowAuthConfigService.saveAuthConfigs(paramMap));
        }
        catch (AppContextUtil.AppDsExecutionTargetException e) {
            e.printStackTrace();
            Throwable cause = e.getCause();
            if (cause instanceof LcdpException) {
                throw (LcdpException)cause;
            }
            throw e;
        }
    }

    @PostMapping(value={"/getAllAuthConfigsWithFormId"})
    public Map<String, Object> getAllAuthConfigsByFormId(@RequestBody Map<String, String> map) throws LcdpException {
        try {
            List allConfigs = new ArrayList();
            if (ToolUtil.isNotEmpty((Object)map.get("formId")) && ToolUtil.isNotEmpty((Object)map.get("processKey"))) {
                allConfigs = (List)AppContextUtil.computeInAppDs(() -> this.flowAuthConfigService.getAllAuthConfigsByFormId((String)map.get("formId"), (String)map.get("processKey"), (String)map.get("formType"), (String)map.get("taskDefinitionKey"), (String)map.get("formState")));
            }
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("data", allConfigs);
            return result;
        }
        catch (AppContextUtil.AppDsExecutionTargetException e) {
            e.printStackTrace();
            Throwable cause = e.getCause();
            if (cause instanceof LcdpException) {
                throw (LcdpException)cause;
            }
            throw e;
        }
    }

    @RequestMapping(value={"/isProductionMode"})
    public ApiResponse<?> isProductionMode() {
        return ApiResponse.success((String)String.valueOf(LicenseInfo.getLicenseType()));
    }
}

