/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.base.common.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.defaultvalue.DefaultValueAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.utils.MultilineExegesisUtil;
import com.jxdinfo.hussar.formdesign.codegenerator.core.data.constant.DataFromEnum;
import com.jxdinfo.hussar.formdesign.codegenerator.core.data.model.ComponentReference;
import com.jxdinfo.hussar.formdesign.codegenerator.core.util.DataConfigUtil;
import com.jxdinfo.hussar.formdesign.codegenerator.core.util.ExtendFormulaUtil;
import com.jxdinfo.hussar.formdesign.common.ctx.Ctx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ComponentData;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.LcdpComponent;
import com.jxdinfo.hussar.formdesign.common.properties.DataTypeProperties;
import com.jxdinfo.hussar.formdesign.common.properties.EnvVarsProperties;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.extend.model.formula.ExtendFormulaCompileInfo;
import com.jxdinfo.hussar.formdesign.extend.model.formula.ExtendFormulaInfo;
import java.util.Map;

public class DefaultValueUtil {
    private static final DataTypeProperties dataTypeProperties = (DataTypeProperties)SpringUtil.getBean(DataTypeProperties.class);
    private static final EnvVarsProperties envVarsProperties = (EnvVarsProperties)SpringUtil.getBean(EnvVarsProperties.class);

    public static String renderDefaultValue(DefaultValueAnalysis defaultValueAnalysis, String dataType, Ctx ctx) throws LcdpException {
        ComponentReference from;
        ComponentData dataConfigValue;
        String result = "''";
        if (ToolUtil.isNotEmpty((Object)defaultValueAnalysis) && defaultValueAnalysis.isDefaultValue() && ToolUtil.isNotEmpty((Object)(dataConfigValue = DataConfigUtil.getDataConfigValue((Ctx)ctx, (ComponentReference)(from = defaultValueAnalysis.getFrom()))))) {
            return dataConfigValue.getRenderValue();
        }
        return result;
    }

    public static void renderDefaultValueInput(LcdpComponent lcdpComponent, Ctx ctx, String suffix, JSONObject defaultValueAnalysis) throws LcdpException {
        boolean isDefaultValue;
        Object result = "''";
        if (ToolUtil.isNotEmpty((Object)defaultValueAnalysis) && (isDefaultValue = ((Boolean)defaultValueAnalysis.get((Object)"isDefaultValue")).booleanValue())) {
            String defaultValueType = (String)defaultValueAnalysis.get((Object)"defaultValueType");
            String defaultValue = defaultValueAnalysis.get((Object)"value").toString();
            if (ToolUtil.isNotEmpty((Object)defaultValueType)) {
                if (DataFromEnum.INPUT.getValue().equals(defaultValueType)) {
                    result = "com.jxdinfo.elementui.JXDElCheckBox".equals(lcdpComponent.getName()) && ("true".equals(defaultValue) || "false".equals(defaultValue)) ? Boolean.valueOf(Boolean.parseBoolean(defaultValue)) : "'" + defaultValue + "'";
                } else if (DataFromEnum.SESSION.getValue().equals(defaultValueType)) {
                    Map sessionConfig = envVarsProperties.getSession();
                    ComponentReference componentReference = (ComponentReference)JSON.parseObject((String)defaultValue, ComponentReference.class);
                    String configData = componentReference.getConfigData();
                    String item = ToolUtil.isNotEmpty((Object)configData) ? (String)sessionConfig.get(configData) : (String)sessionConfig.get(defaultValue);
                    if (ToolUtil.isNotEmpty((Object)item)) {
                        result = "caching.session.get(" + item + ")";
                        ctx.addImports("caching", "hussar-base");
                    }
                } else if (DataFromEnum.SYSTEM.getValue().equals(defaultValueType)) {
                    if (DataFromEnum.YEAR.getValue().equals(defaultValue)) {
                        result = "formatDate(new Date(),'year')";
                    } else if (DataFromEnum.MONTH.getValue().equals(defaultValue)) {
                        result = "formatDate(new Date(),'month')";
                    } else if (DataFromEnum.DATE.getValue().equals(defaultValue)) {
                        result = "formatDate(new Date(),'date')";
                    } else if (DataFromEnum.TIME.getValue().equals(defaultValue)) {
                        result = "formatDate(new Date(),'time')";
                    } else if (DataFromEnum.DATETIME.getValue().equals(defaultValue)) {
                        result = "formatDate(new Date(),'datetime')";
                    }
                    ctx.addImports("dateFormatPublic", "@/pages/index/utils/lowcode/dateFormatUtil");
                    if (!ctx.getMethods().containsKey("format")) {
                        ctx.addImports("dateFormatPublic", "@/pages/index/utils/lowcode/dateFormatUtil");
                    }
                } else if (DataFromEnum.EXTEND_FORMULA.getValue().equals(defaultValueType)) {
                    ExtendFormulaInfo formulaInfo = (ExtendFormulaInfo)JSON.parseObject((String)defaultValue, ExtendFormulaInfo.class);
                    try {
                        ExtendFormulaCompileInfo compileInfo = ExtendFormulaUtil.getFormulaCompile((ExtendFormulaInfo)formulaInfo, (Ctx)ctx);
                        if (ToolUtil.isNotEmpty((Object)compileInfo)) {
                            result = compileInfo.getFormulaStr();
                        }
                    }
                    catch (LcdpException e) {
                        e.printStackTrace();
                    }
                } else if (DataFromEnum.CONSTANT.getValue().equals(defaultValueType) || DataFromEnum.PAGE_PARAM.getValue().equals(defaultValueType)) {
                    ComponentReference componentReference = (ComponentReference)JSON.parseObject((String)defaultValue, ComponentReference.class);
                    ComponentData dataConfigValue = DataConfigUtil.getDataConfigValue((Ctx)ctx, (ComponentReference)componentReference);
                    result = dataConfigValue.getRenderValue();
                }
            }
        }
        ctx.addData(lcdpComponent.getInstanceKey() + suffix + ": " + result, MultilineExegesisUtil.dealDataExegesis(lcdpComponent, "data\u53d8\u91cf"));
    }
}

