/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.base.common.event;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.formdesign.back.adapter.ModelProvideAdapter;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.datas.DataSAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.datas.DataSModelAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.utils.MultilineExegesisUtil;
import com.jxdinfo.hussar.formdesign.common.ctx.Ctx;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.Action;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.LcdpComponent;
import com.jxdinfo.hussar.formdesign.common.render.RenderCore;
import com.jxdinfo.hussar.formdesign.common.render.RenderResult;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.visitor.ActionVisitor;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="Base.CheckFlowchartAction")
public class CheckFlowchart
implements ActionVisitor {
    private static final Logger logger = LoggerFactory.getLogger(CheckFlowchart.class);

    public void visitor(Action action, Ctx ctx) throws Exception {
        HashMap<String, Object> moduleMap = new HashMap<String, Object>();
        moduleMap.put("strategy", ctx.getStrategy());
        RenderCore renderCore = new RenderCore();
        Map params = action.getParamValues();
        if (ToolUtil.isEmpty((Object)params)) {
            logger.error("\u5f53\u524d\u52a8\u4f5c\u914d\u7f6e\u9519\u8bef!");
            return;
        }
        String componentSelected = String.valueOf(params.get("componentSelected"));
        if (ToolUtil.isEmpty((Object)componentSelected) && ToolUtil.isEmpty(params.get("workflowSelected"))) {
            logger.error("\u5f53\u524d\u52a8\u4f5c\u672a\u9009\u4e2d\u6570\u636e\u8868\u683c\u6216\u8868\u5355\u5e76\u4e14\u672a\u9009\u4e2d\u5de5\u4f5c\u6d41!");
            return;
        }
        LcdpComponent tableComponent = (LcdpComponent)ctx.getComponentMap().get(componentSelected);
        String dataType = "";
        dataType = ToolUtil.isEmpty((Object)tableComponent) || StringUtil.containsIgnoreCase((CharSequence)tableComponent.getName(), (CharSequence)"Form") ? "isForm" : "isTable";
        renderCore.registerTemplatePath("template/common/event/CheckFlowchart.ftl");
        LcdpComponent myLcdpComponent = action.getCurrentLcdpComponent();
        String trigger = action.getTrigger();
        String triggerName = myLcdpComponent.getInstanceKey() + ToolUtil.firstLetterToUpper((String)trigger);
        moduleMap.put("trigger", triggerName);
        ctx.addImports("flowchart", "BpmShowWorkflow");
        String rootKey = ctx.getRootLcdpComponent().getInstanceKey();
        LcdpComponent rootComponent = (LcdpComponent)ctx.getComponentMap().get(rootKey);
        String workFlow = (String)params.get("workflowSelected");
        if (ToolUtil.isNotEmpty((Object)workFlow)) {
            moduleMap.put("showProcessKey", workFlow);
        }
        ctx.addData(rootKey + "ProcessKey: ''", MultilineExegesisUtil.dealDataExegesis("\u9875\u9762", "\u6d41\u7a0b\u6807\u8bc6\u5c5e\u6027"));
        moduleMap.put(dataType, true);
        ctx.addComponent("flowchart");
        switch (dataType) {
            case "isForm": {
                rootComponent.addRenderParam("showFlowFile", (Object)true);
                rootComponent.addRenderParam("addFlowFileData", (Object)true);
                moduleMap.put("rootKey", rootKey);
                break;
            }
            case "isTable": {
                String formDataModelAnalysisId;
                String primaryFieldName = "";
                DataSAnalysis dataSanalysis = (DataSAnalysis)JSON.parseObject((String)JSON.toJSONString((Object)tableComponent.getDatas()), DataSAnalysis.class);
                DataSModelAnalysis dataSmodelAnalysis = dataSanalysis.getDatamodel();
                if (ToolUtil.isNotEmpty((Object)dataSmodelAnalysis) && ToolUtil.isNotEmpty((Object)(formDataModelAnalysisId = dataSmodelAnalysis.getDataModelId())) && ToolUtil.isNotEmpty((Object)DataModelUtil.getDataModelBase((String)formDataModelAnalysisId))) {
                    primaryFieldName = ModelProvideAdapter.adaptor((String)formDataModelAnalysisId).getPrimaryFieldName(formDataModelAnalysisId);
                }
                if (ToolUtil.isEmpty((Object)primaryFieldName)) {
                    logger.error("\u5f53\u524d\u9009\u4e2d\u6570\u636e\u8868\u683c\u672a\u914d\u7f6e\u4e3b\u952e!");
                    return;
                }
                rootComponent.addRenderParam("addFlowFileData", (Object)true);
                rootComponent.addRenderParam("showFlowFile", (Object)true);
                moduleMap.put("selectDomKey", componentSelected);
                moduleMap.put("selectDomId", primaryFieldName);
                moduleMap.put("showFlowId", rootKey);
                break;
            }
        }
        moduleMap.put("exegesisResult", MultilineExegesisUtil.handleActionExegesisText(action));
        renderCore.registerParam(moduleMap);
        RenderResult renderResult = renderCore.render();
        if (renderResult.isStatus()) {
            ctx.addMethod(triggerName, renderResult.getRenderString(), false);
        }
    }
}

