/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.base.common.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.codegenerator.core.data.model.ComponentReference;
import com.jxdinfo.hussar.formdesign.codegenerator.core.util.DataConfigUtil;
import com.jxdinfo.hussar.formdesign.common.ctx.Ctx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.Action;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ComponentData;
import com.jxdinfo.hussar.formdesign.common.render.RenderCore;
import com.jxdinfo.hussar.formdesign.common.render.RenderResult;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.GetAppInfoUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import java.util.HashMap;
import java.util.Map;

public class RenderRouterUtil {
    public static String renderRouterOfReturn(Action action, Ctx ctx, FileMappingService fileMappingService) throws LcdpException {
        Map params = action.getParamValues();
        HashMap<String, Object> moduleMap = new HashMap<String, Object>();
        String changePagePath = "";
        JSONObject pageRouter = (JSONObject)params.get("pageSelect");
        if (ToolUtil.isNotEmpty((Object)pageRouter) && ToolUtil.isNotEmpty((Object)pageRouter.get((Object)"pageType"))) {
            String jumpPage = "";
            if (ToolUtil.isNotEmpty((Object)pageRouter.get((Object)"id"))) {
                jumpPage = pageRouter.get((Object)"id").toString();
            }
            switch ((String)pageRouter.get((Object)"pageType")) {
                case "backlog": {
                    changePagePath = GetAppInfoUtil.getApplicationType() != false ? "/toDoListMaster" : "/toDoList";
                    break;
                }
                case "listPage": {
                    if (ToolUtil.isNotEmpty((Object)jumpPage)) {
                        changePagePath = FileUtil.posixPath((String[])new String[]{"${PREFIX.pathName}", fileMappingService.getFormatPath(jumpPage)});
                        ctx.addImports("PREFIX", "#/prefixCommon");
                        break;
                    }
                    changePagePath = "";
                }
            }
        }
        moduleMap.put("changePagePath", changePagePath);
        Boolean pageClose = Boolean.parseBoolean(params.get("pageClose") + "");
        moduleMap.put("pageCloseBoolean", pageClose);
        RenderCore renderCore = new RenderCore();
        renderCore.registerTemplatePath("/template/common/dataitem/render_router.ftl");
        renderCore.registerParam(moduleMap);
        RenderResult renderResult = renderCore.render();
        return renderResult.getRenderString();
    }

    public static String renderRouter(Action action, Ctx ctx, FileMappingService fileMappingService) throws LcdpException {
        Map params = action.getParamValues();
        HashMap<String, Object> moduleMap = new HashMap<String, Object>();
        String pagePath = "/auditLunch";
        moduleMap.put("pagePath", pagePath);
        Boolean pageClose = Boolean.parseBoolean(params.get("pageClose") + "");
        moduleMap.put("pageCloseBoolean", pageClose);
        Map addFlow = new HashMap();
        if (ToolUtil.isNotEmpty((Object)params) && ToolUtil.isNotEmpty(params.get("addFlow"))) {
            addFlow = (Map)params.get("addFlow");
        }
        if (ToolUtil.isNotEmpty(addFlow)) {
            String flowKey = (String)addFlow.get("identity");
            String workflowName = (String)addFlow.get("name");
            moduleMap.put("workflowName", workflowName);
            moduleMap.put("flowKey", flowKey);
        }
        RenderCore renderCore = new RenderCore();
        renderCore.registerTemplatePath("template/common/dataitem/render_form_router.ftl");
        renderCore.registerParam(moduleMap);
        RenderResult renderResult = renderCore.render();
        return renderResult.getRenderString();
    }

    public static String hussarRouter(Action action, Ctx ctx, FileMappingService fileMappingService, String params) throws LcdpException {
        Map<String, Object> config;
        String isReturnFrom;
        String isSaveFrom;
        String refresh;
        String router = "";
        HashMap<String, Object> routerParams = new HashMap<String, Object>();
        RenderCore renderCore = new RenderCore();
        Map actionParams = action.getParamValues();
        Map hyperlinksParams = (Map)actionParams.get("hyperlinksParams");
        if (ToolUtil.isEmpty((Object)hyperlinksParams)) {
            return null;
        }
        switch (refresh = hyperlinksParams.get("reFreshValue").toString()) {
            case "none": {
                refresh = "0";
                break;
            }
            case "localRefresh": {
                refresh = "1";
                break;
            }
            default: {
                refresh = "2";
            }
        }
        routerParams.put("refresh", refresh);
        String title = hyperlinksParams.get("title").toString();
        routerParams.put("tablePageTitle", title);
        Map addForm = (Map)hyperlinksParams.get("openPage");
        if (ToolUtil.isNotEmpty((Object)addForm)) {
            String path = "";
            if ("backlog".equals(addForm.get("pageType"))) {
                path = GetAppInfoUtil.getApplicationType() != false ? "/toDoListMaster" : "/toDoList";
            } else {
                String id = (String)addForm.get("id");
                if (ToolUtil.isNotEmpty((Object)id)) {
                    path = FileUtil.posixPath((String[])new String[]{"${PREFIX.pathName}", fileMappingService.getFormatPath(id)});
                    ctx.addImports("PREFIX", "#/prefixCommon");
                }
            }
            routerParams.put("path", path);
        }
        String openPosition = "inSystem".equals(hyperlinksParams.get("openPositionValue")) ? "1" : "2";
        routerParams.put("openPosition", openPosition);
        switch (isSaveFrom = hyperlinksParams.get("returnPageValue").toString()) {
            case "returnPageOfPage": {
                isSaveFrom = "2";
                break;
            }
            case "currentPage": {
                isSaveFrom = "1";
                break;
            }
            default: {
                isSaveFrom = "0";
            }
        }
        routerParams.put("isSaveFrom", isSaveFrom);
        String clearCache = "true".equals(hyperlinksParams.get("clearCache").toString()) ? "1" : "0";
        routerParams.put("clearCache", clearCache);
        String openType = "0";
        if ("currentTab".equals(hyperlinksParams.get("openModeValue").toString())) {
            openType = "1";
            routerParams.put("tabName", "''");
        } else if ("existedTab".equals(hyperlinksParams.get("openModeValue").toString())) {
            openType = "2";
            routerParams.put("tabName", "''");
        } else if ("tabName".equals(hyperlinksParams.get("openModeValue").toString())) {
            ComponentReference from = (ComponentReference)JSON.parseObject((String)hyperlinksParams.get("tabName").toString(), ComponentReference.class);
            ComponentData fromComponentData = DataConfigUtil.getDataConfigValue((Ctx)ctx, (ComponentReference)from);
            if (ToolUtil.isNotEmpty((Object)fromComponentData)) {
                if ("arrayPrimary".equals(fromComponentData.getDataType().getValue())) {
                    fromComponentData.setRenderValue(fromComponentData.getRenderValue() + ".join(',')");
                } else {
                    fromComponentData.setRenderValue(fromComponentData.getRenderValue() + ".toString()");
                }
                routerParams.put("tabName", fromComponentData.getRenderValue());
            } else {
                routerParams.put("tabName", "''");
            }
        } else if ("newTab".equals(hyperlinksParams.get("openModeValue").toString())) {
            routerParams.put("tabName", "uuid()");
        }
        ctx.addImports("v1 as uuid", "uuid");
        routerParams.put("openType", openType);
        String isClose = "true".equals(hyperlinksParams.get("closePage").toString()) ? "1" : "0";
        routerParams.put("isClose", isClose);
        switch (isReturnFrom = hyperlinksParams.get("returnTypeValue").toString()) {
            case "sourceTab": {
                isReturnFrom = "4";
                break;
            }
            case "page": {
                isReturnFrom = "3";
                break;
            }
            case "returnOpenPage": {
                isReturnFrom = "2";
                break;
            }
            case "returnPreviousTab": {
                isReturnFrom = "1";
                break;
            }
            default: {
                isReturnFrom = "0";
            }
        }
        routerParams.put("isReturnFrom", isReturnFrom);
        JSONObject paramsaa = (JSONObject)hyperlinksParams.get("selectParam");
        Map pageParamConfig = (Map)paramsaa.get((Object)"pageParamConfig");
        if (ToolUtil.isNotEmpty((Object)pageParamConfig) && (config = RenderRouterUtil.getRenderPageParamData(ctx, pageParamConfig)).size() > 0) {
            StringBuilder paramStr = new StringBuilder();
            Object[] keySet = config.keySet().toArray();
            for (int i = 0; i < keySet.length; ++i) {
                JSONObject ppcElement = (JSONObject)pageParamConfig.get(keySet[i]);
                if (i == keySet.length - 1) {
                    if (ppcElement.get((Object)"type").equals("input") || ppcElement.get((Object)"type").equals("constant")) {
                        paramStr.append(keySet[i] + "=" + config.get(keySet[i]).toString().replace("'", ""));
                        continue;
                    }
                    paramStr.append(keySet[i] + "=${" + config.get(keySet[i]) + "}");
                    continue;
                }
                if (ppcElement.get((Object)"type").equals("input") || ppcElement.get((Object)"type").equals("constant")) {
                    paramStr.append(keySet[i] + "=" + config.get(keySet[i]).toString().replace("'", "") + "&");
                    continue;
                }
                paramStr.append(keySet[i] + "=${" + config.get(keySet[i]) + "}&");
            }
            routerParams.put("params", config);
            routerParams.put("paramStr", paramStr);
        }
        if (params != null) {
            routerParams.put("eventParams", params);
        }
        renderCore.registerTemplatePath("/template/common/dataitem/hussarRouter.ftl");
        renderCore.registerParam(routerParams);
        RenderResult renderResult = renderCore.render();
        router = renderResult.getRenderString();
        return router;
    }

    private static Map<String, Object> getRenderPageParamData(Ctx ctx, Map<String, Object> pageParamConfig) throws LcdpException {
        HashMap<String, Object> paramConfig = new HashMap<String, Object>();
        for (String key : pageParamConfig.keySet()) {
            ComponentReference componentReference = (ComponentReference)JSON.parseObject((String)pageParamConfig.get(key).toString(), ComponentReference.class);
            ComponentData data = DataConfigUtil.getDataConfigValue((Ctx)ctx, (ComponentReference)componentReference);
            if (null != data) {
                paramConfig.put(key, data.getRenderValue());
                continue;
            }
            paramConfig.put(key, "''");
        }
        return paramConfig;
    }

    public static Map<String, Object> getIsClosePage(Action action) {
        Map params = action.getParamValues();
        HashMap<String, Object> moduleMap = new HashMap<String, Object>();
        Boolean pageClose = Boolean.parseBoolean(params.get("pageClose") + "");
        moduleMap.put("pageCloseBoolean", pageClose);
        return moduleMap;
    }
}

