/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.base.common.utils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.base.common.constant.CodeSuffix;
import com.jxdinfo.hussar.formdesign.codegenerator.core.data.constant.DataFromEnum;
import com.jxdinfo.hussar.formdesign.common.ctx.Ctx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.LcdpComponent;
import com.jxdinfo.hussar.formdesign.common.properties.EnvVarsProperties;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.visitor.BaseProvideVisitor;
import com.jxdinfo.hussar.formdesign.common.visitor.ValueVisitor;
import com.jxdinfo.hussar.formdesign.extend.model.formula.ExtendFormulaCompileInfo;
import com.jxdinfo.hussar.formdesign.extend.model.formula.ExtendFormulaCompileReferMethod;
import com.jxdinfo.hussar.formdesign.extend.model.formula.ExtendFormulaInfo;
import com.jxdinfo.hussar.formdesign.extend.model.formula.ExtendFormulaParam;
import com.jxdinfo.hussar.formdesign.extend.model.formula.ExtendFormulaReferMethod;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class ExtendFormulaUtil {
    private static final EnvVarsProperties envVarsProperties = (EnvVarsProperties)SpringUtil.getBean(EnvVarsProperties.class);

    public static ExtendFormulaCompileInfo getFormulaCompile(ExtendFormulaInfo formulaInfo, Ctx ctx) throws LcdpException {
        ExtendFormulaCompileInfo compileInfo = new ExtendFormulaCompileInfo();
        compileInfo.setFormulaId(formulaInfo.getFormulaId());
        String formulaStr = formulaInfo.getFormulaStr();
        if (formulaInfo.getFormulaParam() != null && formulaInfo.getFormulaParam().size() > 0) {
            for (ExtendFormulaParam param : formulaInfo.getFormulaParam()) {
                if (DataFromEnum.INSTANCE.getValue().equals(param.getType())) {
                    formulaStr = ExtendFormulaUtil.replaceInstanceStr(formulaStr, param, ctx);
                    continue;
                }
                if (DataFromEnum.SESSION.getValue().equals(param.getType())) {
                    if (!ToolUtil.isNotEmpty((Object)param.getConfigData())) continue;
                    Map sessionConfig = envVarsProperties.getSession();
                    String getSessionValue = "sessionStorage.getItem(" + (String)sessionConfig.get(param.getConfigData()) + ")";
                    formulaStr = formulaStr.replaceAll(param.getReplacedStr(), getSessionValue);
                    continue;
                }
                if (!DataFromEnum.PAGE_PARAM.getValue().equals(param.getType())) continue;
                String pageParam = "this.\\$route.query." + param.getConfigData();
                formulaStr = formulaStr.replaceAll(param.getReplacedStr(), pageParam);
            }
        }
        compileInfo.setFormulaStr(formulaStr);
        return compileInfo;
    }

    public static List<ExtendFormulaCompileInfo> getFormulaCompileList(List<ExtendFormulaInfo> formulaInfoList, Ctx ctx) throws LcdpException {
        ArrayList<ExtendFormulaCompileInfo> compileInfoList = new ArrayList<ExtendFormulaCompileInfo>();
        for (ExtendFormulaInfo formulaInfo : formulaInfoList) {
            compileInfoList.add(ExtendFormulaUtil.getFormulaCompile(formulaInfo, ctx));
        }
        return compileInfoList;
    }

    public static List<ExtendFormulaCompileReferMethod> getFormulaCompileReferJs(Ctx ctx) {
        Map componentMap = ctx.getComponentMap();
        List<ExtendFormulaCompileReferMethod> referMethods = new ArrayList<ExtendFormulaCompileReferMethod>();
        for (Map.Entry entry : componentMap.entrySet()) {
            LcdpComponent component = (LcdpComponent)entry.getValue();
            ExtendFormulaUtil.getDefaultValueFormulaPath(component, referMethods, ctx.getPageInfo().getType());
        }
        if (ToolUtil.isNotEmpty(referMethods)) {
            referMethods = ExtendFormulaUtil.mergeReferMethod(referMethods);
        }
        return referMethods;
    }

    private static String replaceInstanceStr(String formulaStr, ExtendFormulaParam param, Ctx ctx) throws LcdpException {
        String newFormulaStr = formulaStr;
        String instanceKey = param.getInstanceKey();
        List instanceData = param.getInstanceData();
        String instanceStr = null;
        if (ToolUtil.isNotEmpty((Object)instanceData)) {
            LcdpComponent bindComponent = (LcdpComponent)ctx.getComponentMap().get(instanceKey);
            if (ToolUtil.isEmpty((Object)bindComponent)) {
                instanceStr = instanceKey + CodeSuffix._DATA.getType();
            } else {
                ValueVisitor referVisitor = (ValueVisitor)bindComponent.getProvideVisitor("value");
                bindComponent.accept((BaseProvideVisitor)referVisitor, ctx, null);
                instanceStr = referVisitor.getDataItemValue(instanceData).getRenderValue();
            }
        }
        if (instanceStr != null) {
            newFormulaStr = formulaStr.replaceAll(param.getReplacedStr(), instanceStr);
        }
        return newFormulaStr;
    }

    private static List<ExtendFormulaCompileReferMethod> getImportPath(List<ExtendFormulaReferMethod> referMethods, String pageType) {
        ArrayList<ExtendFormulaCompileReferMethod> list = new ArrayList<ExtendFormulaCompileReferMethod>();
        HashMap fileMap = new HashMap();
        for (ExtendFormulaReferMethod extendFormulaReferMethod : referMethods) {
            String path = null;
            if ("WebPage".equals(pageType)) {
                path = extendFormulaReferMethod.getPath();
            } else if ("MobilePage".equals(pageType)) {
                path = extendFormulaReferMethod.getMobilePath();
            }
            if (ToolUtil.isEmpty((Object)extendFormulaReferMethod.getMethods()) || ToolUtil.isEmpty((Object)path)) continue;
            Set method = fileMap.containsKey(path) ? (Set)fileMap.get(path) : new HashSet();
            String methodStr = extendFormulaReferMethod.getMethods().replaceAll("\uff0c", ",");
            String[] methodArr = methodStr.split(",");
            method.addAll(Arrays.asList(methodArr));
            fileMap.put(path, method);
        }
        for (Map.Entry entry : fileMap.entrySet()) {
            ExtendFormulaCompileReferMethod referMethod = new ExtendFormulaCompileReferMethod();
            referMethod.setPath((String)entry.getKey());
            referMethod.setMethods(new ArrayList((Collection)entry.getValue()));
            list.add(referMethod);
        }
        return list;
    }

    private static List<ExtendFormulaCompileReferMethod> mergeReferMethod(List<ExtendFormulaCompileReferMethod> allMethod) {
        if (ToolUtil.isNotEmpty(allMethod)) {
            ArrayList<Map.Entry<String, List<Map.Entry>>> collect = new ArrayList<Map.Entry<String, List<Map.Entry>>>(allMethod.stream().collect(Collectors.groupingBy(ExtendFormulaCompileReferMethod::getPath, Collectors.toList())).entrySet());
            ArrayList<ExtendFormulaCompileReferMethod> mergeMethod = new ArrayList<ExtendFormulaCompileReferMethod>();
            collect.forEach(n -> {
                ExtendFormulaCompileReferMethod newMethod = new ExtendFormulaCompileReferMethod();
                newMethod.setPath((String)n.getKey());
                HashSet value = new HashSet();
                for (ExtendFormulaCompileReferMethod referMethod : (List)n.getValue()) {
                    value.addAll(referMethod.getMethods());
                }
                newMethod.setMethods(new ArrayList(value));
                mergeMethod.add(newMethod);
            });
            return mergeMethod;
        }
        return null;
    }

    private static void getDefaultValueFormulaPath(LcdpComponent component, List<ExtendFormulaCompileReferMethod> referMethods, String pageType) {
        JSONObject defaults = (JSONObject)component.getProps().get("defaults");
        if (ToolUtil.isNotEmpty((Object)defaults) && ToolUtil.isNotEmpty((Object)defaults.getBoolean("isDefaultValue")) && ToolUtil.isNotEmpty((Object)defaults.getString("defaultValueType")) && defaults.getBoolean("isDefaultValue").booleanValue() && DataFromEnum.EXTEND_FORMULA.getValue().equals(defaults.getString("defaultValueType"))) {
            String value = defaults.getString("value");
            ExtendFormulaInfo formulaInfo = (ExtendFormulaInfo)JSONObject.parseObject((String)value, ExtendFormulaInfo.class);
            if (ToolUtil.isNotEmpty((Object)formulaInfo.getReferMethods())) {
                referMethods.addAll(ExtendFormulaUtil.getImportPath(formulaInfo.getReferMethods(), pageType));
            }
        } else {
            JSONArray cols = (JSONArray)component.getProps().get("component_cols");
            if (ToolUtil.isNotEmpty((Object)cols)) {
                for (int i = 0; i < cols.size(); ++i) {
                    String value;
                    ExtendFormulaInfo formulaInfo;
                    JSONObject col = (JSONObject)cols.get(i);
                    JSONObject defaultValue = (JSONObject)col.get((Object)"defaultValue");
                    if (!ToolUtil.isNotEmpty((Object)defaultValue) || !ToolUtil.isNotEmpty((Object)defaultValue.getBoolean("isDefaultValue")) || !ToolUtil.isNotEmpty((Object)defaultValue.getString("defaultValueType")) || !defaultValue.getBoolean("isDefaultValue").booleanValue() || !DataFromEnum.EXTEND_FORMULA.getValue().equals(defaultValue.getString("defaultValueType")) || !ToolUtil.isNotEmpty((Object)(formulaInfo = (ExtendFormulaInfo)JSONObject.parseObject((String)(value = defaultValue.getString("value")), ExtendFormulaInfo.class)).getReferMethods())) continue;
                    referMethods.addAll(ExtendFormulaUtil.getImportPath(formulaInfo.getReferMethods(), pageType));
                }
            }
        }
    }
}

