/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.base.common.utils;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.defaultvalue.DefaultValueAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.utils.ExtendFormulaUtil;
import com.jxdinfo.hussar.formdesign.codegenerator.core.data.constant.DataFromEnum;
import com.jxdinfo.hussar.formdesign.common.ctx.Ctx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.LcdpComponent;
import com.jxdinfo.hussar.formdesign.common.properties.DataTypeProperties;
import com.jxdinfo.hussar.formdesign.common.properties.EnvVarsProperties;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.extend.model.formula.ExtendFormulaCompileInfo;
import com.jxdinfo.hussar.formdesign.extend.model.formula.ExtendFormulaInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class DefaultValueUtil {
    private static final DataTypeProperties dataTypeProperties = (DataTypeProperties)SpringUtil.getBean(DataTypeProperties.class);
    private static final EnvVarsProperties envVarsProperties = (EnvVarsProperties)SpringUtil.getBean(EnvVarsProperties.class);

    public static String renderDefaultValue(DefaultValueAnalysis defaultValueAnalysis, String dataType, Ctx ctx) {
        String result = "''";
        if (ToolUtil.isNotEmpty((Object)defaultValueAnalysis) && defaultValueAnalysis.isDefaultValue()) {
            String defaultFrom = defaultValueAnalysis.getDefaultValueType();
            String defaultValue = defaultValueAnalysis.getValue();
            if (ToolUtil.isNotEmpty((Object)defaultFrom)) {
                if (DataFromEnum.INPUT.getValue().equals(defaultFrom)) {
                    if (ToolUtil.isEmpty((Object)dataType)) {
                        result = defaultValue;
                    } else if ("string".equals(dataType)) {
                        result = defaultValue.startsWith("'") || defaultValue.startsWith("\"") ? defaultValue : "'" + defaultValue + "'";
                    }
                } else if (DataFromEnum.SESSION.getValue().equals(defaultFrom)) {
                    Map sessionConfig = envVarsProperties.getSession();
                    String item = (String)sessionConfig.get(defaultValue);
                    if (ToolUtil.isNotEmpty((Object)item)) {
                        result = "sessionStorage.getItem(" + item + ")";
                    }
                } else if (DataFromEnum.SYSTEM.getValue().equals(defaultFrom)) {
                    if (DataFromEnum.YEAR.getValue().equals(defaultValue)) {
                        result = "this.format(new Date(),'year')";
                    } else if (DataFromEnum.MONTH.getValue().equals(defaultValue)) {
                        result = "this.format(new Date(),'month')";
                    } else if (DataFromEnum.DATE.getValue().equals(defaultValue)) {
                        result = "this.format(new Date(),'date')";
                    } else if (DataFromEnum.TIME.getValue().equals(defaultValue)) {
                        result = "this.format(new Date(),'time')";
                    } else if (DataFromEnum.DATETIME.getValue().equals(defaultValue)) {
                        result = "this.format(new Date(),'datetime')";
                    }
                } else if ("formula".equals(defaultFrom)) {
                    ExtendFormulaInfo formulaInfo = (ExtendFormulaInfo)JSONObject.parseObject((String)defaultValue, ExtendFormulaInfo.class);
                    try {
                        ExtendFormulaCompileInfo compileInfo = ExtendFormulaUtil.getFormulaCompile(formulaInfo, ctx);
                        if (ToolUtil.isNotEmpty((Object)compileInfo)) {
                            result = compileInfo.getFormulaStr();
                        }
                    }
                    catch (LcdpException e) {
                        e.printStackTrace();
                    }
                }
            }
        } else {
            Map defaultValueConfig = dataTypeProperties.getDefaultValue();
            if (ToolUtil.isNotEmpty((Object)dataType) && ToolUtil.isNotEmpty((Object)defaultValueConfig)) {
                for (Map.Entry entry : defaultValueConfig.entrySet()) {
                    if (!dataType.equals(entry.getKey())) continue;
                    return (String)entry.getValue();
                }
                return (String)defaultValueConfig.get("default");
            }
        }
        return result;
    }

    public static void renderDefaultValueInput(LcdpComponent lcdpComponent, Ctx ctx) throws LcdpException {
        boolean isDefaultValue;
        Object result = "''";
        JSONObject defaultValueAnalysis = (JSONObject)lcdpComponent.getProps().get("defaults");
        if (ToolUtil.isNotEmpty((Object)defaultValueAnalysis) && (isDefaultValue = ((Boolean)defaultValueAnalysis.get((Object)"isDefaultValue")).booleanValue())) {
            String defaultValueType = (String)defaultValueAnalysis.get((Object)"defaultValueType");
            String defaultValue = defaultValueAnalysis.get((Object)"value").toString();
            if (ToolUtil.isNotEmpty((Object)defaultValueType)) {
                if (DataFromEnum.INPUT.getValue().equals(defaultValueType)) {
                    result = "com.jxdinfo.elementui.JXDElCheckBox".equals(lcdpComponent.getName()) && ("true".equals(defaultValue) || "false".equals(defaultValue)) ? Boolean.valueOf(Boolean.parseBoolean(defaultValue)) : "'" + defaultValue + "'";
                } else if (DataFromEnum.SESSION.getValue().equals(defaultValueType)) {
                    Map sessionConfig = envVarsProperties.getSession();
                    String item = (String)sessionConfig.get(defaultValue);
                    if (ToolUtil.isNotEmpty((Object)item)) {
                        result = "sessionStorage.getItem(" + item + ")";
                    }
                } else if (DataFromEnum.SYSTEM.getValue().equals(defaultValueType)) {
                    if (DataFromEnum.YEAR.getValue().equals(defaultValue)) {
                        result = "this.format(new Date(),'year')";
                    } else if (DataFromEnum.MONTH.getValue().equals(defaultValue)) {
                        result = "this.format(new Date(),'month')";
                    } else if (DataFromEnum.DATE.getValue().equals(defaultValue)) {
                        result = "this.format(new Date(),'date')";
                    } else if (DataFromEnum.TIME.getValue().equals(defaultValue)) {
                        result = "this.format(new Date(),'time')";
                    } else if (DataFromEnum.DATETIME.getValue().equals(defaultValue)) {
                        result = "this.format(new Date(),'datetime')";
                    }
                    HashMap params = new HashMap();
                    if (!ctx.getMethods().containsKey("format")) {
                        ArrayList<String> param = new ArrayList<String>();
                        param.add("data");
                        param.add("type");
                        ctx.addMethod("format", param, RenderUtil.renderTemplate((String)"/template/common/event/initDate.ftl", params));
                    }
                } else if (DataFromEnum.EXTEND_FORMULA.getValue().equals(defaultValueType)) {
                    ExtendFormulaInfo formulaInfo = (ExtendFormulaInfo)JSONObject.parseObject((String)defaultValue, ExtendFormulaInfo.class);
                    try {
                        ExtendFormulaCompileInfo compileInfo = ExtendFormulaUtil.getFormulaCompile(formulaInfo, ctx);
                        if (ToolUtil.isNotEmpty((Object)compileInfo)) {
                            result = compileInfo.getFormulaStr();
                        }
                    }
                    catch (LcdpException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        ctx.addData(lcdpComponent.getInstanceKey() + "Data :" + result);
    }
}

