/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.base.common.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.table.TableOptColsAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.constant.CodePrefix;
import com.jxdinfo.hussar.formdesign.base.common.constant.CodeSuffix;
import com.jxdinfo.hussar.formdesign.codegenerator.core.component.LcdpComponent;
import com.jxdinfo.hussar.formdesign.codegenerator.core.component.visitor.BaseProvideVisitor;
import com.jxdinfo.hussar.formdesign.codegenerator.core.component.visitor.ValueVisitor;
import com.jxdinfo.hussar.formdesign.codegenerator.core.ctx.Ctx;
import com.jxdinfo.hussar.formdesign.codegenerator.core.data.constant.DataFromEnum;
import com.jxdinfo.hussar.formdesign.codegenerator.core.data.model.ComponentReference;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.properties.EnvVarsProperties;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ComponentBindUtil {
    private static final EnvVarsProperties envVarsProperties = (EnvVarsProperties)SpringUtil.getBean(EnvVarsProperties.class);
    private static final FormDesignProperties speedCodeProperties = (FormDesignProperties)SpringUtil.getBean(FormDesignProperties.class);

    public static void renderReferenceData(LcdpComponent lcdpComponent, Ctx ctx, boolean isIonic) throws LcdpException {
        Map<String, Object> params;
        if (ComponentBindUtil.isGetReference(lcdpComponent)) {
            ComponentReference reference = ComponentBindUtil.getComponentGetReference(lcdpComponent);
            params = ComponentBindUtil.setCommonReferComputed(lcdpComponent, ctx, reference, "", isIonic);
            ComponentReference setReference = ComponentBindUtil.getComponentSetReference(lcdpComponent);
            LcdpComponent bindComponent = (LcdpComponent)ctx.getComponentMap().get(setReference.getInstanceKey());
            ValueVisitor referVisitor = (ValueVisitor)bindComponent.getProvideVisitor("value");
            bindComponent.accept((BaseProvideVisitor)referVisitor, ctx, null);
            params.put("insData", referVisitor.getDataItemValue(setReference.getInstanceData()).getRenderValue());
        } else {
            ComponentReference reference = ComponentBindUtil.getComponentSetReference(lcdpComponent);
            params = ComponentBindUtil.setCommonReferComputed(lcdpComponent, ctx, reference, "", isIonic);
        }
        if (ToolUtil.isNotEmpty(params)) {
            if (isIonic) {
                ctx.addComputed(lcdpComponent.getInstanceKey() + CodeSuffix._DATA.getType(), RenderUtil.renderTemplate((String)"/template/ionicui/event/IonicReference.ftl", params));
            } else {
                ctx.addComputed(lcdpComponent.getInstanceKey() + CodeSuffix._DATA.getType(), RenderUtil.renderTemplate((String)"/template/elementui/event/ElementReference.ftl", params));
            }
        }
    }

    public static Map<String, Map<String, Object>> getRenderPageParamData(LcdpComponent lcdpComponent, Ctx ctx, Map<String, Object> pageParamConfig) throws LcdpException {
        HashMap<String, Map<String, Object>> pageParams = new HashMap<String, Map<String, Object>>();
        HashMap<String, Object> paramConfig = new HashMap<String, Object>();
        HashMap<String, Object> paramBody = new HashMap<String, Object>();
        for (String key : pageParamConfig.keySet()) {
            ComponentReference componentReference = (ComponentReference)JSON.parseObject((String)pageParamConfig.get(key).toString(), ComponentReference.class);
            Map<String, Object> configData = ComponentBindUtil.setCommonReferComputed(lcdpComponent, ctx, componentReference, key, false);
            if (configData.size() <= 0) continue;
            if (ToolUtil.isNotEmpty((Object)configData.get("referResult"))) {
                paramConfig.put(key, configData.get("referResult"));
            } else if (ToolUtil.isNotEmpty((Object)configData.get("inputResult"))) {
                paramConfig.put(key, configData.get("inputResult"));
            } else if (ToolUtil.isNotEmpty((Object)configData.get("configData"))) {
                paramConfig.put(key, configData.get("configData"));
            } else {
                paramConfig.put(key, "");
            }
            if (!configData.containsKey("referBody") || !ToolUtil.isNotEmpty((Object)configData.get("referBody"))) continue;
            paramBody.put(key, configData.get("referBody"));
        }
        pageParams.put("paramConfig", paramConfig);
        pageParams.put("paramBody", paramBody);
        return pageParams;
    }

    public static Map<String, Object> getAssignmentParam(LcdpComponent lcdpComponent, Ctx ctx, ComponentReference reference) throws LcdpException {
        return ComponentBindUtil.getAssignmentParam(lcdpComponent, ctx, reference, "", false);
    }

    public static Map<String, Object> getAssignmentParam(LcdpComponent lcdpComponent, Ctx ctx, ComponentReference reference, String key, boolean isIonic) throws LcdpException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (ComponentBindUtil.isReferenceConfig(reference)) {
            if (DataFromEnum.INSTANCE.getValue().equals(reference.getType())) {
                if (isIonic) {
                    ComponentBindUtil.dealIonicInstance(lcdpComponent, reference, params, ctx);
                } else {
                    ComponentBindUtil.dealInstanceForAction(lcdpComponent, reference, params, ctx);
                }
            } else if (DataFromEnum.CALCULATE.getValue().equals(reference.getType())) {
                ComponentBindUtil.dealCalculate(lcdpComponent, reference, params, ctx, key);
            } else if (DataFromEnum.CUSTOM_JS.getValue().equals(reference.getType())) {
                Map<String, Object> fromDataMap = ComponentBindUtil.dealCustomJs(lcdpComponent, ctx, reference);
                params.put("fromDataMap", fromDataMap);
            } else if (DataFromEnum.INPUT.getValue().equals(reference.getType()) && ToolUtil.isNotEmpty((Object)reference.getConfigData())) {
                params.put("inputResult", "'" + reference.getConfigData() + "'");
            } else if (DataFromEnum.VARIABLE.getValue().equals(reference.getType()) && ToolUtil.isNotEmpty((Object)reference.getConfigData())) {
                params.put("inputResult", reference.getConfigData());
            } else if (reference.getType().equals(DataFromEnum.SESSION.getValue())) {
                Map sessionConfig = envVarsProperties.getSession();
                if (ToolUtil.isNotEmpty((Object)reference.getConfigData())) {
                    String getSessionValue = "sessionStorage.getItem(" + (String)sessionConfig.get(reference.getConfigData()) + ")";
                    params.put("referResult", getSessionValue);
                }
            } else if (reference.getType().equals(DataFromEnum.PAGE_PARAM.getValue())) {
                params.put("referResult", "self.$route.query." + reference.getConfigData());
            } else {
                return params;
            }
        }
        return params;
    }

    private static void dealInstanceForAction(LcdpComponent lcdpComponent, ComponentReference reference, Map<String, Object> params, Ctx ctx) throws LcdpException {
        List referIds = reference.getInstanceData();
        if (ToolUtil.isNotEmpty((Object)referIds)) {
            LcdpComponent bindComponent = (LcdpComponent)ctx.getComponentMap().get(reference.getInstanceKey());
            if (ToolUtil.isEmpty((Object)bindComponent)) {
                params.put("referResult", CodePrefix._THIS.getType() + reference.getInstanceKey() + CodeSuffix._DATA.getType());
            } else {
                String result;
                ValueVisitor referVisitor = (ValueVisitor)bindComponent.getProvideVisitor("value");
                bindComponent.accept((BaseProvideVisitor)referVisitor, ctx, null);
                if (lcdpComponent.getInstanceKey().equals(reference.getInstanceKey()) && "com.jxdinfo.elementui.JXDElTable".equals(lcdpComponent.getName())) {
                    referIds.add("tableAddAssignment");
                }
                if ((result = referVisitor.getDataItemValue(referIds).getRenderValue()).contains("forEach")) {
                    params.put("referResult", result.replaceAll("this", "self"));
                } else if (result.contains("data.")) {
                    params.put("referResult", result);
                } else {
                    params.put("referResult", referVisitor.getDataItemValue(referIds).getRenderValue());
                }
            }
        }
    }

    public static boolean isSetReference(LcdpComponent lcdpComponent) {
        ComponentReference referObj;
        JSONObject reference;
        boolean isSet = false;
        if (ToolUtil.isNotEmpty(lcdpComponent.getProps().get("reference")) && ToolUtil.isNotEmpty((Object)(reference = (JSONObject)lcdpComponent.getProps().get("reference")).get((Object)"setReference"))) {
            referObj = (ComponentReference)JSON.parseObject((String)reference.get((Object)"setReference").toString(), ComponentReference.class);
            isSet = ComponentBindUtil.isReferenceConfig(referObj);
        }
        if (ToolUtil.isNotEmpty(lcdpComponent.getProps().get("calculateRefer")) && ToolUtil.isNotEmpty((Object)(reference = (JSONObject)lcdpComponent.getProps().get("calculateRefer")).get((Object)"setReference"))) {
            referObj = (ComponentReference)JSON.parseObject((String)reference.get((Object)"setReference").toString(), ComponentReference.class);
            isSet = isSet || ComponentBindUtil.isReferenceConfig(referObj);
        }
        return isSet;
    }

    public static boolean isGetReference(LcdpComponent lcdpComponent) {
        ComponentReference referObj;
        JSONObject reference;
        boolean isSet = false;
        if (ToolUtil.isNotEmpty(lcdpComponent.getProps().get("reference"))) {
            reference = (JSONObject)lcdpComponent.getProps().get("reference");
            if (ComponentBindUtil.isSetReference(lcdpComponent) && ToolUtil.isNotEmpty((Object)reference.get((Object)"getReference"))) {
                referObj = (ComponentReference)JSON.parseObject((String)reference.get((Object)"getReference").toString(), ComponentReference.class);
                isSet = ComponentBindUtil.isReferenceConfig(referObj);
            }
        }
        if (ToolUtil.isNotEmpty(lcdpComponent.getProps().get("calculateRefer"))) {
            reference = (JSONObject)lcdpComponent.getProps().get("calculateRefer");
            if (ComponentBindUtil.isSetReference(lcdpComponent) && ToolUtil.isNotEmpty((Object)reference.get((Object)"getReference"))) {
                referObj = (ComponentReference)JSON.parseObject((String)reference.get((Object)"getReference").toString(), ComponentReference.class);
                isSet = isSet || ComponentBindUtil.isReferenceConfig(referObj);
            }
        }
        return isSet;
    }

    private static boolean isReferenceConfig(ComponentReference reference) {
        if (null == reference || null == reference.getType()) {
            return false;
        }
        if (DataFromEnum.INSTANCE.getValue().equals(reference.getType())) {
            return ToolUtil.isNotEmpty((Object)reference.getInstanceKey()) && ToolUtil.isNotEmpty((Object)reference.getInstanceData());
        }
        if (DataFromEnum.CALCULATE.getValue().equals(reference.getType())) {
            if (ToolUtil.isEmpty((Object)reference.getFormula())) {
                return false;
            }
            List referIds = reference.getCalData();
            if (ToolUtil.isNotEmpty((Object)referIds)) {
                for (ComponentReference calculateAttribute : referIds) {
                    if (ToolUtil.isEmpty((Object)calculateAttribute.getType())) {
                        return false;
                    }
                    if (!(DataFromEnum.INSTANCE.getValue().equals(calculateAttribute.getType()) ? ToolUtil.isEmpty((Object)calculateAttribute.getInstanceData()) || ToolUtil.isEmpty((Object)calculateAttribute.getInstanceKey()) : ToolUtil.isEmpty((Object)calculateAttribute.getConfigData()))) continue;
                    return false;
                }
                return true;
            }
        } else {
            if (DataFromEnum.CUSTOM_JS.getValue().equals(reference.getType())) {
                return ToolUtil.isNotEmpty((Object)reference.getImplementFunction());
            }
            return ToolUtil.isNotEmpty((Object)reference.getConfigData());
        }
        return false;
    }

    public static ComponentReference getComponentSetReference(LcdpComponent lcdpComponent) {
        JSONObject reference;
        ComponentReference componentReference = null;
        if (ToolUtil.isNotEmpty(lcdpComponent.getProps().get("reference")) && ToolUtil.isNotEmpty((Object)(reference = (JSONObject)lcdpComponent.getProps().get("reference")).get((Object)"setReference")) && ComponentBindUtil.isReferenceConfig(componentReference = (ComponentReference)JSON.parseObject((String)reference.get((Object)"setReference").toString(), ComponentReference.class))) {
            return componentReference;
        }
        if (ToolUtil.isNotEmpty(lcdpComponent.getProps().get("calculateRefer")) && ToolUtil.isNotEmpty((Object)(reference = (JSONObject)lcdpComponent.getProps().get("calculateRefer")).get((Object)"setReference")) && ComponentBindUtil.isReferenceConfig(componentReference = (ComponentReference)JSON.parseObject((String)reference.get((Object)"setReference").toString(), ComponentReference.class))) {
            return componentReference;
        }
        return componentReference;
    }

    public static ComponentReference getComponentGetReference(LcdpComponent lcdpComponent) {
        JSONObject reference;
        ComponentReference componentReference = null;
        if (ToolUtil.isNotEmpty(lcdpComponent.getProps().get("reference")) && ToolUtil.isNotEmpty((Object)(reference = (JSONObject)lcdpComponent.getProps().get("reference")).get((Object)"getReference")) && ComponentBindUtil.isReferenceConfig(componentReference = (ComponentReference)JSON.parseObject((String)reference.get((Object)"getReference").toString(), ComponentReference.class))) {
            return componentReference;
        }
        if (ToolUtil.isNotEmpty(lcdpComponent.getProps().get("calculateRefer")) && ToolUtil.isNotEmpty((Object)(reference = (JSONObject)lcdpComponent.getProps().get("calculateRefer")).get((Object)"getReference")) && ComponentBindUtil.isReferenceConfig(componentReference = (ComponentReference)JSON.parseObject((String)reference.get((Object)"getReference").toString(), ComponentReference.class))) {
            return componentReference;
        }
        return componentReference;
    }

    public static Map<String, Object> setCommonReferComputed(LcdpComponent lcdpComponent, Ctx ctx, ComponentReference reference, String key, boolean isIonic) throws LcdpException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (ComponentBindUtil.isReferenceConfig(reference)) {
            if (DataFromEnum.INSTANCE.getValue().equals(reference.getType())) {
                if (isIonic) {
                    ComponentBindUtil.dealIonicInstance(lcdpComponent, reference, params, ctx);
                } else {
                    ComponentBindUtil.dealInstance(lcdpComponent, reference, params, ctx);
                }
            } else if (DataFromEnum.CALCULATE.getValue().equals(reference.getType())) {
                ComponentBindUtil.dealCalculate(lcdpComponent, reference, params, ctx, key);
            } else if (DataFromEnum.INPUT.getValue().equals(reference.getType()) && ToolUtil.isNotEmpty((Object)reference.getConfigData())) {
                params.put("inputResult", "'" + reference.getConfigData() + "'");
            } else if (DataFromEnum.VARIABLE.getValue().equals(reference.getType()) && ToolUtil.isNotEmpty((Object)reference.getConfigData())) {
                params.put("inputResult", reference.getConfigData());
            } else if (reference.getType().equals(DataFromEnum.SESSION.getValue())) {
                Map sessionConfig = envVarsProperties.getSession();
                if (ToolUtil.isNotEmpty((Object)reference.getConfigData())) {
                    String getSessionValue = "sessionStorage.getItem(" + (String)sessionConfig.get(reference.getConfigData()) + ")";
                    params.put("referResult", getSessionValue);
                }
            } else if (reference.getType().equals(DataFromEnum.PAGE_PARAM.getValue())) {
                params.put("referResult", "self.$route.query." + reference.getConfigData());
            } else if (reference.getType().equals(DataFromEnum.EVENT_PARAM.getValue())) {
                params.put("configData", reference.getConfigData());
            } else {
                return params;
            }
        }
        return params;
    }

    private static void dealInstance(LcdpComponent lcdpComponent, ComponentReference reference, Map<String, Object> params, Ctx ctx) throws LcdpException {
        List referIds = reference.getInstanceData();
        if (ToolUtil.isNotEmpty((Object)referIds)) {
            LcdpComponent bindComponent = (LcdpComponent)ctx.getComponentMap().get(reference.getInstanceKey());
            if (ToolUtil.isEmpty((Object)bindComponent)) {
                params.put("referResult", CodePrefix._THIS.getType() + reference.getInstanceKey() + CodeSuffix._DATA.getType());
            } else {
                ValueVisitor referVisitor = (ValueVisitor)bindComponent.getProvideVisitor("value");
                bindComponent.accept((BaseProvideVisitor)referVisitor, ctx, null);
                String result = referVisitor.getDataItemValue(referIds).getRenderValue();
                if (referIds.size() == 1 && !ComponentBindUtil.isGetReference(lcdpComponent)) {
                    if (lcdpComponent.getName().equals("com.jxdinfo.elementui.JXDElEditTable") || lcdpComponent.getName().equals("com.jxdinfo.elementui.JXDElTable")) {
                        lcdpComponent.addAttr(CodePrefix._DATA.getType(), ComponentBindUtil.dealPrefixThis(result));
                    } else {
                        lcdpComponent.addAttr(CodePrefix._V_MODEL.getType(), ComponentBindUtil.dealPrefixThis(result));
                    }
                }
                if (!ToolUtil.isNotEmpty((Object)ComponentBindUtil.getComponentRelateColData(reference.getInstanceKey(), reference.getInstanceData(), ctx)) || ComponentBindUtil.isGetReference(lcdpComponent)) {
                    if (result.contains("forEach")) {
                        params.put("referResult", result.replace("this", "self"));
                    } else {
                        params.put("referResult", result);
                    }
                }
            }
        }
    }

    private static void dealIonicInstance(LcdpComponent lcdpComponent, ComponentReference reference, Map<String, Object> params, Ctx ctx) throws LcdpException {
        String referResult = ComponentBindUtil.getReferValueByKeyAndData(lcdpComponent, ctx, reference.getInstanceKey(), reference.getInstanceData(), false);
        if (ToolUtil.isNotEmpty((Object)referResult)) {
            params.put("referResult", CodePrefix._SELF.getType() + ComponentBindUtil.dealPrefixThis(referResult));
        }
    }

    public static String getReferValueByKeyAndData(LcdpComponent lcdpComponent, Ctx ctx, String bindInsKey, List<String> instanceData, boolean direct) throws LcdpException {
        if (ToolUtil.isNotEmpty(instanceData)) {
            LcdpComponent bindComponent = (LcdpComponent)ctx.getComponentMap().get(bindInsKey);
            if (ToolUtil.isEmpty((Object)bindComponent)) {
                return bindInsKey + CodeSuffix._DATA.getType();
            }
            ValueVisitor referVisitor = (ValueVisitor)bindComponent.getProvideVisitor("value");
            bindComponent.accept((BaseProvideVisitor)referVisitor, ctx, null);
            String result = referVisitor.getDataItemValue(instanceData).getRenderValue();
            if (instanceData.size() == 1) {
                lcdpComponent.addRenderParam("bindData", (Object)ComponentBindUtil.dealPrefixThis(result));
            }
            if (ToolUtil.isNotEmpty((Object)ComponentBindUtil.getComponentRelateColData(bindInsKey, instanceData, ctx)) && ComponentBindUtil.isGetReference(lcdpComponent) || direct) {
                return result;
            }
        }
        return "";
    }

    private static void dealCalculate(LcdpComponent lcdpComponent, ComponentReference reference, Map<String, Object> params, Ctx ctx, String key) throws LcdpException {
        String dataType;
        StringBuilder calRes = new StringBuilder();
        ArrayList<StringBuilder> evalList = new ArrayList<StringBuilder>();
        if (ToolUtil.isNotEmpty((Object)key)) {
            calRes.append("let ").append(key).append("Res = '';\n");
        } else {
            calRes.append("(function() {\nlet res = '';\n");
        }
        List referIds = reference.getCalData();
        for (ComponentReference calculateAttribute : referIds) {
            StringBuilder evalStr = new StringBuilder();
            if (DataFromEnum.INSTANCE.getValue().equals(calculateAttribute.getType())) {
                List calculateAttributes = calculateAttribute.getInstanceData();
                if (ToolUtil.isNotEmpty((Object)calculateAttributes)) {
                    LcdpComponent bindComponent = (LcdpComponent)ctx.getComponentMap().get(calculateAttribute.getInstanceKey());
                    if (ToolUtil.isEmpty((Object)bindComponent)) {
                        evalStr.append(calculateAttribute.getInstanceKey()).append(CodeSuffix._DATA.getType());
                    } else {
                        ValueVisitor referVisitor = (ValueVisitor)bindComponent.getProvideVisitor("value");
                        bindComponent.accept((BaseProvideVisitor)referVisitor, ctx, null);
                        evalStr.append(referVisitor.getDataItemValue(calculateAttributes).getRenderValue());
                    }
                }
            } else if (DataFromEnum.INPUT.getValue().equals(calculateAttribute.getType())) {
                evalStr.append("'").append(calculateAttribute.getConfigData()).append("'");
            } else if (calculateAttribute.getType().equals(DataFromEnum.SESSION.getValue())) {
                Map sessionConfig = envVarsProperties.getSession();
                if (ToolUtil.isNotEmpty((Object)calculateAttribute.getConfigData())) {
                    String getSessionValue = "sessionStorage.getItem(" + (String)sessionConfig.get(calculateAttribute.getConfigData()) + ")";
                    evalStr.append(getSessionValue);
                }
            } else if (calculateAttribute.getType().equals(DataFromEnum.PAGE_PARAM.getValue())) {
                evalStr.append("self.$route.query.").append(calculateAttribute.getConfigData());
            }
            evalList.add(evalStr);
        }
        if (ToolUtil.isNotEmpty((Object)key)) {
            String formula;
            int i;
            dataType = reference.getConfigDataType();
            if ("num".equals(dataType)) {
                for (i = 0; i < evalList.size(); ++i) {
                    calRes.append("const ").append(key).append("P").append(i + 1).append(" = Number(").append(((StringBuilder)evalList.get(i)).toString()).append(");\n");
                }
            } else {
                for (i = 0; i < evalList.size(); ++i) {
                    calRes.append("const ").append(key).append("P").append(i + 1).append(" = ").append(((StringBuilder)evalList.get(i)).toString()).append(";\n");
                }
            }
            if (ToolUtil.isNotEmpty((Object)(formula = reference.getFormula()))) {
                formula = formula.replace("p", key + "P");
            }
            calRes.append(key).append("Res = eval(").append(formula).append(");\n");
            params.put("referBody", calRes.toString());
            params.put("referResult", key + "Res");
        } else {
            dataType = reference.getConfigDataType();
            if ("num".equals(dataType)) {
                for (int i = 0; i < evalList.size(); ++i) {
                    calRes.append("const p").append(i + 1).append(" = Number(").append(((StringBuilder)evalList.get(i)).toString()).append(");\n");
                }
            } else {
                for (int i = 0; i < evalList.size(); ++i) {
                    calRes.append("const p").append(i + 1).append(" = ").append(((StringBuilder)evalList.get(i)).toString()).append(";\n");
                }
            }
            calRes.append("res = ").append(reference.getFormula()).append(";\nreturn res;\n})()");
            params.put("referResult", calRes.toString().replace("this", "self"));
        }
    }

    private static Map<String, Object> dealCustomJs(LcdpComponent lcdpComponent, Ctx ctx, ComponentReference fromRefer) throws LcdpException {
        List implementFunction = fromRefer.getImplementFunction();
        Map jsData = (Map)implementFunction.get(0);
        HashMap<String, Object> customFuncConfigMap = new HashMap<String, Object>();
        customFuncConfigMap.put("functionName", jsData.get("functionName"));
        customFuncConfigMap.put("value", jsData.get("value"));
        customFuncConfigMap.put("fileIdentify", jsData.get("fileIdentify"));
        List paramList = (List)jsData.get("params");
        ArrayList<Object> paramName = new ArrayList<Object>();
        if (ToolUtil.isNotEmpty((Object)paramList)) {
            ArrayList<Object> referBodyConfig = new ArrayList<Object>();
            for (Map stringObjectMap : paramList) {
                ComponentReference componentReference = (ComponentReference)JSON.parseObject((String)stringObjectMap.toString(), ComponentReference.class);
                Map<String, Object> paramConfig = ComponentBindUtil.getAssignmentParam(lcdpComponent, ctx, componentReference);
                if (paramConfig.containsKey("referBody")) {
                    referBodyConfig.add(paramConfig.get("referBody"));
                }
                if (paramConfig.containsKey("inputResult")) {
                    paramName.add(paramConfig.get("inputResult"));
                }
                if (!paramConfig.containsKey("referResult")) continue;
                paramName.add(paramConfig.get("referResult"));
            }
            customFuncConfigMap.put("referBodyConfig", referBodyConfig);
        }
        customFuncConfigMap.put("paramName", paramName);
        return customFuncConfigMap;
    }

    public static String timeCalculator(LcdpComponent lcdpComponent, boolean upCase) {
        if (upCase) {
            return "if ((P1 && P2) && P1 instanceof Date && !isNaN(Date.parse(P1)) &&  P2 instanceof Date && !isNaN(Date.parse(P2))) {\nlet t1= this.$moment(P1);\nlet t2 = this.$moment(P2);\nlet dura = t2.format('x') - t1.format('x');\nlet tempTime = this.$moment.duration(dura);\nlet year = '';\nlet month = '';\nlet day = '';\nlet hour = '';\nlet minute = '';\nlet second = '';\nyear = tempTime.years();\nmonth = tempTime.months();\nday =tempTime.days();\nhour = tempTime.hours();\nminute = tempTime.minutes();\nsecond =tempTime.seconds();\nif (year) {\nres = year + '\u5e74';\n}\nif (month) {\nres = res + month + '\u6708';\n}\nif (day) {\nres = res + day + '\u5929';\n}\nif (hour) {\nres =res +  hour + '\u5c0f\u65f6';\n}\nif (minute) {\nres = res + minute + '\u5206\u949f';\n}\nif (second) {\nres = res + second + '\u79d2';\n}\n}";
        }
        return "if ((p1 && p2) &&  p1 instanceof Date && !isNaN(Date.parse(p1)) &&  p2 instanceof Date && !isNaN(Date.parse(p2))) {\nlet t1= this.$moment(p1);\nlet t2 = this.$moment(p2);\nlet dura = t2.format('x') - t1.format('x');\nlet tempTime = this.$moment.duration(dura);\nlet year = '';\nlet month = '';\nlet day = '';\nlet hour = '';\nlet minute = '';\nlet second = '';\nyear = tempTime.years();\nmonth = tempTime.months();\nday =tempTime.days();\nhour = tempTime.hours();\nminute = tempTime.minutes();\nsecond =tempTime.seconds();\nif (year) {\nres = year + '\u5e74';\n}\nif (month) {\nres = res + month + '\u6708';\n}\nif (day) {\nres = res + day + '\u5929';\n}\nif (hour) {\nres =res +  hour + '\u5c0f\u65f6';\n}\nif (minute) {\nres = res + minute + '\u5206\u949f';\n}\nif (second) {\nres = res + second + '\u79d2';\n}\n}\n";
    }

    public static String getComponentDataRender(LcdpComponent lcdpComponent, Ctx ctx, String suffix) throws LcdpException {
        String defaultReturn = CodePrefix._SELF.getType() + lcdpComponent.getInstanceKey() + suffix;
        ComponentReference componentReference = ComponentBindUtil.getComponentSetReference(lcdpComponent);
        if (ToolUtil.isNotEmpty((Object)componentReference)) {
            LcdpComponent bindComponent = (LcdpComponent)ctx.getComponentMap().get(componentReference.getInstanceKey());
            if (ToolUtil.isEmpty((Object)bindComponent)) {
                if (speedCodeProperties.isDeveloperMode()) {
                    System.err.println("\u6e32\u67d3'" + lcdpComponent.getInstanceKey() + "'\u7ec4\u4ef6\u65f6\u627e\u4e0d\u5230\u503c\u5f15\u7528\uff1a" + componentReference.getInstanceKey() + "'\u5bf9\u5e94\u7684\u7ec4\u4ef6");
                }
                return defaultReturn;
            }
            String referValue = "";
            if (!ComponentBindUtil.isGetReference(lcdpComponent)) {
                ValueVisitor referVisitor = (ValueVisitor)bindComponent.getProvideVisitor("value");
                bindComponent.accept((BaseProvideVisitor)referVisitor, ctx, null);
                referValue = referVisitor.getDataItemValue(componentReference.getInstanceData()).getRenderValue();
            }
            if (ToolUtil.isEmpty((Object)(referValue = ComponentBindUtil.dealPrefixThis(referValue)))) {
                return defaultReturn;
            }
            return referValue.contains("function") ? referValue : CodePrefix._SELF.getType() + referValue;
        }
        return defaultReturn;
    }

    public static String getSetReferenceCol(LcdpComponent lcdpComponent, Ctx ctx) throws LcdpException {
        ComponentReference componentReference = ComponentBindUtil.getComponentSetReference(lcdpComponent);
        if (ToolUtil.isNotEmpty((Object)componentReference) && ToolUtil.isNotEmpty((Object)componentReference.getInstanceData()) && componentReference.getInstanceData().size() > 1) {
            return ComponentBindUtil.getComponentRelateColData(componentReference.getInstanceKey(), componentReference.getInstanceData(), ctx).replaceAll(CodePrefix._THIS.getType(), "");
        }
        return null;
    }

    public static String getComponentRelateColData(String bindKey, List<String> referIds, Ctx ctx) throws LcdpException {
        LcdpComponent bindComponent = (LcdpComponent)ctx.getComponentMap().get(bindKey);
        if (ToolUtil.isNotEmpty((Object)bindComponent)) {
            return ComponentBindUtil.getColRelateData(bindComponent, ctx, referIds, "component_cols");
        }
        return "";
    }

    public static String getOptRelateColData(String bindKey, List<String> referIds, Ctx ctx) throws LcdpException {
        LcdpComponent bindComponent = (LcdpComponent)ctx.getComponentMap().get(bindKey);
        if (ToolUtil.isNotEmpty((Object)bindComponent)) {
            return ComponentBindUtil.getColRelateData(bindComponent, ctx, referIds, "opt_cols");
        }
        return "";
    }

    private static String getColRelateData(LcdpComponent bindComponent, Ctx ctx, List<String> referIds, String colType) throws LcdpException {
        JSONArray optColsJSONArray = (JSONArray)bindComponent.getProps().get(colType);
        if (ToolUtil.isNotEmpty((Object)optColsJSONArray) && ToolUtil.isNotEmpty(referIds)) {
            List listOptColsAnalyses = JSONObject.parseArray((String)optColsJSONArray.toJSONString(), TableOptColsAnalysis.class);
            String referId = referIds.get(referIds.size() - 1);
            for (TableOptColsAnalysis tableOptColsAnalysis : listOptColsAnalyses) {
                if (!ToolUtil.isNotEmpty((Object)tableOptColsAnalysis.getId()) || !tableOptColsAnalysis.getId().equals(referId)) continue;
                ValueVisitor referVisitor = (ValueVisitor)bindComponent.getProvideVisitor("value");
                bindComponent.accept((BaseProvideVisitor)referVisitor, ctx, null);
                return referVisitor.getDataItemValue(referIds).getRenderValue();
            }
        }
        return "";
    }

    public static String dealPrefixThis(String str) {
        if (ToolUtil.isNotEmpty((Object)str)) {
            if (str.startsWith(CodePrefix._THIS.getType())) {
                str = str.replaceFirst(CodePrefix._THIS.getType(), "");
            }
            if (str.startsWith(CodePrefix._SELF.getType())) {
                str = str.replaceFirst(CodePrefix._SELF.getType(), "");
            }
            if (str.startsWith(CodePrefix._THIS.getType()) || str.startsWith(CodePrefix._SELF.getType())) {
                str = ComponentBindUtil.dealPrefixThis(str);
            }
        }
        return str;
    }
}

