/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.base.common.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.back.adapter.ModelProvideAdapter;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.rules.NamingStrategy;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.model.validation.ParamValidation;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.model.validation.ParamValidationRule;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.back.constant.validate.RuleTypeEnum;
import com.jxdinfo.hussar.formdesign.back.model.DataModelBase;
import com.jxdinfo.hussar.formdesign.back.model.dataset.DataSet;
import com.jxdinfo.hussar.formdesign.back.model.dataset.DataSetObject;
import com.jxdinfo.hussar.formdesign.back.model.dataset.ValueObjectProperty;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.dataitem.reference.GetValueBO;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.dataset.FrontParamValidation;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.dataset.MethodConfigAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.utils.ElementCheckUtil;
import com.jxdinfo.hussar.formdesign.base.common.utils.MappingUtils;
import com.jxdinfo.hussar.formdesign.codegenerator.core.component.LcdpComponent;
import com.jxdinfo.hussar.formdesign.codegenerator.core.condition.ConditionBody;
import com.jxdinfo.hussar.formdesign.codegenerator.core.condition.ConditionItem;
import com.jxdinfo.hussar.formdesign.codegenerator.core.constant.BackConditionConnectEnum;
import com.jxdinfo.hussar.formdesign.codegenerator.core.ctx.Ctx;
import com.jxdinfo.hussar.formdesign.codegenerator.core.data.constant.DataFromEnum;
import com.jxdinfo.hussar.formdesign.codegenerator.core.data.mapping.DataItemMappingBO;
import com.jxdinfo.hussar.formdesign.codegenerator.core.data.model.ComponentReference;
import com.jxdinfo.hussar.formdesign.codegenerator.core.model.ComponentData;
import com.jxdinfo.hussar.formdesign.codegenerator.core.util.ConditionUtil;
import com.jxdinfo.hussar.formdesign.codegenerator.core.util.DataConfigUtil;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.render.RenderCore;
import com.jxdinfo.hussar.formdesign.common.render.RenderResult;
import com.jxdinfo.hussar.formdesign.common.runner.formcheck.FormCheckObject;
import com.jxdinfo.hussar.formdesign.common.runner.validation.JsValidationType;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;

public class VoidComponentCodeUtil {
    private static final String MAPPING_KEY = "mapping";

    public static void renderData(LcdpComponent lcdpComponent, Ctx ctx) throws IOException, LcdpException {
        DataSet returnDataSet;
        JSONObject methodObj = JSONObject.parseObject((String)JSONObject.toJSONString((Object)lcdpComponent.getDatas()));
        if (ToolUtil.isEmpty((Object)methodObj) || ToolUtil.isEmpty((Object)methodObj.get((Object)"datamodel"))) {
            return;
        }
        MethodConfigAnalysis methodConfigAnalysis = (MethodConfigAnalysis)JSONObject.parseObject((String)methodObj.get((Object)"datamodel").toString(), MethodConfigAnalysis.class);
        if (ToolUtil.isNotEmpty((Object)methodConfigAnalysis) && ToolUtil.isNotEmpty((Object)(returnDataSet = DataModelUtil.getDataSetById((String)methodConfigAnalysis.getDataModelId(), (String)methodConfigAnalysis.getReturnDataSet())))) {
            String dataType = returnDataSet.getDataType();
            if (dataType.equals(ComponentData.DataTypeEnum.OBJECT.getValue())) {
                ctx.addData(lcdpComponent.getInstanceKey() + "Data:{" + VoidComponentCodeUtil.renderData(returnDataSet) + "}");
            } else if (dataType.equals(ComponentData.DataTypeEnum.ARRAY_OBJECT.getValue())) {
                ctx.addData(lcdpComponent.getInstanceKey() + "Data: []");
            } else {
                ctx.addData(lcdpComponent.getInstanceKey() + "Data: ''");
            }
        }
    }

    public static String renderData(DataSet returnDataSet) {
        DataSetObject dataSetObject = returnDataSet.getDataSetObject();
        StringBuilder dataBuilder = new StringBuilder();
        VoidComponentCodeUtil.renderData(dataSetObject.getProperties(), dataBuilder);
        return dataBuilder.toString();
    }

    public static String renderData(List<ValueObjectProperty> properties, StringBuilder dataBuilder) {
        StringBuilder fieldBuilder = new StringBuilder();
        if (ToolUtil.isNotEmpty(properties)) {
            for (ValueObjectProperty property : properties) {
                if (property.getDataType().equals(ComponentData.DataTypeEnum.OBJECT.getValue())) {
                    dataBuilder.append(property.getName()).append(":{").append(VoidComponentCodeUtil.renderData(property.getProperties(), dataBuilder)).append("},");
                    continue;
                }
                if (property.getDataType().equals(ComponentData.DataTypeEnum.ARRAY_OBJECT.getValue())) {
                    fieldBuilder.append(property.getName()).append(": [],");
                    continue;
                }
                if (property.getDataType().equals(ComponentData.DataTypeEnum.OBJECT.getValue())) {
                    fieldBuilder.append(property.getName()).append(": {},");
                    continue;
                }
                fieldBuilder.append(property.getName()).append(": '',");
            }
        }
        return fieldBuilder.toString();
    }

    public static void configParams(Map<String, Object> tableMap, Ctx ctx, MethodConfigAnalysis methodConfigAnalysis) throws LcdpException, IOException {
        List<GetValueBO> getValueBOS = methodConfigAnalysis.getParamConfig();
        String dataModelId = methodConfigAnalysis.getDataModelId();
        DataSet dataSetAnalysis = DataModelUtil.getDataSetById((String)dataModelId, (String)methodConfigAnalysis.getParamDataSet());
        if (ToolUtil.isEmpty(getValueBOS) || ToolUtil.isEmpty((Object)dataSetAnalysis)) {
            return;
        }
        HashMap<String, Map<String, String>> paramRenderStr = new HashMap<String, Map<String, String>>();
        VoidComponentCodeUtil.dealRenderParam(ctx, getValueBOS, paramRenderStr, dataSetAnalysis, dataModelId);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("paramRenderStr", paramRenderStr);
        params.put("paramObj", tableMap.get("importName") + "Obj");
        params.put("queryAttr", tableMap.get("queryAttr"));
        HashMap<String, String> oneLevelMap = new HashMap<String, String>();
        HashMap twoLevelMap = new HashMap();
        for (GetValueBO getValueBO : getValueBOS) {
            if (!ToolUtil.isNotEmpty(getValueBO.getCurrentData()) || getValueBO.getCurrentData().size() <= 0) continue;
            if (getValueBO.getCurrentData().size() == 1) {
                oneLevelMap.put(getValueBO.getCurrentData().get(0), getValueBO.getCurrentData().get(0));
            }
            if (getValueBO.getCurrentData().size() != 2) continue;
            ArrayList<String> thisValueS = new ArrayList<String>();
            thisValueS.add(getValueBO.getCurrentData().get(1));
            Object lastValue = twoLevelMap.get(getValueBO.getCurrentData().get(0));
            if (ToolUtil.isNotEmpty(lastValue)) {
                List lastValueS = (List)lastValue;
                thisValueS.addAll(lastValueS);
            }
            twoLevelMap.put(getValueBO.getCurrentData().get(0), thisValueS);
        }
        params.put("oneLevel", oneLevelMap);
        params.put("twoLevel", twoLevelMap);
        String paramRes = RenderUtil.renderTemplate((String)"/template/elementui/element/ApiComponent/apiComponent_param.ftl", params);
        tableMap.put("paramRes", paramRes);
    }

    private static void dealRenderParam(Ctx ctx, List<GetValueBO> getValueBOS, Map<String, Map<String, String>> paramRenderStr, DataSet dataSetAnalysis, String dataModelId) throws LcdpException, IOException {
        for (int i = 0; i < getValueBOS.size(); ++i) {
            ComponentData getValueData;
            HashMap<String, Object> params = new HashMap<String, Object>();
            if (null == getValueBOS.get(i) || !ToolUtil.isNotEmpty(getValueBOS.get(i).getCurrentData()) || null == (getValueData = DataConfigUtil.getDataConfigValue((Ctx)ctx, (ComponentReference)getValueBOS.get(i).getComponentGetData())) || !ToolUtil.isNotEmpty((Object)getValueData.getRenderValue())) continue;
            params.put("getValueData", getValueData.getRenderValue());
            Map<String, Object> resultMap = VoidComponentCodeUtil.getMappingResult(ctx, getValueBOS.get(i).getComponentGetData().getMapping(), getValueBOS.get(i).getComponentGetData());
            params.putAll(resultMap);
            params.put("fromDataItem", getValueData.getRenderValue());
            params.put("fromData", "fromData" + i);
            params.put("fromDataType", getValueData.getDataType().getValue());
            params.put("toDataItem", getValueBOS.get(i).getCurrentData().get(getValueBOS.get(i).getCurrentData().size() - 1));
            VoidComponentCodeUtil.getToDataType(getValueBOS.get(i).getCurrentData(), dataSetAnalysis, dataModelId, params);
            HashMap<String, String> renderMap = new HashMap<String, String>();
            renderMap.put("toDataType", params.get("toDataType").toString());
            renderMap.put("renderStr", RenderUtil.renderTemplate((String)"/template/common/dataitem/api_param_mapping.ftl", params));
            paramRenderStr.put(params.get("toDataItem").toString(), renderMap);
        }
    }

    private static void getToDataType(List<String> dataItemFields, DataSet dataSetAnalysis, String dataModelId, Map<String, Object> params) throws IOException, LcdpException {
        ModelProvideAdapter.adaptor((String)dataModelId).getToDataType(dataItemFields, dataSetAnalysis, dataModelId, params);
    }

    public static Map<String, Object> getMappingResult(Ctx ctx, List<? extends DataItemMappingBO> mapsList, ComponentReference from) throws LcdpException {
        Map<String, Object> resultMap = new HashMap<String, Object>(8);
        if (!from.isConfigComplete(ctx)) {
            return resultMap;
        }
        resultMap.put("type", "simple");
        if (ToolUtil.isNotEmpty(mapsList) && ToolUtil.isNotEmpty((Object)(resultMap = VoidComponentCodeUtil.mapping(ctx, from, mapsList)).get(MAPPING_KEY))) {
            resultMap.put("type", "complex");
        }
        return resultMap;
    }

    private static Map<String, Object> mapping(Ctx ctx, ComponentReference from, List<? extends DataItemMappingBO> mappingList) throws LcdpException {
        HashMap<String, Object> mappingMap = new HashMap<String, Object>(8);
        ArrayList mappingBOS = new ArrayList();
        boolean fromIsComponent = DataFromEnum.INSTANCE.getValue().equals(from.getType());
        boolean toIsComponent = true;
        Map<String, String> fromFieldMapping = MappingUtils.getFieldMapping(from, ctx);
        mappingList.forEach(mappingItem -> {
            DataItemMappingBO<String> mapping;
            if (ToolUtil.isNotEmpty((Object)mappingItem.getFromDataItem()) && ToolUtil.isNotEmpty((Object)mappingItem.getToDataItem()) && null != (mapping = VoidComponentCodeUtil.dealMappingItem(fromIsComponent, toIsComponent, fromFieldMapping, mappingItem))) {
                mappingBOS.add(mapping);
            }
        });
        mappingMap.put(MAPPING_KEY, mappingBOS);
        return mappingMap;
    }

    private static DataItemMappingBO<String> dealMappingItem(boolean fromIsComponent, boolean toIsComponent, Map<String, String> fromFieldMapping, DataItemMappingBO mappingItem) {
        DataItemMappingBO mapping = new DataItemMappingBO();
        boolean canMapping = true;
        if (fromIsComponent) {
            if (ToolUtil.isEmpty(fromFieldMapping) || !fromFieldMapping.containsKey(mappingItem.getFromDataItem().toString())) {
                canMapping = false;
            } else {
                mapping.setFromDataItem((Object)fromFieldMapping.get(mappingItem.getFromDataItem().toString()));
            }
        } else {
            mapping.setFromDataItem((Object)mappingItem.getFromDataItem().toString());
        }
        if (toIsComponent) {
            mapping.setToDataItem((Object)mappingItem.getToDataItem().toString());
        }
        if (canMapping) {
            return mapping;
        }
        return null;
    }

    public static void paramValidationMethod(Map<String, Object> tableMap, LcdpComponent lcdpComponent, Ctx ctx, MethodConfigAnalysis methodConfigAnalysis, DataModelBase dataModelBase) throws LcdpException, IOException {
        FrontParamValidation paramValidation;
        if (ToolUtil.isNotEmpty((Object)methodConfigAnalysis) && ToolUtil.isNotEmpty((Object)(paramValidation = methodConfigAnalysis.getParamValidation()))) {
            List paramValidations;
            if (paramValidation.isFastGenerated()) {
                paramValidations = ModelProvideAdapter.adaptor((String)methodConfigAnalysis.getDataModelId()).getParamValidations(methodConfigAnalysis.getOperationName(), methodConfigAnalysis.getDataModelId());
                for (ParamValidation validation : paramValidations) {
                    VoidComponentCodeUtil.convertValidation(validation);
                }
            } else {
                paramValidations = paramValidation.getParamValidations();
            }
            if (ToolUtil.isNotEmpty(paramValidations)) {
                HashMap validateMethod = new HashMap();
                ArrayList ruleMethods = new ArrayList();
                for (int i = 0; i < paramValidations.size(); ++i) {
                    JSONObject ruleMethod = new JSONObject();
                    ParamValidation validation = (ParamValidation)paramValidations.get(i);
                    List validateRules = validation.getValidateRules();
                    String methodName = VoidComponentCodeUtil.handleRulesMethod(i, validateRules, validation, lcdpComponent, ctx);
                    ruleMethod.put("methodName", methodName);
                    ruleMethod.put("validationData", validation.getValidateData());
                    List<String> validateDataTypes = Arrays.asList(validation.getValidateDataType().split(","));
                    ruleMethod.put("validationDataType", validateDataTypes.get(0));
                    VoidComponentCodeUtil.handleIntegrationMethod(validation.getCondition(), (Map<String, Object>)ruleMethod, lcdpComponent, ctx);
                    Optional.of(ruleMethod.get("validateCode")).ifPresent(validateCode -> ruleMethods.add(validateCode.toString()));
                }
                validateMethod.put("methodCodes", ruleMethods);
                RenderCore renderCore = new RenderCore();
                renderCore.registerParam(validateMethod);
                renderCore.registerTemplatePath("template/elementui/element/ApiComponent/param_validate_method.ftl");
                RenderResult renderResult = renderCore.render();
                if (renderResult.isStatus()) {
                    String methodName = lcdpComponent.getInstanceKey() + "ParamValidation";
                    tableMap.put("paramValidation", methodName);
                    ctx.addMethod(methodName, Collections.singletonList("param"), renderResult.getRenderString());
                }
            }
        }
    }

    private static void convertValidation(ParamValidation validation) {
        Optional<List> validateRulesOpt = Optional.ofNullable(validation.getValidateRules());
        Optional<ConditionBody> conditionOpt = Optional.ofNullable(validation.getCondition());
        validateRulesOpt.ifPresent(paramValidationRules -> {
            Map jsValidationMap = JsValidationType.jsValidationMap;
            for (ParamValidationRule paramValidationRule : paramValidationRules) {
                String validateType = paramValidationRule.getValidateType();
                String validateValue = paramValidationRule.getValidateValue();
                if (!ToolUtil.isNotEmpty((Object)validateType)) continue;
                paramValidationRule.setErrorMsg(VoidComponentCodeUtil.getRuleValueByName(validateValue, "message"));
                if (validateType.equals(RuleTypeEnum.DIGITS.getName())) {
                    String value;
                    paramValidationRule.setValidateType("positiveInteger");
                    paramValidationRule.setValidateValue(((FormCheckObject)jsValidationMap.get("positiveInteger")).getValue());
                    if (!ToolUtil.isNotEmpty((Object)validateValue) || "0".equals(value = VoidComponentCodeUtil.getRuleValueByName(validateValue, "fraction"))) continue;
                    paramValidationRule.setValidateType("decimal");
                    paramValidationRule.setValidateValue(((FormCheckObject)jsValidationMap.get("decimal")).getValue());
                    continue;
                }
                if (validateType.equals(RuleTypeEnum.LENGTH.getName())) {
                    String max = VoidComponentCodeUtil.getRuleValueByName(validateValue, "max");
                    String min = VoidComponentCodeUtil.getRuleValueByName(validateValue, "min");
                    paramValidationRule.setValidateType("length");
                    paramValidationRule.setValidateValue("/^\\\\S{" + min + "," + max + "}$/");
                    continue;
                }
                if (validateType.equals(RuleTypeEnum.PATTERN.getName())) {
                    String pattern = VoidComponentCodeUtil.getRuleValueByName(validateValue, "regexp");
                    paramValidationRule.setValidateType("pattern");
                    paramValidationRule.setValidateValue(pattern);
                    continue;
                }
                paramValidationRule.setValidateType(validateType);
                paramValidationRule.setValidateValue("");
            }
        });
        conditionOpt.map(ConditionBody::getConditions).ifPresent(conditionItems -> {
            for (ConditionItem conditionItem : conditionItems) {
                if (conditionItem.getConnect().equals(BackConditionConnectEnum.EQUAL.getSymbol())) {
                    conditionItem.setConnect(BackConditionConnectEnum.E.getSymbol());
                }
                if (!conditionItem.getConnect().equals(BackConditionConnectEnum.UNEQUAL.getSymbol())) continue;
                conditionItem.setConnect(BackConditionConnectEnum.NE.getSymbol());
            }
        });
    }

    private static String getRuleValueByName(String validateValue, String name) {
        if (!(validateValue = StringUtils.deleteWhitespace((String)validateValue)).contains(name = name + "=")) {
            return "";
        }
        int start = validateValue.indexOf(name) + name.length();
        int nextEqualIndex = StringUtils.indexOf((String)validateValue, (String)"=", (int)start);
        if (nextEqualIndex < 0) {
            return validateValue.substring(start).replace("\"", "");
        }
        char[] array = validateValue.toCharArray();
        int end = start;
        for (int i = 0; i < array.length && array[end = nextEqualIndex - i] != ','; ++i) {
        }
        return validateValue.substring(start, end).replace("\"", "");
    }

    private static void handleIntegrationMethod(ConditionBody condition, Map<String, Object> ruleMethod, LcdpComponent lcdpComponent, Ctx ctx) throws LcdpException {
        String conditionBodyCode = "";
        if (ToolUtil.isNotEmpty((Object)condition)) {
            conditionBodyCode = ConditionUtil.packageConditionBodyCode((Ctx)ctx, (ConditionBody)condition);
        }
        ruleMethod.put("conditionBodyCode", conditionBodyCode);
        RenderCore renderCore = new RenderCore();
        renderCore.registerParam(ruleMethod);
        renderCore.registerTemplatePath("template/elementui/element/ApiComponent/param_validate_method_item.ftl");
        RenderResult renderResult = renderCore.render();
        if (renderResult.isStatus()) {
            ruleMethod.put("validateCode", renderResult.getRenderString());
        }
    }

    private static String handleRulesMethod(int i, List<ParamValidationRule> validateRules, ParamValidation validation, LcdpComponent lcdpComponent, Ctx ctx) throws LcdpException {
        Map jsValidationMap = JsValidationType.jsValidationMap;
        String methodName = "";
        if (ToolUtil.isNotEmpty(validateRules)) {
            String field = VoidComponentCodeUtil.getTitleByField(validation);
            HashMap<String, Object> ruleMap = new HashMap<String, Object>();
            ArrayList<JSONObject> currentRuleResults = new ArrayList<JSONObject>();
            for (ParamValidationRule validateRule : validateRules) {
                List<Map<String, Object>> customFunctionRes;
                FormCheckObject currentRule = (FormCheckObject)jsValidationMap.get(validateRule.getValidateType());
                if (!ToolUtil.isNotEmpty((Object)currentRule)) continue;
                JSONObject currentRuleResult = JSON.parseObject((String)JSON.toJSONString((Object)currentRule));
                if (ToolUtil.isNotEmpty((Object)validateRule.getErrorMsg())) {
                    String errorMsg = validateRule.getErrorMsg();
                    if (errorMsg.contains("${\u5217\u540d}")) {
                        errorMsg = errorMsg.replaceAll("\\$\\{\u5217\u540d}", field);
                    }
                    currentRuleResult.put("errorMsg", (Object)errorMsg);
                } else {
                    currentRuleResult.put("errorMsg", (Object)"");
                }
                currentRuleResult.put("customValue", (Object)validateRule.getValidateValue());
                if (ToolUtil.isNotEmpty((Object)validateRule.getCustomFunction()) && (customFunctionRes = ElementCheckUtil.dealCustomFunction(validateRule.getCustomFunction(), ctx)).size() > 0) {
                    currentRuleResult.putAll(customFunctionRes.get(0));
                }
                currentRuleResults.add(currentRuleResult);
            }
            ruleMap.put("checkList", currentRuleResults);
            ruleMap.put("field", field);
            RenderCore renderCore = new RenderCore();
            renderCore.registerParam(ruleMap);
            renderCore.registerTemplatePath("template/elementui/element/form/form_checkMethod.ftl");
            RenderResult renderResult = renderCore.render();
            if (renderResult.isStatus()) {
                methodName = VoidComponentCodeUtil.handleRuleMethodName(lcdpComponent, validation, i);
                ctx.addMethod(methodName, Collections.singletonList("value"), renderResult.getRenderString());
            }
        }
        return methodName;
    }

    public static String getTitleByField(ParamValidation validation) {
        List validateData = validation.getValidateData();
        if (ToolUtil.isNotEmpty((Object)validateData)) {
            return (String)validateData.get(validateData.size() - 1);
        }
        return "";
    }

    private static String handleRuleMethodName(LcdpComponent lcdpComponent, ParamValidation validation, int i) {
        List validateData = validation.getValidateData();
        StringBuilder nameBuilder = new StringBuilder();
        nameBuilder.append(lcdpComponent.getInstanceKey());
        if (ToolUtil.isNotEmpty((Object)validateData)) {
            if (validateData.size() == 1) {
                nameBuilder.append(NamingStrategy.capitalFirst((String)((String)validateData.get(0)))).append(i);
            } else {
                nameBuilder.append(NamingStrategy.capitalFirst((String)((String)validateData.get(0)))).append(NamingStrategy.capitalFirst((String)((String)validateData.get(1)))).append(i);
            }
        }
        return nameBuilder.toString();
    }
}

