/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.base.common.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.formcheck.ElementCheckAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.constant.CodePrefix;
import com.jxdinfo.hussar.formdesign.codegenerator.core.action.Action;
import com.jxdinfo.hussar.formdesign.codegenerator.core.component.LcdpComponent;
import com.jxdinfo.hussar.formdesign.codegenerator.core.component.visitor.BaseProvideVisitor;
import com.jxdinfo.hussar.formdesign.codegenerator.core.component.visitor.InterActiveVisitor;
import com.jxdinfo.hussar.formdesign.codegenerator.core.component.visitor.ValueVisitor;
import com.jxdinfo.hussar.formdesign.codegenerator.core.ctx.Ctx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.render.RenderCore;
import com.jxdinfo.hussar.formdesign.common.render.RenderResult;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import java.util.HashMap;

public class MobileCheckUtil {
    public static void checkCodeGen(Action action, Ctx ctx) throws LcdpException {
        HashMap<String, String> checkMap = new HashMap<String, String>();
        RenderCore renderCore = new RenderCore();
        renderCore.registerTemplatePath("/template/common/event/CommonCheck.ftl");
        LcdpComponent myLcdpComponent = action.getCurrentLcdpComponent();
        String trigger = action.getTrigger();
        String triggerName = myLcdpComponent.getInstanceKey() + ToolUtil.firstLetterToUpper((String)trigger);
        ElementCheckAnalysis elementCheckAnalysis = (ElementCheckAnalysis)JSONObject.parseObject((String)JSON.toJSONString(action.getParamValues().get("inputCheck")), ElementCheckAnalysis.class);
        String successOperation = "";
        String errorOperation = "";
        if (ToolUtil.isNotEmpty((Object)elementCheckAnalysis)) {
            if (ToolUtil.isNotEmpty((Object)elementCheckAnalysis.getSuccess())) {
                InterActiveVisitor interActiveVisitor;
                String successInstanceKey = elementCheckAnalysis.getSuccess();
                LcdpComponent successComponent = (LcdpComponent)ctx.getComponentMap().get(successInstanceKey);
                if (ToolUtil.isNotEmpty((Object)successComponent) && ToolUtil.isNotEmpty((Object)(interActiveVisitor = (InterActiveVisitor)successComponent.getProvideVisitor("interActive")))) {
                    successComponent.accept((BaseProvideVisitor)interActiveVisitor, ctx, null);
                    String unset = interActiveVisitor.unSetInterActive(CodePrefix._CHECK_BAD.getType());
                    String set = interActiveVisitor.setInterActive(CodePrefix._CHECK_BAD.getType());
                    if (ToolUtil.isNotEmpty((Object)unset)) {
                        successOperation = successOperation + unset;
                    }
                    if (ToolUtil.isNotEmpty((Object)set)) {
                        errorOperation = errorOperation + set;
                    }
                }
            }
            if (ToolUtil.isNotEmpty((Object)elementCheckAnalysis.getError())) {
                ValueVisitor valueVisitor;
                String errorInstanceKey = elementCheckAnalysis.getError();
                LcdpComponent errorComponent = (LcdpComponent)ctx.getComponentMap().get(errorInstanceKey);
                if (ToolUtil.isNotEmpty((Object)errorComponent) && ToolUtil.isNotEmpty((Object)(valueVisitor = (ValueVisitor)errorComponent.getProvideVisitor("value")))) {
                    errorComponent.accept((BaseProvideVisitor)valueVisitor, ctx, null);
                    String value = valueVisitor.getDataItemValue(null).getRenderValue();
                    value = value.replace(CodePrefix._SELF.getType(), "");
                    if (ToolUtil.isNotEmpty((Object)value)) {
                        successOperation = successOperation + CodePrefix._SELF.getType() + value + " = '';";
                        errorOperation = errorOperation + CodePrefix._SELF.getType() + value + " = errorMsg;";
                    }
                }
            }
        }
        checkMap.put("success", successOperation);
        checkMap.put("error", errorOperation);
        renderCore.registerParam(checkMap);
        RenderResult renderResult = renderCore.render();
        if (renderResult.isStatus()) {
            ctx.addMethod(trigger, triggerName, renderResult.getRenderString());
        }
    }

    public static void checkErrorCodeGen(Action action, Ctx ctx) throws LcdpException {
        HashMap<String, Object> checkMap = new HashMap<String, Object>();
        RenderCore renderCore = new RenderCore();
        renderCore.registerTemplatePath("/template/common/event/MobileErrorCheck.ftl");
        LcdpComponent myLcdpComponent = action.getCurrentLcdpComponent();
        String trigger = action.getTrigger();
        String triggerName = myLcdpComponent.getInstanceKey() + ToolUtil.firstLetterToUpper((String)trigger);
        ElementCheckAnalysis elementCheckAnalysis = (ElementCheckAnalysis)JSONObject.parseObject((String)JSON.toJSONString(action.getParamValues().get("inputCheck")), ElementCheckAnalysis.class);
        JSONObject checkMsg = (JSONObject)action.getParamValues().get("inputCheckMsg");
        if (ToolUtil.isNotEmpty((Object)checkMsg) && ToolUtil.isNotEmpty((Object)checkMsg.get((Object)"from"))) {
            JSONObject from = (JSONObject)checkMsg.get((Object)"from");
            checkMap.put("errorMsg", from.get((Object)"configData"));
            if ("eventParam".equals(from.get((Object)"type"))) {
                checkMap.put("isEventParam", "isEventParam");
                JSONArray eventParamData = (JSONArray)from.get((Object)"eventParamData");
                if (ToolUtil.isNotEmpty((Object)eventParamData)) {
                    checkMap.put("errorMsg", eventParamData.get(0));
                }
            }
        }
        String errorOperation = "";
        if (ToolUtil.isNotEmpty((Object)elementCheckAnalysis) && ToolUtil.isNotEmpty((Object)elementCheckAnalysis.getSuccess())) {
            InterActiveVisitor interActiveVisitor;
            String successInstanceKey = elementCheckAnalysis.getSuccess();
            LcdpComponent successComponent = (LcdpComponent)ctx.getComponentMap().get(successInstanceKey);
            if (ToolUtil.isNotEmpty((Object)successComponent) && ToolUtil.isNotEmpty((Object)(interActiveVisitor = (InterActiveVisitor)successComponent.getProvideVisitor("interActive")))) {
                successComponent.accept((BaseProvideVisitor)interActiveVisitor, ctx, null);
                String set = interActiveVisitor.setInterActive(CodePrefix._CHECK_BAD.getType());
                if (ToolUtil.isNotEmpty((Object)set)) {
                    errorOperation = errorOperation + set;
                }
            }
        }
        checkMap.put("setErrorState", errorOperation);
        ctx.addImports("import { Dialog } from 'vant'");
        renderCore.registerParam(checkMap);
        RenderResult renderResult = renderCore.render();
        if (renderResult.isStatus()) {
            ctx.addMethod(trigger, triggerName, renderResult.getRenderString());
        }
    }

    public static void checkSuccessCodeGen(Action action, Ctx ctx) throws LcdpException {
        HashMap<String, String> checkMap = new HashMap<String, String>();
        RenderCore renderCore = new RenderCore();
        renderCore.registerTemplatePath("/template/common/event/MobileSuccessCheck.ftl");
        LcdpComponent myLcdpComponent = action.getCurrentLcdpComponent();
        String trigger = action.getTrigger();
        String triggerName = myLcdpComponent.getInstanceKey() + ToolUtil.firstLetterToUpper((String)trigger);
        ElementCheckAnalysis elementCheckAnalysis = (ElementCheckAnalysis)JSONObject.parseObject((String)JSON.toJSONString(action.getParamValues().get("inputCheck")), ElementCheckAnalysis.class);
        String successOperation = "";
        String styleId = "";
        if (ToolUtil.isNotEmpty((Object)elementCheckAnalysis) && ToolUtil.isNotEmpty((Object)elementCheckAnalysis.getSuccess())) {
            InterActiveVisitor interActiveVisitor;
            String successInstanceKey = elementCheckAnalysis.getSuccess();
            LcdpComponent successComponent = (LcdpComponent)ctx.getComponentMap().get(successInstanceKey);
            styleId = styleId + ctx.getPageName() + "_" + successInstanceKey;
            if (ToolUtil.isNotEmpty((Object)successComponent) && ToolUtil.isNotEmpty((Object)(interActiveVisitor = (InterActiveVisitor)successComponent.getProvideVisitor("interActive")))) {
                successComponent.accept((BaseProvideVisitor)interActiveVisitor, ctx, null);
                String unSet = interActiveVisitor.unSetInterActive(CodePrefix._CHECK_BAD.getType());
                if (ToolUtil.isNotEmpty((Object)unSet)) {
                    successOperation = successOperation + unSet;
                }
            }
        }
        checkMap.put("styleId", styleId);
        checkMap.put("setSuccessState", successOperation);
        renderCore.registerParam(checkMap);
        RenderResult renderResult = renderCore.render();
        if (renderResult.isStatus()) {
            ctx.addMethod(trigger, triggerName, renderResult.getRenderString());
        }
    }
}

