/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.base.common.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.formcheck.ElementCheckAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.constant.CodePrefix;
import com.jxdinfo.hussar.formdesign.codegenerator.core.action.Action;
import com.jxdinfo.hussar.formdesign.codegenerator.core.component.LcdpComponent;
import com.jxdinfo.hussar.formdesign.codegenerator.core.component.visitor.BaseProvideVisitor;
import com.jxdinfo.hussar.formdesign.codegenerator.core.component.visitor.InterActiveVisitor;
import com.jxdinfo.hussar.formdesign.codegenerator.core.component.visitor.ValueVisitor;
import com.jxdinfo.hussar.formdesign.codegenerator.core.ctx.Ctx;
import com.jxdinfo.hussar.formdesign.codegenerator.core.data.model.ComponentReference;
import com.jxdinfo.hussar.formdesign.codegenerator.core.model.ComponentData;
import com.jxdinfo.hussar.formdesign.codegenerator.core.util.DataConfigUtil;
import com.jxdinfo.hussar.formdesign.codegenerator.core.util.ExtendCommonUtil;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.render.RenderCore;
import com.jxdinfo.hussar.formdesign.common.render.RenderResult;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ElementCheckUtil {
    public static void checkCodeGen(Action action, Ctx ctx) throws LcdpException {
        HashMap<String, String> checkMap = new HashMap<String, String>();
        RenderCore renderCore = new RenderCore();
        renderCore.registerTemplatePath("/template/common/event/CommonCheck.ftl");
        LcdpComponent myLcdpComponent = action.getCurrentLcdpComponent();
        String trigger = action.getTrigger();
        String triggerName = myLcdpComponent.getInstanceKey() + ToolUtil.firstLetterToUpper((String)trigger);
        ElementCheckAnalysis elementCheckAnalysis = (ElementCheckAnalysis)JSONObject.parseObject((String)JSON.toJSONString(action.getParamValues().get("inputCheck")), ElementCheckAnalysis.class);
        String successOperation = "";
        String errorOperation = "";
        if (ToolUtil.isNotEmpty((Object)elementCheckAnalysis)) {
            if (ToolUtil.isNotEmpty((Object)elementCheckAnalysis.getSuccess())) {
                InterActiveVisitor interActiveVisitor;
                String successInstanceKey = elementCheckAnalysis.getSuccess();
                LcdpComponent successComponent = (LcdpComponent)ctx.getComponentMap().get(successInstanceKey);
                if (ToolUtil.isNotEmpty((Object)successComponent) && ToolUtil.isNotEmpty((Object)(interActiveVisitor = (InterActiveVisitor)successComponent.getProvideVisitor("interActive")))) {
                    successComponent.accept((BaseProvideVisitor)interActiveVisitor, ctx, null);
                    String unset = interActiveVisitor.unSetInterActive(CodePrefix._CHECK_BAD.getType());
                    String set = interActiveVisitor.setInterActive(CodePrefix._CHECK_BAD.getType());
                    if (ToolUtil.isNotEmpty((Object)unset)) {
                        successOperation = successOperation + unset;
                    }
                    if (ToolUtil.isNotEmpty((Object)set)) {
                        errorOperation = errorOperation + set;
                    }
                }
            }
            if (ToolUtil.isNotEmpty((Object)elementCheckAnalysis.getError())) {
                ValueVisitor valueVisitor;
                String errorInstanceKey = elementCheckAnalysis.getError();
                LcdpComponent errorComponent = (LcdpComponent)ctx.getComponentMap().get(errorInstanceKey);
                if (ToolUtil.isNotEmpty((Object)errorComponent) && ToolUtil.isNotEmpty((Object)(valueVisitor = (ValueVisitor)errorComponent.getProvideVisitor("value")))) {
                    errorComponent.accept((BaseProvideVisitor)valueVisitor, ctx, null);
                    String value = valueVisitor.getDataItemValue(null).getRenderValue();
                    value = value.replace(CodePrefix._SELF.getType(), "");
                    if (ToolUtil.isNotEmpty((Object)value)) {
                        successOperation = successOperation + CodePrefix._SELF.getType() + value + " = '';";
                        errorOperation = errorOperation + CodePrefix._SELF.getType() + value + " = errorMsg;";
                    }
                }
            }
        }
        checkMap.put("success", successOperation);
        checkMap.put("error", errorOperation);
        renderCore.registerParam(checkMap);
        RenderResult renderResult = renderCore.render();
        if (renderResult.isStatus()) {
            ctx.addMethod(trigger, triggerName, renderResult.getRenderString());
        }
    }

    public static void checkErrorCodeGen(Action action, Ctx ctx) throws LcdpException {
        HashMap<String, Object> checkMap = new HashMap<String, Object>();
        RenderCore renderCore = new RenderCore();
        renderCore.registerTemplatePath("/template/common/event/ErrorCheck.ftl");
        LcdpComponent myLcdpComponent = action.getCurrentLcdpComponent();
        String trigger = action.getTrigger();
        String triggerName = myLcdpComponent.getInstanceKey() + ToolUtil.firstLetterToUpper((String)trigger);
        ElementCheckAnalysis elementCheckAnalysis = (ElementCheckAnalysis)JSONObject.parseObject((String)JSON.toJSONString(action.getParamValues().get("inputCheck")), ElementCheckAnalysis.class);
        JSONObject checkMsg = (JSONObject)action.getParamValues().get("inputCheckMsg");
        if (ToolUtil.isNotEmpty((Object)checkMsg) && ToolUtil.isNotEmpty((Object)checkMsg.get((Object)"from"))) {
            JSONObject from = (JSONObject)checkMsg.get((Object)"from");
            checkMap.put("errorMsg", from.get((Object)"configData"));
            if ("eventParam".equals(from.get((Object)"type"))) {
                checkMap.put("isEventParam", "isEventParam");
                JSONArray eventParamData = (JSONArray)from.get((Object)"eventParamData");
                if (ToolUtil.isNotEmpty((Object)eventParamData)) {
                    checkMap.put("errorMsg", eventParamData.get(0));
                }
            }
        }
        HashMap<Object, String> errorOperation = new HashMap<Object, String>();
        List<Object> successInstanceKeys = new ArrayList();
        if (ToolUtil.isNotEmpty((Object)elementCheckAnalysis) && ToolUtil.isNotEmpty((Object)elementCheckAnalysis.getSuccess())) {
            String successInstanceKey = elementCheckAnalysis.getSuccess();
            successInstanceKeys = Arrays.asList(successInstanceKey.split(","));
            for (int i = 0; i < successInstanceKeys.size(); ++i) {
                InterActiveVisitor interActiveVisitor;
                LcdpComponent successComponent = (LcdpComponent)ctx.getComponentMap().get(successInstanceKeys.get(i));
                if (!ToolUtil.isNotEmpty((Object)successComponent) || !ToolUtil.isNotEmpty((Object)(interActiveVisitor = (InterActiveVisitor)successComponent.getProvideVisitor("interActive")))) continue;
                successComponent.accept((BaseProvideVisitor)interActiveVisitor, ctx, null);
                String set = interActiveVisitor.setInterActive(CodePrefix._CHECK_BAD.getType());
                if (!ToolUtil.isNotEmpty((Object)set)) continue;
                errorOperation.put(successInstanceKeys.get(i), set);
            }
        }
        ctx.addImports("import { validate } from 'hussar-base'");
        for (Map.Entry entry : errorOperation.entrySet()) {
            String styleId = "";
            String cssPrefix = "";
            styleId = styleId + ctx.getPageName() + "_" + (String)entry.getKey();
            cssPrefix = cssPrefix + "." + ctx.getPageName() + " ." + (String)entry.getKey();
            ctx.addDestroyeds("validate.removeLink('" + styleId + "');");
            checkMap.put("styleId", styleId);
            checkMap.put("cssPrefix", cssPrefix);
            checkMap.put("setErrorState", entry.getValue());
            checkMap.put("checkKey", entry.getKey());
            checkMap.put("onlyInfo", action.getActionQualifiedName().equals("Base.SetErrorInfoAction"));
            renderCore.registerParam(checkMap);
            RenderResult renderResult = renderCore.render();
            if (!renderResult.isStatus()) continue;
            ctx.addMethod(trigger, triggerName, renderResult.getRenderString());
        }
    }

    public static void checkSuccessCodeGen(Action action, Ctx ctx) throws LcdpException {
        HashMap<String, Object> checkMap = new HashMap<String, Object>();
        RenderCore renderCore = new RenderCore();
        renderCore.registerTemplatePath("/template/common/event/SuccessCheck.ftl");
        LcdpComponent myLcdpComponent = action.getCurrentLcdpComponent();
        String trigger = action.getTrigger();
        String triggerName = myLcdpComponent.getInstanceKey() + ToolUtil.firstLetterToUpper((String)trigger);
        ElementCheckAnalysis elementCheckAnalysis = (ElementCheckAnalysis)JSONObject.parseObject((String)JSON.toJSONString(action.getParamValues().get("inputCheck")), ElementCheckAnalysis.class);
        HashMap<Object, String> successOperation = new HashMap<Object, String>();
        List<Object> successInstanceKeys = new ArrayList();
        if (ToolUtil.isNotEmpty((Object)elementCheckAnalysis) && ToolUtil.isNotEmpty((Object)elementCheckAnalysis.getSuccess())) {
            String successInstanceKey = elementCheckAnalysis.getSuccess();
            successInstanceKeys = Arrays.asList(successInstanceKey.split(","));
            for (int i = 0; i < successInstanceKeys.size(); ++i) {
                InterActiveVisitor interActiveVisitor;
                LcdpComponent successComponent = (LcdpComponent)ctx.getComponentMap().get(successInstanceKeys.get(i));
                if (!ToolUtil.isNotEmpty((Object)successComponent) || !ToolUtil.isNotEmpty((Object)(interActiveVisitor = (InterActiveVisitor)successComponent.getProvideVisitor("interActive")))) continue;
                successComponent.accept((BaseProvideVisitor)interActiveVisitor, ctx, null);
                String unSet = interActiveVisitor.unSetInterActive(CodePrefix._CHECK_BAD.getType());
                if (!ToolUtil.isNotEmpty((Object)unSet)) continue;
                successOperation.put(successInstanceKeys.get(i), unSet);
            }
        }
        for (Map.Entry entry : successOperation.entrySet()) {
            String styleId = "";
            styleId = styleId + ctx.getPageName() + "_" + (String)entry.getKey();
            checkMap.put("styleId", styleId);
            checkMap.put("setSuccessState", entry.getValue());
            checkMap.put("onlyInfo", action.getActionQualifiedName().equals("Base.UnsetErrorInfoAction"));
            renderCore.registerParam(checkMap);
            RenderResult renderResult = renderCore.render();
            if (!renderResult.isStatus()) continue;
            ctx.addMethod(trigger, triggerName, renderResult.getRenderString());
        }
    }

    public static List<Map<String, Object>> dealCustomFunction(List<Map<String, Object>> customFunction, Ctx ctx) throws LcdpException {
        ArrayList<Map<String, Object>> customFuncConfig = new ArrayList<Map<String, Object>>();
        if (ToolUtil.isNotEmpty(customFunction)) {
            for (Map<String, Object> objectMap : customFunction) {
                HashMap<String, Object> customFuncConfigMap = new HashMap<String, Object>();
                customFuncConfigMap.put("functionName", objectMap.get("functionName"));
                customFuncConfigMap.put("fileIdentify", objectMap.get("fileIdentify"));
                List paramList = (List)objectMap.get("params");
                ArrayList<String> paramName = new ArrayList<String>();
                if (ToolUtil.isNotEmpty((Object)paramList)) {
                    for (Map stringObjectMap : paramList) {
                        ComponentReference componentReference = (ComponentReference)JSON.parseObject((String)stringObjectMap.toString(), ComponentReference.class);
                        ComponentData paramData = DataConfigUtil.getDataConfigValue((Ctx)ctx, (ComponentReference)componentReference);
                        if (null != paramData) {
                            paramName.add(paramData.getRenderValue());
                            continue;
                        }
                        paramName.add("''");
                    }
                }
                customFuncConfigMap.put("paramName", paramName);
                customFuncConfig.add(customFuncConfigMap);
                if (objectMap.get("id") == null || objectMap.get("fileIdentify") == null) continue;
                ExtendCommonUtil.addExtendJsImport((Ctx)ctx, (String)objectMap.get("id").toString(), (String)objectMap.get("fileIdentify").toString());
            }
        }
        return customFuncConfig;
    }
}

