/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.base.common.event;

import com.jxdinfo.hussar.formdesign.codegenerator.core.action.Action;
import com.jxdinfo.hussar.formdesign.codegenerator.core.action.visitor.ActionVisitor;
import com.jxdinfo.hussar.formdesign.codegenerator.core.component.LcdpComponent;
import com.jxdinfo.hussar.formdesign.codegenerator.core.ctx.Ctx;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.render.RenderCore;
import com.jxdinfo.hussar.formdesign.common.render.RenderResult;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="Base.AddFlowFormAction")
public class AddFlowForm
implements ActionVisitor {
    private final FileMappingService fileMappingService;

    @Autowired
    public AddFlowForm(FileMappingService fileMappingService) {
        this.fileMappingService = fileMappingService;
    }

    public void visitor(Action action, Ctx ctx) throws Exception {
        HashMap<String, Object> moduleMap = new HashMap<String, Object>();
        RenderCore renderCore = new RenderCore();
        String pageType = ctx.getPageInfo().getType();
        if ("MobilePage".equals(pageType)) {
            renderCore.registerTemplatePath("/template/common/event/AddMobileFlowForm.ftl");
        } else {
            renderCore.registerTemplatePath("/template/common/event/AddFlowForm.ftl");
        }
        LcdpComponent myLcdpComponent = action.getCurrentLcdpComponent();
        String trigger = action.getTrigger();
        String triggerName = myLcdpComponent.getInstanceKey() + ToolUtil.firstLetterToUpper((String)trigger);
        moduleMap.put("trigger", triggerName);
        String rootKey = ctx.getRootLcdpComponent().getInstanceKey();
        moduleMap.put("rootKey", rootKey);
        Map params = action.getParamValues();
        Map addForm = new HashMap();
        Map addFlow = new HashMap();
        if (ToolUtil.isNotEmpty((Object)params)) {
            if (ToolUtil.isNotEmpty(params.get("addForm"))) {
                addForm = (Map)params.get("addForm");
            }
            if (ToolUtil.isNotEmpty(params.get("addFlow"))) {
                addFlow = (Map)params.get("addFlow");
            }
        }
        if (ToolUtil.isNotEmpty(addForm)) {
            if (ToolUtil.isNotEmpty(addForm.get("jumpType"))) {
                moduleMap.put("jumpType", addForm.get("jumpType"));
            }
            if (ToolUtil.isNotEmpty(addForm.get("id"))) {
                moduleMap.put("version", "old");
                String id = (String)addForm.get("id");
                String routerPath = FileUtil.posixPath((String[])new String[]{"${PREFIX.pathName}", this.fileMappingService.getFormatPath(id)});
                moduleMap.put("url", routerPath);
            } else if (ToolUtil.isNotEmpty(addForm.get("openType"))) {
                String dialogId;
                moduleMap.put("version", "new");
                String openType = (String)addForm.get("openType");
                moduleMap.put("openType", openType);
                if ("page".equals(addForm.get("openType")) && !"".equals(addForm.get("openPage"))) {
                    String id;
                    Map openPageMap = (Map)addForm.get("openPage");
                    if (ToolUtil.isNotEmpty((Object)openPageMap) && ToolUtil.isNotEmpty((Object)(id = (String)openPageMap.get("id")))) {
                        String routerPath = FileUtil.posixPath((String[])new String[]{"${PREFIX.pathName}", this.fileMappingService.getFormatPath(id)});
                        moduleMap.put("url", routerPath);
                    }
                } else if ("dialog".equals(addForm.get("openType")) && ToolUtil.isNotEmpty((Object)(dialogId = (String)addForm.get("openDialog")))) {
                    LcdpComponent dialogComponent = (LcdpComponent)ctx.getComponentMap().get(dialogId);
                    Map childrenComponentsMap = dialogComponent.getChildrenComponents();
                    if (ToolUtil.isNotEmpty((Object)childrenComponentsMap)) {
                        List childrenComponentsList = (List)childrenComponentsMap.get("default");
                        List<Map<String, String>> flowComponentsId = this.getFlowComponentsId(childrenComponentsList);
                        moduleMap.put("flowComponentsId", flowComponentsId);
                    }
                    moduleMap.put("dialogId", dialogId);
                }
            }
        }
        if (ToolUtil.isNotEmpty(addFlow)) {
            String flowKey = (String)addFlow.get("identity");
            moduleMap.put("flowKey", flowKey);
        }
        renderCore.registerParam(moduleMap);
        RenderResult renderResult = renderCore.render();
        if (renderResult.isStatus()) {
            ctx.addMethod(triggerName, renderResult.getRenderString());
        }
    }

    public List<Map<String, String>> getFlowComponentsId(List<LcdpComponent> childrenComponentsList) {
        ArrayList<Map<String, String>> flowComponentsId = new ArrayList<Map<String, String>>();
        for (LcdpComponent lcdp : childrenComponentsList) {
            Map childrenComponentsMap;
            HashMap<String, String> flowComponentMap;
            if ("com.jxdinfo.elementui.JXDElFlowSelect".equals(lcdp.getName()) || "com.jxdinfo.ionicui.JXDIonFlowSelect".equals(lcdp.getName()) || "com.jxdinfo.elementui.JXDElRejectNode".equals(lcdp.getName())) {
                flowComponentMap = new HashMap<String, String>();
                flowComponentMap.put("type", "flowSelect");
                flowComponentMap.put("instanceKey", lcdp.getInstanceKey());
                flowComponentsId.add(flowComponentMap);
            }
            if ("com.jxdinfo.elementui.JXDElWorkflowHistoryTable".equals(lcdp.getName())) {
                flowComponentMap = new HashMap();
                flowComponentMap.put("type", "elementWorkflowHistoryTable");
                flowComponentMap.put("instanceKey", lcdp.getInstanceKey());
                flowComponentsId.add(flowComponentMap);
            }
            if ("com.jxdinfo.elementui.JXDElParticipantInput".equals(lcdp.getName()) && ToolUtil.isNotEmpty(lcdp.getProps().get("isAssignParticipant")) && ((Boolean)lcdp.getProps().get("isAssignParticipant")).booleanValue()) {
                flowComponentMap = new HashMap();
                flowComponentMap.put("type", "participantInput");
                flowComponentMap.put("instanceKey", lcdp.getInstanceKey());
                flowComponentsId.add(flowComponentMap);
            }
            if ("com.jxdinfo.ionicui.JXDIonWorkflowHistoryList".equals(lcdp.getName())) {
                flowComponentMap = new HashMap();
                flowComponentMap.put("type", "ionicWorkflowHistoryTable");
                flowComponentMap.put("instanceKey", lcdp.getInstanceKey());
                flowComponentsId.add(flowComponentMap);
            }
            if ("com.jxdinfo.elementui.JXDElCommentEcho".equals(lcdp.getName())) {
                flowComponentMap = new HashMap();
                flowComponentMap.put("type", "commentEcho");
                flowComponentMap.put("instanceKey", lcdp.getInstanceKey());
                flowComponentsId.add(flowComponentMap);
            }
            if ((childrenComponentsMap = lcdp.getChildrenComponents()) == null) continue;
            List childComponentsList = (List)childrenComponentsMap.get("default");
            List<Map<String, String>> flowChildComponentsId = this.getFlowComponentsId(childComponentsList);
            flowComponentsId.addAll(flowChildComponentsId);
        }
        return flowComponentsId;
    }
}

