/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.base.config.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.formdesign.base.config.dao.FlowAuthConfigMapper;
import com.jxdinfo.hussar.formdesign.base.config.model.FlowAuth;
import com.jxdinfo.hussar.formdesign.base.config.service.FlowAuthConfigService;
import com.jxdinfo.hussar.formdesign.codegenerator.core.component.CommonState;
import com.jxdinfo.hussar.formdesign.codegenerator.core.condition.ConditionBody;
import com.jxdinfo.hussar.formdesign.codegenerator.core.condition.ConditionItem;
import com.jxdinfo.hussar.formdesign.codegenerator.core.condition.ConditionParam;
import com.jxdinfo.hussar.formdesign.codegenerator.core.data.model.ComponentReference;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.workflow.manage.engine.service.SysActFormAuthApiService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FlowAuthConfigServiceImpl
extends ServiceImpl<FlowAuthConfigMapper, FlowAuth>
implements FlowAuthConfigService {
    @Autowired
    SysActFormAuthApiService sysActFormAuthApiService;

    @Override
    public List<FlowAuth> getAllAuthConfigs(String formName, String processKey, String formType, String taskDefinitionKey) {
        String formTypeStr;
        if ("2".equals(formType)) {
            formType = "1";
        }
        if ("0".equals(formType)) {
            formType = "2";
        }
        String string = formTypeStr = ToolUtil.isNotEmpty((Object)formType) ? formType : "2";
        if (ToolUtil.isNotEmpty((Object)taskDefinitionKey)) {
            return JSONArray.parseArray((String)JSON.toJSONString((Object)this.sysActFormAuthApiService.initList(formName, processKey, formTypeStr, taskDefinitionKey)), FlowAuth.class);
        }
        List list = JSONArray.parseArray((String)JSON.toJSONString((Object)this.sysActFormAuthApiService.initList(formName, processKey, formTypeStr, null)), FlowAuth.class);
        if (list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                if (!ToolUtil.isEmpty((Object)((FlowAuth)((Object)list.get(i))).getTaskDefinitionKey())) continue;
                ((FlowAuth)((Object)list.get(i))).setTaskDefinitionKey("");
            }
        }
        return list;
    }

    @Override
    public FormDesignResponse<Void> saveAuthConfigs(Map<String, Object> paramMap) throws LcdpException {
        boolean isAdd;
        Map pageState = (Map)JSON.parseObject((String)JSON.toJSONString((Object)paramMap.get("pageState")), (TypeReference)new TypeReference<HashMap<String, CommonState>>(){}, (Feature[])new Feature[0]);
        FormDesignResponse speedCodeResponse = new FormDesignResponse();
        ArrayList<FlowAuth> insertAuth = new ArrayList<FlowAuth>();
        String formId = (String)paramMap.get("formId");
        FileMappingService fileMappingService = (FileMappingService)SpringUtil.getBean(FileMappingService.class);
        String pageNameWithModule = fileMappingService.getCamelFileNameWithModule(formId);
        for (Map.Entry entry : pageState.entrySet()) {
            String formType = "";
            CommonState state = (CommonState)entry.getValue();
            FlowAuth curFlowAuth = new FlowAuth();
            curFlowAuth.setFormName(pageNameWithModule);
            Map<String, String> conditionDeal = this.conditionParam(state.getCondition());
            curFlowAuth.setProcessKey(conditionDeal.get("processDefinitionKey"));
            if (ToolUtil.isNotEmpty((Object)conditionDeal.get("taskDefinitionKey"))) {
                curFlowAuth.setTaskDefinitionKey(conditionDeal.get("taskDefinitionKey"));
            } else {
                curFlowAuth.setTaskDefinitionKey("");
            }
            if (ToolUtil.isNotEmpty((Object)conditionDeal.get("doneListIdentification"))) {
                formType = conditionDeal.get("doneListIdentification");
                curFlowAuth.setFormType(conditionDeal.get("doneListIdentification"));
            }
            if (state.getInstances().size() > 0) {
                if (ToolUtil.isNotEmpty(state.getInstances().get("disabled")) && ((List)state.getInstances().get("disabled")).size() > 0) {
                    curFlowAuth.setInsDisabled(JSON.toJSONString(state.getInstances().get("disabled")));
                }
                if (ToolUtil.isNotEmpty(state.getInstances().get("hide")) && ((List)state.getInstances().get("hide")).size() > 0) {
                    curFlowAuth.setInsHidden(JSON.toJSONString(state.getInstances().get("hide")));
                }
                if (ToolUtil.isNotEmpty(state.getInstances().get("notCheck")) && ((List)state.getInstances().get("notCheck")).size() > 0) {
                    curFlowAuth.setInsNotCheck(JSON.toJSONString(state.getInstances().get("notCheck")));
                    curFlowAuth.setFormCheckParam(JSON.toJSONString((Object)state.getFormCheckParam()));
                }
            }
            insertAuth.add(curFlowAuth);
            this.sysActFormAuthApiService.removeAuth(pageNameWithModule, formType, conditionDeal.get("processDefinitionKey"));
        }
        if (insertAuth.size() > 0 && (isAdd = this.sysActFormAuthApiService.saveOrUpdateAuth(JSONArray.parseArray((String)JSON.toJSONString(insertAuth))))) {
            return speedCodeResponse;
        }
        speedCodeResponse.setErrorCode(500);
        speedCodeResponse.setErrorMsg("\u5de5\u4f5c\u6d41\u6743\u9650\u4fdd\u5b58\u5931\u8d25\uff01");
        return speedCodeResponse;
    }

    @Override
    public List<FlowAuth> getAllAuthConfigsByFormId(String formId, String processKey, String formType, String taskDefinitionKey) throws LcdpException {
        QueryWrapper flowAuthWrapper = new QueryWrapper();
        FileMappingService fileMappingService = (FileMappingService)SpringUtil.getBean(FileMappingService.class);
        String pageNameWithModule = fileMappingService.getCamelFileNameWithModule(formId);
        flowAuthWrapper.eq(ToolUtil.isNotEmpty((Object)processKey), (Object)"FORM_NAME", (Object)pageNameWithModule);
        flowAuthWrapper.eq(ToolUtil.isNotEmpty((Object)processKey), (Object)"PROCESS_DEFINITION_KEY", (Object)processKey);
        flowAuthWrapper.eq((Object)"FORM_TYPE", (Object)formType);
        List result = JSONArray.parseArray((String)JSON.toJSONString((Object)this.sysActFormAuthApiService.initList(pageNameWithModule, processKey, formType, null)), FlowAuth.class);
        return result;
    }

    private Map<String, String> conditionParam(ConditionBody condition) {
        HashMap<String, String> res = new HashMap<String, String>();
        Map<String, ComponentReference> params = this.paramsToMapType(condition.getParams());
        for (ConditionItem item : condition.getConditions()) {
            String leftParamId = item.getLeftParam();
            String rightParamId = item.getRightParam();
            ComponentReference leftParam = params.get(leftParamId);
            ComponentReference rightParam = params.get(rightParamId);
            if (leftParam.getType().equals("pageParam") && leftParam.getConfigData().equals("processDefinitionKey")) {
                res.put("processDefinitionKey", rightParam.getConfigData());
                continue;
            }
            if (leftParam.getType().equals("bpmNode")) {
                if (rightParam.getConfigData().equals("''")) {
                    res.put("taskDefinitionKey", "");
                    continue;
                }
                res.put("taskDefinitionKey", rightParam.getConfigData());
                continue;
            }
            if (!leftParam.getType().equals("input") || !leftParam.getConfigData().equals("self.$route.query.doneListIdentification")) continue;
            if (item.getConnect().equals("===")) {
                res.put("doneListIdentification", rightParam.getConfigData());
                continue;
            }
            res.put("doneListIdentification", "2");
        }
        return res;
    }

    private Map<String, ComponentReference> paramsToMapType(List<ConditionParam> params) {
        HashMap<String, ComponentReference> paramsRes = new HashMap<String, ComponentReference>();
        for (ConditionParam param : params) {
            paramsRes.put(param.getId(), param.getParamData());
        }
        return paramsRes;
    }
}

