/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.base.common.event.apiInvoke.entity;

import com.jxdinfo.hussar.formdesign.back.model.apiModel.ApiDatasetIdName;
import com.jxdinfo.hussar.formdesign.base.common.event.apiInvoke.model.ApiActionModel;
import com.jxdinfo.hussar.formdesign.base.common.event.apiInvoke.model.ApiParamModel;
import com.jxdinfo.hussar.formdesign.base.common.event.apiInvoke.templateParam.ApiBaseTypeParam;
import com.jxdinfo.hussar.formdesign.base.common.event.apiInvoke.templateParam.ApiBodyTypeParam;
import com.jxdinfo.hussar.formdesign.base.common.event.apiInvoke.templateParam.ApiObjectTypeParam;
import com.jxdinfo.hussar.formdesign.base.common.event.apiInvoke.templateParam.ApiRequestParam;
import com.jxdinfo.hussar.formdesign.base.common.event.apiInvoke.templateParam.WebTemplateParam;
import com.jxdinfo.hussar.formdesign.base.common.utils.MappingUtils;
import com.jxdinfo.hussar.formdesign.codegenerator.core.data.mapping.DataItemMappingBO;
import com.jxdinfo.hussar.formdesign.codegenerator.core.data.model.ComponentReference;
import com.jxdinfo.hussar.formdesign.codegenerator.core.util.DataConfigUtil;
import com.jxdinfo.hussar.formdesign.common.ctx.Ctx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ComponentData;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class ApiInvoke {
    private ApiActionModel action;
    private Ctx ctx;

    public abstract WebTemplateParam buildWebParam() throws LcdpException;

    protected ApiInvoke(Ctx ctx, ApiActionModel action) {
        this.action = action;
        this.ctx = ctx;
    }

    protected ApiRequestParam build(Map<String, ApiDatasetIdName> datasetId2Name) throws LcdpException {
        List<ApiParamModel> paramConfigs = this.action.getParamConfigs();
        ApiRequestParam apiRequestParam = new ApiRequestParam(this.action.getName());
        for (ApiParamModel paramConfig : paramConfigs) {
            if (!datasetId2Name.containsKey(paramConfig.getCurrentData())) continue;
            if (datasetId2Name.get(paramConfig.getCurrentData()).getFromBody()) {
                ApiBodyTypeParam bodyParam = this.bodyObjectTypeHandle(datasetId2Name, paramConfig);
                apiRequestParam.setBodyParam(bodyParam);
                continue;
            }
            if (paramConfig.getCurrentDataType().equals("object") || paramConfig.getCurrentDataType().equals("array")) {
                ApiObjectTypeParam apiObjectTypeParam = this.noBaseTypeHandle(datasetId2Name, paramConfig);
                apiRequestParam.getNoBaseTypeParams().add(apiObjectTypeParam);
                continue;
            }
            ApiBaseTypeParam apiBaseTypeParam = this.baseTypeHandle(datasetId2Name, paramConfig);
            apiRequestParam.getApiBaseTypeParams().add(apiBaseTypeParam);
        }
        return apiRequestParam;
    }

    private ApiBodyTypeParam bodyObjectTypeHandle(Map<String, ApiDatasetIdName> datasetId2Name, ApiParamModel paramConfig) throws LcdpException {
        ComponentData dataConfigValue = DataConfigUtil.getDataConfigValue((Ctx)this.ctx, (ComponentReference)paramConfig.getComponentReference());
        if (dataConfigValue == null) {
            dataConfigValue = new ComponentData(ComponentData.DataTypeEnum.STRING, ComponentData.DataItemSourceEnum.READONLY, "''");
        }
        ApiBodyTypeParam apiObjectTypeParam = this.buildApiBodyTypeParam(paramConfig.getCurrentDataType(), dataConfigValue.getRenderValue());
        if (paramConfig.getMapping().size() > 0) {
            Map<String, String> componentId2JsVariable = MappingUtils.getFieldMapping(paramConfig.getComponentReference(), this.ctx);
            List<DataItemMappingBO<String>> componentId2DatasetId = paramConfig.getMapping();
            List<DataItemMappingBO<String>> jsVariable2DatasetNameList = MappingUtils.getDataItemMappingBOS(componentId2DatasetId, componentId2JsVariable, this.datasetId2NameTransfer(datasetId2Name));
            jsVariable2DatasetNameList.forEach(jsVariable2DatasetName -> apiObjectTypeParam.getApiBaseTypeParams().add(new ApiBaseTypeParam((String)jsVariable2DatasetName.getToDataItem(), (String)jsVariable2DatasetName.getFromDataItem())));
        }
        return apiObjectTypeParam;
    }

    private ApiObjectTypeParam noBaseTypeHandle(Map<String, ApiDatasetIdName> datasetId2Name, ApiParamModel paramConfig) throws LcdpException {
        ComponentData dataConfigValue = DataConfigUtil.getDataConfigValue((Ctx)this.ctx, (ComponentReference)paramConfig.getComponentReference());
        if (dataConfigValue == null) {
            dataConfigValue = new ComponentData(ComponentData.DataTypeEnum.STRING, ComponentData.DataItemSourceEnum.READONLY, "''");
        }
        ApiObjectTypeParam apiObjectTypeParam = this.buildApiNoBaseTypeParam(paramConfig, datasetId2Name, dataConfigValue.getRenderValue());
        if (paramConfig.getMapping().size() > 0) {
            Map<String, String> componentId2JsVariable = MappingUtils.getFieldMapping(paramConfig.getComponentReference(), this.ctx);
            List<DataItemMappingBO<String>> componentId2DatasetId = paramConfig.getMapping();
            List<DataItemMappingBO<String>> jsVariable2DatasetNameList = MappingUtils.getDataItemMappingBOS(componentId2DatasetId, componentId2JsVariable, this.datasetId2NameTransfer(datasetId2Name));
            jsVariable2DatasetNameList.forEach(jsVariable2DatasetName -> apiObjectTypeParam.getApiBaseTypeParams().add(new ApiBaseTypeParam((String)jsVariable2DatasetName.getToDataItem(), (String)jsVariable2DatasetName.getFromDataItem())));
        }
        return apiObjectTypeParam;
    }

    private ApiObjectTypeParam buildApiNoBaseTypeParam(ApiParamModel paramConfig, Map<String, ApiDatasetIdName> datasetId2Name, String dataConfigValue) {
        ApiObjectTypeParam apiObjectTypeParam = new ApiObjectTypeParam();
        apiObjectTypeParam.setJsVariable(dataConfigValue);
        apiObjectTypeParam.setDataSetName(datasetId2Name.get(paramConfig.getCurrentData()).getName());
        apiObjectTypeParam.setParentDataSetNames("");
        apiObjectTypeParam.setDatasetType(paramConfig.getCurrentDataType());
        apiObjectTypeParam.setApiBaseTypeParams(new ArrayList<ApiBaseTypeParam>());
        return apiObjectTypeParam;
    }

    private ApiBodyTypeParam buildApiBodyTypeParam(String currentDataType, String dataConfigValue) {
        ApiBodyTypeParam apiObjectTypeParam = new ApiBodyTypeParam();
        apiObjectTypeParam.setJsVariable(dataConfigValue);
        apiObjectTypeParam.setParentDataSetNames("");
        apiObjectTypeParam.setDatasetType(currentDataType);
        apiObjectTypeParam.setApiBaseTypeParams(new ArrayList<ApiBaseTypeParam>());
        return apiObjectTypeParam;
    }

    private Map<String, String> datasetId2NameTransfer(Map<String, ApiDatasetIdName> datasetId2Name) {
        if (CollectionUtil.isEmpty(datasetId2Name)) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> res = new HashMap<String, String>();
        datasetId2Name.entrySet().forEach(entry -> res.put((String)entry.getKey(), ((ApiDatasetIdName)entry.getValue()).getName()));
        return res;
    }

    private ApiBaseTypeParam baseTypeHandle(Map<String, ApiDatasetIdName> datasetId2Name, ApiParamModel paramConfig) throws LcdpException {
        ComponentData dataConfigValue = DataConfigUtil.getDataConfigValue((Ctx)this.ctx, (ComponentReference)paramConfig.getComponentReference());
        if (dataConfigValue == null) {
            dataConfigValue = new ComponentData(ComponentData.DataTypeEnum.STRING, ComponentData.DataItemSourceEnum.READONLY, "''");
        }
        ApiBaseTypeParam apiBaseTypeParam = new ApiBaseTypeParam();
        apiBaseTypeParam.setDataSetName(datasetId2Name.get(paramConfig.getCurrentData()).getName());
        apiBaseTypeParam.setJsVariable(dataConfigValue.getRenderValue());
        return apiBaseTypeParam;
    }

    public ApiActionModel getAction() {
        return this.action;
    }

    public Ctx getCtx() {
        return this.ctx;
    }
}

