/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.base.common.event.apiInvoke;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.back.model.ApiDataSourceTypeEnum;
import com.jxdinfo.hussar.formdesign.back.model.DataModelBase;
import com.jxdinfo.hussar.formdesign.back.model.apiModel.ThirdPartyApi.ThirdPartyApiDataModel;
import com.jxdinfo.hussar.formdesign.back.model.apiModel.localApi.LocalApiDataModel;
import com.jxdinfo.hussar.formdesign.base.common.event.apiInvoke.ApiInvokeFactory;
import com.jxdinfo.hussar.formdesign.base.common.event.apiInvoke.entity.ApiInvoke;
import com.jxdinfo.hussar.formdesign.base.common.event.apiInvoke.entity.LocalApiInvoke;
import com.jxdinfo.hussar.formdesign.base.common.event.apiInvoke.entity.ThirdPartyApiInvoke;
import com.jxdinfo.hussar.formdesign.base.common.event.apiInvoke.model.ApiActionModel;
import com.jxdinfo.hussar.formdesign.base.common.event.apiInvoke.templateParam.WebTemplateParam;
import com.jxdinfo.hussar.formdesign.base.common.utils.AsyncActionUtil;
import com.jxdinfo.hussar.formdesign.common.ctx.Ctx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.Action;
import com.jxdinfo.hussar.formdesign.common.render.RenderCore;
import com.jxdinfo.hussar.formdesign.common.render.RenderResult;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.visitor.ActionVisitor;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="Base.ApiInvokeAction")
public class ApiInvokeService
implements ActionVisitor {
    private static final String API_INVOKE_TFL_PATH = "/template/common/event/ApiInvoke.ftl";
    @Autowired
    private FileMappingService fileMappingService;

    public void visitor(Action action, Ctx ctx) throws Exception {
        List<ApiActionModel> apiActionModels = ApiInvokeFactory.getApiAction(action);
        for (ApiActionModel apiActionModel : apiActionModels) {
            JSONObject dataModelJson = DataModelUtil.getDataModelJson((String)apiActionModel.getModelId());
            DataModelBase apiDataModel = (DataModelBase)dataModelJson.toJavaObject(DataModelBase.class);
            ApiInvoke apiInvoke = ApiDataSourceTypeEnum.API.getValue().equals(apiDataModel.getDataSourceType()) ? new LocalApiInvoke(ctx, (LocalApiDataModel)dataModelJson.toJavaObject(LocalApiDataModel.class), apiActionModel) : new ThirdPartyApiInvoke(ctx, (ThirdPartyApiDataModel)dataModelJson.toJavaObject(ThirdPartyApiDataModel.class), apiActionModel);
            WebTemplateParam webTemplateParam = apiInvoke.buildWebParam();
            String trigger = action.getTrigger();
            String triggerName = action.getCurrentLcdpComponent().getInstanceKey() + ToolUtil.firstLetterToUpper((String)trigger);
            List bodies = action.getBodies();
            RenderResult renderResult = this.render(webTemplateParam, AsyncActionUtil.getAsyncBodyCode(bodies));
            if (renderResult.isStatus()) {
                ctx.addMethod(trigger, triggerName, renderResult.getRenderString());
            }
            ctx.addImports(this.getApiImportString(apiDataModel.getId(), apiDataModel.getName()));
        }
    }

    private String getApiImportString(String modelId, String modelName) throws LcdpException {
        String filePath = this.fileMappingService.getImportPath(modelId);
        String importTemplate = "import * as ${name} from \"${apiFilePath}\"";
        return importTemplate.replace("${name}", modelName).replace("${apiFilePath}", filePath);
    }

    private RenderResult render(WebTemplateParam webTemplateParam, String bodies) throws LcdpException {
        RenderCore renderCore = new RenderCore();
        renderCore.registerTemplatePath(API_INVOKE_TFL_PATH);
        HashMap<String, Object> map = new HashMap<String, Object>(webTemplateParam.toMap());
        map.put("asyncBodyCode", bodies);
        renderCore.registerParam(map);
        return renderCore.render();
    }
}

