/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.base.common.event;

import com.jxdinfo.hussar.formdesign.common.ctx.Ctx;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.Action;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.LcdpComponent;
import com.jxdinfo.hussar.formdesign.common.render.RenderCore;
import com.jxdinfo.hussar.formdesign.common.render.RenderResult;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.visitor.ActionVisitor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="Base.AddFormAction")
public class AddForm
implements ActionVisitor {
    private final FileMappingService fileMappingService;

    @Autowired
    public AddForm(FileMappingService fileMappingService) {
        this.fileMappingService = fileMappingService;
    }

    public void visitor(Action action, Ctx ctx) throws Exception {
        Boolean openTitle;
        HashMap<String, Object> moduleMap = new HashMap<String, Object>();
        RenderCore renderCore = new RenderCore();
        String pageType = ctx.getPageInfo().getType();
        if ("MobilePage".equals(pageType)) {
            renderCore.registerTemplatePath("/template/common/event/AddMobileForm.ftl");
        } else {
            renderCore.registerTemplatePath("/template/common/event/AddForm.ftl");
        }
        LcdpComponent myLcdpComponent = action.getCurrentLcdpComponent();
        String trigger = action.getTrigger();
        String triggerName = myLcdpComponent.getInstanceKey() + ToolUtil.firstLetterToUpper((String)trigger);
        moduleMap.put("trigger", triggerName);
        Map actionParams = action.getParamValues();
        Map params = (Map)actionParams.get("addForm");
        if (ToolUtil.isNotEmpty(actionParams.get("jumpType"))) {
            moduleMap.put("jumpType", actionParams.get("jumpType"));
        }
        if (ToolUtil.isNotEmpty((Object)(openTitle = (Boolean)actionParams.get("openTitle"))) && openTitle.booleanValue()) {
            moduleMap.put("openTitle", "true");
            if (ToolUtil.isNotEmpty(actionParams.get("draTitle"))) {
                moduleMap.put("draTitle", actionParams.get("draTitle"));
            }
        } else {
            moduleMap.put("openTitle", "false");
        }
        if (ToolUtil.isNotEmpty(actionParams.get("draSize"))) {
            moduleMap.put("draSize", actionParams.get("draSize"));
        }
        String pageName = ctx.getPageName();
        String instanceKey = myLcdpComponent.getInstanceKey();
        moduleMap.put("drawId", pageName + instanceKey);
        if (ToolUtil.isNotEmpty((Object)params)) {
            String id = (String)params.get("id");
            List routerParams = (List)params.get("params");
            if (ToolUtil.isNotEmpty((Object)id)) {
                String routerPath = FileUtil.posixPath((String[])new String[]{"${PREFIX.pathName}", this.fileMappingService.getFormatPath(id)});
                moduleMap.put("url", routerPath);
            }
            moduleMap.put("params", routerParams);
        }
        renderCore.registerParam(moduleMap);
        RenderResult renderResult = renderCore.render();
        if (renderResult.isStatus()) {
            ctx.addMethod(triggerName, renderResult.getRenderString());
        }
    }
}

