/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.base.common.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.datas.DataSConditionAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.datas.DataSConditionListAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.showconfig.ShowConfigAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.showconfig.ShowConfigItemInfo;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.showconfig.ShowConfigMappingAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.constant.DataConfigConstant;
import com.jxdinfo.hussar.formdesign.base.common.utils.EventUtil;
import com.jxdinfo.hussar.formdesign.base.common.utils.QueryAttrUtil;
import com.jxdinfo.hussar.formdesign.common.ctx.Ctx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.LcdpComponent;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class ReplaceDataUtil {
    private static FileMappingService fileMappingService = (FileMappingService)SpringUtil.getBean(FileMappingService.class);

    private ReplaceDataUtil() {
    }

    public static List<ShowConfigAnalysis> getReplaceDataInfo(LcdpComponent lcdpComponent, String editorFiled) {
        List tempShowConfigAnalyses;
        List showConfigAnalyses = null;
        JSONArray showConfigs = (JSONArray)lcdpComponent.getDatas().get(editorFiled);
        if (ToolUtil.isNotEmpty((Object)showConfigs) && ToolUtil.isNotEmpty((Object)(tempShowConfigAnalyses = JSON.parseArray((String)JSON.toJSONString((Object)showConfigs), ShowConfigAnalysis.class)))) {
            showConfigAnalyses = tempShowConfigAnalyses;
        }
        return showConfigAnalyses;
    }

    public static List<ShowConfigItemInfo> handlerShowConfigs(Ctx ctx, List<ShowConfigAnalysis> showConfigAnalyses) throws LcdpException, IOException {
        ArrayList<ShowConfigItemInfo> showConfigItemInfos = new ArrayList<ShowConfigItemInfo>();
        for (ShowConfigAnalysis showConfigAnalysis : showConfigAnalyses) {
            ShowConfigItemInfo showConfigItemInfo = new ShowConfigItemInfo();
            String modelId = showConfigAnalysis.getDataModelId();
            ReplaceDataUtil.setShowConfigImportInfo(ctx, showConfigItemInfo, modelId);
            showConfigItemInfo.setTableFieldWhere(showConfigAnalysis.getField());
            String showConfigType = showConfigAnalysis.getType();
            if ("CommonModel".equals(showConfigType)) {
                if (DataConfigConstant.CommonModelCategory.DICT.getVal().equals(showConfigAnalysis.getDataModelId())) {
                    showConfigItemInfo.setCommonModelType(showConfigAnalysis.getDataModelId());
                    showConfigItemInfo.setCommonModelField(showConfigAnalysis.getDictShowField());
                    showConfigItemInfo.setDictType(showConfigAnalysis.getDictType());
                    showConfigItemInfo.setImportMethod(DataConfigConstant.CommonModelCategory.DICT.getImportMethod());
                    showConfigItemInfo.setIsConfigComplete(showConfigAnalysis.isConfigComplete());
                }
            } else {
                ReplaceDataUtil.packageDataModelShowConfigInfo(ctx, showConfigAnalysis, showConfigItemInfo);
            }
            showConfigItemInfos.add(showConfigItemInfo);
        }
        return showConfigItemInfos;
    }

    private static void packageDataModelShowConfigInfo(Ctx ctx, ShowConfigAnalysis showConfigAnalysis, ShowConfigItemInfo showConfigItemInfo) throws LcdpException {
        List<ShowConfigMappingAnalysis> showConfigMappingAnalyses;
        DataSConditionAnalysis dataSConditionAnalysis = showConfigAnalysis.getCondition();
        if (ToolUtil.isNotEmpty((Object)dataSConditionAnalysis)) {
            List<DataSConditionListAnalysis> conditionList = dataSConditionAnalysis.getQueryConditionModelList();
            StringBuilder queryObjectAttr = QueryAttrUtil.getQueryAttr(conditionList, ctx);
            showConfigItemInfo.setQueryObjectAttr(queryObjectAttr.toString());
        }
        String showRelateField = showConfigAnalysis.getRelateField();
        showConfigItemInfo.setRelateTableFieldWhere(showRelateField);
        showConfigItemInfo.setIsConfigComplete(showConfigAnalysis.isConfigComplete());
        if (ToolUtil.isNotEmpty((Object)showConfigAnalysis.getCondition())) {
            String queryCondition = showConfigAnalysis.getCondition().getSelectCondition();
            StringBuilder stringBuilder = new StringBuilder(64);
            stringBuilder.append(Optional.ofNullable(showConfigAnalysis.getField()).orElse(""));
            if (ToolUtil.isNotEmpty((Object)showRelateField)) {
                stringBuilder.append(showRelateField);
            }
            if (ToolUtil.isNotEmpty((Object)queryCondition)) {
                stringBuilder.append(queryCondition);
            }
            if (stringBuilder.length() <= 0) {
                stringBuilder = new StringBuilder("ShowConfig");
            }
            showConfigItemInfo.setImportMethod(stringBuilder.toString());
        }
        if (ToolUtil.isNotEmpty(showConfigMappingAnalyses = showConfigAnalysis.getRelations())) {
            showConfigItemInfo.setMappingRelates(showConfigMappingAnalyses);
        }
    }

    private static void setShowConfigImportInfo(Ctx ctx, ShowConfigItemInfo showConfigItemInfo, String modelId) throws LcdpException, IOException {
        if (ToolUtil.isNotEmpty((Object)modelId) && ToolUtil.isNotEmpty((Object)DataModelUtil.getDataModelBase((String)modelId))) {
            String apiFileName = fileMappingService.getFileName(modelId);
            String apiFilePath = fileMappingService.getImportPath(modelId);
            if (ToolUtil.isNotEmpty((Object)apiFilePath) && ToolUtil.isNotEmpty((Object)apiFileName)) {
                EventUtil.addCtxImport(ctx, apiFileName, apiFilePath);
                showConfigItemInfo.setImportName(apiFileName);
            }
        }
    }
}

