/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.base.common.event;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.base.common.utils.ComponentDataUtil;
import com.jxdinfo.hussar.formdesign.base.common.utils.MappingUtils;
import com.jxdinfo.hussar.formdesign.codegenerator.core.action.Action;
import com.jxdinfo.hussar.formdesign.codegenerator.core.action.visitor.ActionVisitor;
import com.jxdinfo.hussar.formdesign.codegenerator.core.component.LcdpComponent;
import com.jxdinfo.hussar.formdesign.codegenerator.core.ctx.Ctx;
import com.jxdinfo.hussar.formdesign.codegenerator.core.data.constant.DataFromEnum;
import com.jxdinfo.hussar.formdesign.codegenerator.core.data.mapping.DataItemMappingBO;
import com.jxdinfo.hussar.formdesign.codegenerator.core.data.model.ComponentReference;
import com.jxdinfo.hussar.formdesign.codegenerator.core.model.ComponentData;
import com.jxdinfo.hussar.formdesign.codegenerator.core.util.DataConfigUtil;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component(value="Base.AssignmentAction")
public class Assignment
implements ActionVisitor {
    private static final String MAPPING_KEY = "mapping";

    public void visitor(Action action, Ctx ctx) throws Exception {
        LcdpComponent myLcdpComponent = action.getCurrentLcdpComponent();
        String trigger = action.getTrigger();
        String triggerName = myLcdpComponent.getInstanceKey() + ToolUtil.firstLetterToUpper((String)trigger);
        Map allParams = action.getParamValues();
        JSONObject params = (JSONObject)allParams.get("assignmentValue");
        if (ToolUtil.isEmpty((Object)params)) {
            return;
        }
        ComponentReference from = (ComponentReference)JSON.parseObject((String)params.getString("from"), ComponentReference.class);
        JSONArray mapping = params.getJSONArray(MAPPING_KEY);
        List mapsList = mapping.toJavaList(DataItemMappingBO.class);
        ComponentReference to = (ComponentReference)JSON.parseObject((String)params.getString("to"), ComponentReference.class);
        to.setType(DataFromEnum.INSTANCE.getValue());
        ComponentData toComponentData = DataConfigUtil.getDataConfigValue((Ctx)ctx, (ComponentReference)to);
        ComponentData fromComponentData = DataConfigUtil.getDataConfigValue((Ctx)ctx, (ComponentReference)from);
        Map<String, Object> resultMap = MappingUtils.getMappingResult(ctx, mapsList, from, to);
        if (this.isComponentDataEmpty(fromComponentData).booleanValue()) {
            resultMap.put("fromDataItem", fromComponentData.getRenderValue());
            resultMap.put("fromDataType", fromComponentData.getDataType().getValue());
        }
        if (this.isComponentDataEmpty(toComponentData).booleanValue()) {
            resultMap.put("toDataItem", toComponentData.getRenderValue());
            resultMap.put("toDataType", toComponentData.getDataType().getValue());
        }
        resultMap.put("instanceKey", myLcdpComponent.getInstanceKey());
        resultMap.put("data_convert", RenderUtil.renderTemplate((String)"/template/common/dataitem/data_convert_mapping.ftl", resultMap));
        ctx.addMethod(triggerName, RenderUtil.renderTemplate((String)"/template/common/event/Assignment.ftl", resultMap));
        ComponentDataUtil.renderTreeMethod(myLcdpComponent, ctx, resultMap);
    }

    private Boolean isComponentDataEmpty(ComponentData componentData) {
        Boolean isOk = true;
        if (ToolUtil.isNotEmpty((Object)componentData)) {
            if ("".equals(componentData.getRenderValue())) {
                isOk = false;
            }
            if (ToolUtil.isEmpty((Object)componentData.getDataType()) || "".equals(componentData.getDataType().getValue())) {
                isOk = false;
            }
        } else {
            isOk = false;
        }
        return isOk;
    }
}

